/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.packets;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import xerca.xercapaint.Mod;
import xerca.xercapaint.PaletteUtil;
import xerca.xercapaint.entity.EntityEasel;
import xerca.xercapaint.item.ItemCanvas;
import xerca.xercapaint.item.ItemPalette;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler
implements ServerPlayNetworking.PlayChannelHandler {
    /*
     * Enabled aggressive block sorting
     */
    public static void processMessage(CanvasUpdatePacket msg, class_3222 pl) {
        class_1799 palette;
        class_1799 canvas;
        class_1297 entityEasel = null;
        if (msg.getEaselId() > -1) {
            entityEasel = pl.method_37908().method_8469(msg.getEaselId());
            if (entityEasel == null) {
                Mod.LOGGER.error("CanvasUpdatePacketHandler: Easel entity not found! easelId: {}", (Object)msg.getEaselId());
                return;
            }
            if (!(entityEasel instanceof EntityEasel)) {
                Mod.LOGGER.error("CanvasUpdatePacketHandler: Entity found is not an easel! easelId: {}", (Object)msg.getEaselId());
                return;
            }
            EntityEasel easel = (EntityEasel)entityEasel;
            canvas = easel.getItem();
            if (!(canvas.method_7909() instanceof ItemCanvas)) {
                Mod.LOGGER.error("CanvasUpdatePacketHandler: Canvas not found inside easel!");
                return;
            }
            class_1799 mainHandItem = pl.method_6047();
            class_1799 offHandItem = pl.method_6079();
            if (mainHandItem.method_7909() instanceof ItemPalette) {
                palette = mainHandItem;
            } else {
                if (!(offHandItem.method_7909() instanceof ItemPalette)) {
                    Mod.LOGGER.error("CanvasUpdatePacketHandler: Palette not found on player's hands!");
                    return;
                }
                palette = offHandItem;
            }
        } else {
            canvas = pl.method_6047();
            palette = pl.method_6079();
            if (canvas.method_7909() instanceof ItemPalette) {
                class_1799 temp = canvas;
                canvas = palette;
                palette = temp;
            }
        }
        if (!canvas.method_7960() && canvas.method_7909() instanceof ItemCanvas) {
            class_2487 comp = canvas.method_7948();
            comp.method_10539("pixels", msg.getPixels());
            comp.method_10582("name", msg.getName());
            comp.method_10569("v", msg.getVersion());
            comp.method_10569("generation", 0);
            if (msg.getSigned()) {
                comp.method_10582("author", pl.method_5477().getString());
                comp.method_10582("title", msg.getTitle().trim());
                comp.method_10569("generation", 1);
            }
            if (!palette.method_7960() && palette.method_7909() == Items.ITEM_PALETTE) {
                class_2487 paletteComp = palette.method_7948();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            if (entityEasel instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entityEasel;
                easel.setItem(canvas, false);
                easel.setPainter(null);
            }
            Mod.LOGGER.debug("Handling canvas update: Name: {} V: {}", (Object)msg.getName(), (Object)msg.getVersion());
        }
    }

    public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        CanvasUpdatePacket packet = CanvasUpdatePacket.decode(buf);
        if (packet != null) {
            server.execute(() -> CanvasUpdatePacketHandler.processMessage(packet, player));
        }
    }
}

