/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.packets;

import java.util.Arrays;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.PaletteUtil;
import xerca.xercapaint.entity.EntityEasel;

public class CanvasUpdatePacket {
    private PaletteUtil.CustomColor[] paletteColors;
    private int[] pixels;
    private boolean signed;
    private String title;
    private CanvasType canvasType;
    private String name;
    private int version;
    private int easelId;
    private boolean messageIsValid;

    public CanvasUpdatePacket(int[] pixels, boolean signed, String title, String name, int version, EntityEasel easel, PaletteUtil.CustomColor[] paletteColors, CanvasType canvasType) {
        this.paletteColors = Arrays.copyOfRange(paletteColors, 0, 12);
        this.signed = signed;
        this.title = title;
        this.name = name;
        this.version = version;
        this.canvasType = canvasType;
        int area = CanvasType.getHeight(canvasType) * CanvasType.getWidth(canvasType);
        this.pixels = Arrays.copyOfRange(pixels, 0, area);
        this.easelId = easel == null ? -1 : easel.method_5628();
    }

    public CanvasUpdatePacket() {
        this.messageIsValid = false;
    }

    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        for (PaletteUtil.CustomColor color : this.paletteColors) {
            color.writeToBuffer(buf);
        }
        buf.writeInt(this.easelId);
        buf.writeByte(this.canvasType.ordinal());
        buf.writeInt(this.version);
        buf.method_10814(this.name);
        buf.method_10814(this.title);
        buf.writeBoolean(this.signed);
        buf.method_10806(this.pixels);
        return buf;
    }

    public static CanvasUpdatePacket decode(class_2540 buf) {
        CanvasUpdatePacket result = new CanvasUpdatePacket();
        try {
            result.paletteColors = new PaletteUtil.CustomColor[12];
            for (int i = 0; i < result.paletteColors.length; ++i) {
                result.paletteColors[i] = new PaletteUtil.CustomColor(buf);
            }
            result.easelId = buf.readInt();
            result.canvasType = CanvasType.fromByte(buf.readByte());
            result.version = buf.readInt();
            result.name = buf.method_10800(64);
            result.title = buf.method_10800(32);
            result.signed = buf.readBoolean();
            int area = CanvasType.getHeight(result.canvasType) * CanvasType.getWidth(result.canvasType);
            result.pixels = buf.method_10799(area);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading CanvasUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public PaletteUtil.CustomColor[] getPaletteColors() {
        return this.paletteColors;
    }

    public boolean getSigned() {
        return this.signed;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getEaselId() {
        return this.easelId;
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

