/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.IntPredicate;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class MulticonnectCompatibility {
    private static final boolean MULTICONNECT_LOADED = ModLoaderUtils.isModLoaded("multiconnect");
    public static final MulticonnectCompatibility INSTANCE = new MulticonnectCompatibility();
    private final Optional<Class<?>> multiconnectApiClass;
    private final Optional<Method> instanceMethod;
    private final Optional<Method> protocolVersion;
    private boolean enabled = MULTICONNECT_LOADED;

    private MulticonnectCompatibility() {
        if (this.enabled) {
            this.multiconnectApiClass = ReflectionUtils.getClass("net.earthcomputer.multiconnect.api.MultiConnectAPI");
            this.instanceMethod = ReflectionUtils.getMethod(this.multiconnectApiClass, "instance", new Class[0]);
            this.protocolVersion = ReflectionUtils.getMethod(this.multiconnectApiClass, "getProtocolVersion", new Class[0]);
        } else {
            this.multiconnectApiClass = Optional.empty();
            this.instanceMethod = Optional.empty();
            this.protocolVersion = Optional.empty();
        }
    }

    public <T> T getProtocolDependentValue(IntPredicate protocolPredicate, T trueValue, T defaultValue) {
        if (this.enabled) {
            return (T)this.instanceMethod.flatMap(m -> this.protocolVersion.map(f -> {
                try {
                    return protocolPredicate.test((Integer)f.invoke(m.invoke(null, new Object[0]), new Object[0])) ? trueValue : defaultValue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return defaultValue;
                }
            })).orElse(defaultValue);
        }
        return defaultValue;
    }
}

