/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.class_2428;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class WarningIndicator
implements Indicator {
    public static final WarningIndicator INSTANCE = new WarningIndicator();
    private boolean miniHUD = false;
    private boolean cWarning = false;
    private boolean cMsl = false;
    public EnumMap<EngineVehicle.Cautions, Boolean> cMap = new EnumMap(EngineVehicle.Cautions.class);

    public WarningIndicator() {
        for (EngineVehicle.Cautions c : EngineVehicle.Cautions.values()) {
            this.cMap.compute(c, (cautions, v) -> false);
        }
    }

    @Override
    public void update(class_310 client, EngineVehicle aircraft) {
        if (!aircraft.method_37908().field_9236 || client.method_1493()) {
            return;
        }
        if (aircraft.mslWarning > 0) {
            if (OverlayRenderer.INSTANCE.tick % 10 == 0) {
                boolean bl = this.cMsl = !this.cMsl;
            }
            if (OverlayRenderer.INSTANCE.tick % 5 == 0) {
                aircraft.method_37908().method_8486(aircraft.method_23317(), aircraft.method_23318() + (double)aircraft.method_17682() * 0.5, aircraft.method_23321(), (class_3414)class_3417.field_14622.comp_349(), aircraft.method_5634(), 1.0f, class_2428.method_49818((int)24), false);
                aircraft.method_37908().method_8486(aircraft.method_23317(), aircraft.method_23318() + (double)aircraft.method_17682() * 0.5, aircraft.method_23321(), (class_3414)class_3417.field_14622.comp_349(), aircraft.method_5634(), 1.0f, class_2428.method_49818((int)22), false);
            }
        } else {
            this.cMsl = false;
        }
        if (aircraft.mainWarning > 0) {
            if (OverlayRenderer.INSTANCE.tick % 10 == 0) {
                boolean bl = this.cWarning = !this.cWarning;
                if (!this.cMsl) {
                    aircraft.method_37908().method_8486(aircraft.method_23317(), aircraft.method_23318() + (double)aircraft.method_17682() * 0.5, aircraft.method_23321(), (class_3414)class_3417.field_18311.comp_349(), aircraft.method_5634(), 1.0f, class_2428.method_49818((int)(this.cWarning ? 16 : 24)), false);
                }
            }
        } else {
            this.cWarning = false;
        }
        for (EngineVehicle.Cautions c : EngineVehicle.Cautions.values()) {
            if (aircraft.cautions.get((Object)c) > 0) {
                if (OverlayRenderer.INSTANCE.tick % 15 == 0) {
                    this.cMap.compute(c, (cautions, v) -> Boolean.FALSE.equals(v));
                }
                if (aircraft.mainWarning != 0 || aircraft.mslWarning != 0 || OverlayRenderer.INSTANCE.tick % 60 != 0) continue;
                aircraft.method_37908().method_8486(aircraft.method_23317(), aircraft.method_23318() + (double)aircraft.method_17682() * 0.5, aircraft.method_23321(), (class_3414)class_3417.field_18311.comp_349(), aircraft.method_5634(), 1.0f, class_2428.method_49818((int)5), false);
                continue;
            }
            this.cMap.put(c, false);
        }
    }

    @Override
    public void drawDashboard(class_332 context, class_310 client, int baseX, int baseY, EngineVehicle aircraft, int color) {
        this.miniHUD = true;
        this.drawHUD(context, client, baseX, baseY - 18, 100, aircraft, color, null);
        this.miniHUD = false;
    }

    @Override
    public void drawHUD(class_332 context, class_310 client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        if (this.cMsl) {
            int n = client.field_1772.method_1727("[MISSILE]") / 4;
            Objects.requireNonNull(client.field_1772);
            if (this.edgeCheck(edge, n, 9 / 2, baseX + 1, baseY)) {
                StringDrawer.drawString8(context, client, "[MISSILE]", baseX + 1, baseY, color, this.miniHUD);
            }
        } else if (this.cWarning) {
            int n = client.field_1772.method_1727("[WARNING]") / 4;
            Objects.requireNonNull(client.field_1772);
            if (this.edgeCheck(edge, n, 9 / 2, baseX + 1, baseY)) {
                StringDrawer.drawString8(context, client, "[WARNING]", baseX + 1, baseY, color, this.miniHUD);
            }
        }
        if (!this.cMap.containsValue(true)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        this.cMap.forEach((caution, v) -> {
            if (v.booleanValue()) {
                builder.append('[').append(caution.name().toUpperCase().replace('_', ' ')).append(']');
            }
        });
        String s = builder.toString();
        int n = client.field_1772.method_1727(s) / 4;
        Objects.requireNonNull(client.field_1772);
        if (this.edgeCheck(edge, n, 9 / 2, baseX + 1, baseY)) {
            StringDrawer.drawString2(context, client, s, baseX + 1, baseY, color, this.miniHUD);
        }
    }

    @Override
    public void drawDials(class_332 context, class_310 client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        context.method_25294(baseX - 14, baseY - 37, baseX + 14 + 1, baseY + 37 + 1, Colors.colorBG);
        context.method_25294(baseX - 14, baseY - 37, baseX + 14 + 1, baseY - 35, Colors.colorFG);
        context.method_25294(baseX - 14, baseY - 37, baseX - 12, baseY + 37 + 1, Colors.colorFG);
        context.method_25294(baseX - 14, baseY + 35 + 1, baseX + 14 + 1, baseY + 37 + 1, Colors.colorFG);
        context.method_25294(baseX + 12 + 1, baseY - 37, baseX + 14 + 1, baseY + 37 + 1, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX, baseY - 32, 1, true, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX, baseY + 32, 1, false, Colors.colorFG);
        context.method_25294(baseX - 11, baseY - 26, baseX + 11 + 1, baseY - 6 + 1, Colors.colorFG);
        context.method_25294(baseX - 10, baseY - 25, baseX + 10 + 1, baseY - 7 + 1, this.cWarning ? Colors.colorLt1 : Colors.colorLt0);
        StringDrawer.drawString5(context, client, "MAIN", baseX + 2, baseY - 16, Colors.colorLt3, false);
        context.method_25294(baseX - 11, baseY - 2, baseX + 11 + 1, baseY + 10 + 1, Colors.colorFG);
        context.method_25294(baseX - 10, baseY - 1, baseX + 10 + 1, baseY + 9 + 1, this.cMap.get((Object)EngineVehicle.Cautions.VOID) != false ? Colors.colorLt2 : Colors.colorLt0);
        StringDrawer.drawString5(context, client, "VOID", baseX + 2, baseY + 4, Colors.colorLt3, false);
        context.method_25294(baseX - 11, baseY + 14, baseX + 11 + 1, baseY + 26 + 1, Colors.colorFG);
        context.method_25294(baseX - 10, baseY + 15, baseX + 10 + 1, baseY + 25 + 1, this.cMap.get((Object)EngineVehicle.Cautions.DAMAGED) != false ? Colors.colorLt2 : Colors.colorLt0);
        StringDrawer.drawString5(context, client, "DMG", baseX + 2, baseY + 20, Colors.colorLt3, false);
    }
}

