/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SpeedIndicator
implements Indicator {
    public static final SpeedIndicator INSTANCE = new SpeedIndicator();
    private class_243 lastSpeed = new class_243(0.0, 0.0, 0.0);
    private class_243 iSpeed = new class_243(0.0, 0.0, 0.0);
    private class_243 iSpeedRt = new class_243(0.0, 0.0, 0.0);
    private class_243 mSpeed = new class_243(0.0, 0.0, 0.0);
    private class_243 dir = new class_243(0.0, 0.0, 0.0);
    private static final int widthHalf = 100;
    private static final int bHeightHalf = 35;

    @Override
    public void update(class_310 client, EngineVehicle aircraft) {
        class_243 speed = aircraft.getSpeedVector().method_1021(20.0);
        this.dir = class_243.method_1034((class_241)aircraft.method_5802());
        if (!speed.equals((Object)this.lastSpeed)) {
            this.iSpeed = speed.method_1019(this.lastSpeed.method_22882());
            this.iSpeedRt = this.iSpeed.method_1021(-0.03333333507180214);
            this.lastSpeed = speed;
        }
        if (this.iSpeed.method_1019(this.iSpeedRt).method_1026(this.iSpeed) > 0.0) {
            this.iSpeed = this.iSpeed.method_1019(this.iSpeedRt);
        } else {
            this.iSpeed = new class_243(0.0, 0.0, 0.0);
            this.iSpeedRt = new class_243(0.0, 0.0, 0.0);
        }
        this.mSpeed = this.lastSpeed.method_1019(this.iSpeed.method_22882());
    }

    @Override
    public void drawDashboard(class_332 context, class_310 client, int baseX, int baseY, EngineVehicle aircraft, int color) {
        StringDrawer.drawString1(context, client, String.format("AS %2.1f", this.lastSpeed.method_1026(this.dir)), baseX - 100, baseY, color, true);
    }

    @Override
    public void drawHUD(class_332 context, class_310 client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        for (int i = -35; i < 35; i += 5) {
            if (!this.edgeCheck(edge, 2, baseX - 3, baseY + i * width / 100)) continue;
            OverlayRenderer.renderLine(context, baseX - 3, baseY + i * width / 100 - 1, baseX - 3, baseY + (i + 5) * width / 100 + 1, color);
        }
        if (this.edgeCheck(edge, 5, baseX, baseY)) {
            Objects.requireNonNull(client.field_1772);
            StringDrawer.drawString6(context, client, "AS", baseX - 10, baseY - 9, color, false);
            StringDrawer.drawString6(context, client, String.format("[%2.1f}-", this.lastSpeed.method_1026(this.dir)), baseX, baseY, color, false);
        }
        int iz = Double.valueOf(this.mSpeed.method_1026(this.dir) * 10.0).intValue();
        int nearest1_10 = Math.floorDiv(iz, 10);
        PrimitiveIterator.OfInt it = IntStream.range(nearest1_10 - 5, nearest1_10 + 6).iterator();
        while (it.hasNext()) {
            String vp;
            int v = (Integer)it.next();
            Object object = v % 10 == 0 ? (v == nearest1_10 ? "\u2500" : "\u00b7" + String.valueOf(v / 10) + "\u00b7") : (vp = v % 5 == 0 ? "\u2500" : "-");
            int yy = baseY + (iz - v * 10) * width / 100;
            if (!this.edgeCheck(edge, 5, baseX, yy)) continue;
            StringDrawer.drawString6(context, client, vp, baseX, yy, color, false);
        }
    }

    @Override
    public void drawDials(class_332 context, class_310 client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        float angle;
        context.method_25294(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        class_243 scale0 = new class_243(0.0, (double)(25 * scale), 0.0);
        class_243 scale1 = new class_243(0.0, (double)(22 * scale), 0.0);
        class_243 scale2 = new class_243(0.0, (double)(20 * scale), 0.0);
        class_243 scale3 = new class_243(0.0, (double)(16 * scale), 0.0);
        for (int i = 0; i < 60; ++i) {
            angle = -((float)Math.toRadians(6.0f * (float)i));
            class_243 sa = scale0.method_31033(angle);
            class_243 sb = i % 10 == 0 ? scale2.method_31033(angle) : scale1.method_31033(angle);
            OverlayRenderer.renderLine(context, baseX + (int)sa.field_1352, baseY + (int)sa.field_1351, baseX + (int)sb.field_1352, baseY + (int)sb.field_1351, Colors.colorFG);
            if (i % 10 != 0) continue;
            class_243 sc = scale3.method_31033(angle);
            StringDrawer.drawString5(context, client, String.valueOf(i / 10), baseX + (int)sc.field_1352 + 2, baseY + (int)sc.field_1351 - 1, Colors.colorFG, false);
        }
        int iz = Double.valueOf(this.mSpeed.method_1026(this.dir) * 10.0).intValue();
        angle = -((float)Math.toRadians((float)iz * 0.6f));
        class_243 h1 = scale1.method_31033(angle);
        OverlayRenderer.renderLine(context, baseX, baseY, baseX + (int)h1.field_1352, baseY + (int)h1.field_1351, Colors.colorHD1, false, true);
        OverlayRenderer.drawDialOutline(context, baseX, baseY, scale);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "AS", baseX + 20 * scale + 1, baseY + 25 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 13;
            int y = baseY + 26;
            context.method_25294(x, y - 4, x + 1, y, Colors.colorFG);
            context.method_25294(x + 1, y - 5, x + 2, y - 4, Colors.colorFG);
            context.method_25294(x + 2, y - 4, x + 3, y, Colors.colorFG);
            context.method_25294(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            x = baseX + 16;
            y = baseY + 26;
            context.method_25294(x + 1, y - 5, x + 3, y - 4, Colors.colorFG);
            context.method_25294(x, y - 4, x + 1, y - 3, Colors.colorFG);
            context.method_25294(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            context.method_25294(x + 2, y - 3, x + 3, y - 1, Colors.colorFG);
            context.method_25294(x, y - 1, x + 2, y, Colors.colorFG);
        }
        context.method_25294(baseX - 3 * scale, baseY - 3 * scale, baseX + 3 * scale + 1, baseY + 3 * scale + 1, Colors.colorFG);
        context.method_25294(baseX - 2 * scale, baseY - 2 * scale, baseX + 2 * scale + 1, baseY + 2 * scale + 1, iz >= 0 && iz < 600 ? Colors.colorLt0 : Colors.colorLt1);
    }
}

