/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TeamMemberData {
    private int maxClaims;
    private int maxForceLoads;
    private boolean offlineForceLoader;
    private final Set<ChunkDimPos> originalClaims;

    private TeamMemberData(int maxClaims, int maxForceLoads, boolean offlineForceLoader, Set<ChunkDimPos> originalClaims) {
        this.maxClaims = maxClaims;
        this.maxForceLoads = maxForceLoads;
        this.offlineForceLoader = offlineForceLoader;
        this.originalClaims = originalClaims;
    }

    public static TeamMemberData defaultData() {
        return new TeamMemberData((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get(), (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get(), false, new HashSet<ChunkDimPos>());
    }

    public static TeamMemberData deserializeNBT(class_2487 tag) {
        int maxClaims = tag.method_10550("max_claimed_chunks");
        int maxForced = tag.method_10550("max_force_loaded_chunks");
        boolean offline = tag.method_10577("offline_force_loader");
        Set<ChunkDimPos> orig = TeamMemberData.readOriginalClaims(tag.method_10562("original_claims"));
        return new TeamMemberData(maxClaims, maxForced, offline, orig);
    }

    public static TeamMemberData fromPlayerData(class_3222 player, ChunkTeamDataImpl otherTeam) {
        return new TeamMemberData(otherTeam.getMaxClaimChunks() + otherTeam.getExtraClaimChunks(), otherTeam.getMaxForceLoadChunks() + otherTeam.getExtraForceLoadChunks(), FTBChunksWorldConfig.canPlayerOfflineForceload(player), new HashSet<ChunkDimPos>(otherTeam.getClaimedChunks().stream().map(ClaimedChunkImpl::getPos).toList()));
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10569("max_claimed_chunks", this.maxClaims);
        tag.method_10569("max_force_loaded_chunks", this.maxForceLoads);
        tag.method_10556("offline_force_loader", this.offlineForceLoader);
        class_2487 origTag = this.writeOriginalClaims();
        if (!origTag.method_33133()) {
            tag.method_10566("original_claims", (class_2520)origTag);
        }
        return tag;
    }

    private class_2487 writeOriginalClaims() {
        class_2487 origTag = new class_2487();
        HashMap<String, class_2499> perDimensionTags = new HashMap<String, class_2499>();
        this.originalClaims.forEach(cdp -> {
            class_2499 l = perDimensionTags.computeIfAbsent(cdp.dimension().method_29177().toString(), k -> new class_2499());
            SNBTCompoundTag cdpTag = new SNBTCompoundTag();
            cdpTag.singleLine();
            cdpTag.method_10569("x", cdp.x());
            cdpTag.method_10569("z", cdp.z());
            l.add((Object)cdpTag);
        });
        perDimensionTags.forEach((arg_0, arg_1) -> ((class_2487)origTag).method_10566(arg_0, arg_1));
        return origTag;
    }

    private static Set<ChunkDimPos> readOriginalClaims(class_2487 tag) {
        HashSet<ChunkDimPos> res = new HashSet<ChunkDimPos>();
        for (String dimStr : tag.method_10541()) {
            try {
                class_5321 dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimStr));
                HashSet cdpSet = new HashSet();
                tag.method_10554(dimStr, 10).forEach(el -> {
                    if (el instanceof class_2487) {
                        class_2487 c = (class_2487)el;
                        cdpSet.add(new ChunkDimPos(dimKey, c.method_10550("x"), c.method_10550("z")));
                    }
                });
                res.addAll(cdpSet);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public int getMaxClaims() {
        return this.maxClaims;
    }

    public void setMaxClaims(int maxClaims) {
        this.maxClaims = maxClaims;
    }

    public int getMaxForceLoads() {
        return this.maxForceLoads;
    }

    public void setMaxForceLoads(int maxForceLoads) {
        this.maxForceLoads = maxForceLoads;
    }

    public boolean isOfflineForceLoader() {
        return this.offlineForceLoader;
    }

    public void setOfflineForceLoader(boolean offlineForceLoader) {
        this.offlineForceLoader = offlineForceLoader;
    }

    public Set<ChunkDimPos> getOriginalClaims() {
        return this.originalClaims;
    }
}

