/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.minimap.components;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.minimap.TranslatedOption;
import dev.ftb.mods.ftblibrary.config.NameMap;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class RealTimeComponent
implements MinimapInfoComponent {
    public static final class_2960 ID = FTBChunksAPI.rl("real_time");

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void render(MinimapContext context, class_332 graphics, class_327 font) {
        String setting = context.getSetting(this);
        LocalDateTime now = LocalDateTime.now();
        int hours = now.getHour();
        int minutes = now.getMinute();
        this.drawCenteredText(font, graphics, (class_2561)class_2561.method_43470((String)RealTimeComponent.createTimeString(hours, minutes, setting.equals(TimeMode.TWENTY_FOUR.name()))), 0);
    }

    @Override
    public Set<TranslatedOption> getConfigComponents() {
        return Arrays.stream(TimeMode.values()).map(value -> new TranslatedOption(value.name(), "ftbchunks.time_mode." + TimeMode.NAME_MAP.getName((Object)value))).collect(Collectors.toSet());
    }

    static String createTimeString(int hours, int minutes, boolean twentyFourHourClock) {
        String ampm;
        if (twentyFourHourClock) {
            return String.format("%02d:%02d", hours, minutes);
        }
        String string = ampm = hours >= 12 ? "PM" : "AM";
        if (hours == 0) {
            hours = 12;
        } else if (hours > 12) {
            hours -= 12;
        }
        return String.format("%2d:%02d %s", hours, minutes, ampm);
    }

    public static enum TimeMode {
        TWENTY_FOUR,
        TWELVE;

        public static final NameMap<TimeMode> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)TWENTY_FOUR), (Object[])TimeMode.values()).baseNameKey("ftbchunks.time_mode").create();
        }
    }
}

