/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.image;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.render.image.EmptyImage;
import io.github.mortuusars.exposure.render.image.ExposureDataImage;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.render.image.TextureImage;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class RenderedImageProvider {
    public static final RenderedImageProvider EMPTY = new RenderedImageProvider(new EmptyImage());
    public static final RenderedImageProvider HIDDEN = new RenderedImageProvider(TextureImage.getTexture(Exposure.resource("textures/exposure/pack.png")));
    protected final IImage image;

    public RenderedImageProvider(IImage image) {
        this.image = image;
    }

    public static RenderedImageProvider fromFrame(class_2487 frame) {
        if ((Boolean)Config.Client.HIDE_PHOJECTED_PHOTOGRAPHS_MADE_BY_OTHERS.get() != false && frame.method_10577("Projected") ? class_310.method_1551().field_1724 != null && frame.method_10545("PhotographerId") && !frame.method_25926("PhotographerId").equals(class_310.method_1551().field_1724.method_5667()) : (Boolean)Config.Client.HIDE_ALL_PHOTOGRAPHS_MADE_BY_OTHERS.get() != false && class_310.method_1551().field_1724 != null && frame.method_10545("PhotographerId") && !frame.method_25926("PhotographerId").equals(class_310.method_1551().field_1724.method_5667())) {
            return HIDDEN;
        }
        Either<String, class_2960> idOrTexture = FrameData.getIdOrTexture(frame);
        @Nullable IImage image = (IImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureDataImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), TextureImage::getTexture);
        if (image != null) {
            return new RenderedImageProvider(image);
        }
        return EMPTY;
    }

    public IImage get() {
        return this.image;
    }

    public String getInstanceId() {
        return this.get().getImageId();
    }
}

