/*
 * Decompiled with CFR 0.152.
 */
package de.kxmischesdomi.more_axolotl.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5762;
import net.minecraft.class_746;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class AxolotlCatalogScreen
extends class_437 {
    public static final int startAge = 951753697;
    private static final class_2960 CATALOG = new class_2960("more-axolotl", "textures/gui/catalog.png");
    public final Map<class_5762.class_5767, class_5762> variants;
    private final int pages;
    private final class_1937 world;
    private int page;
    private class_474 nextPageButton;
    private class_474 previousPageButton;
    private class_2960 hoveredSummonButton = null;

    public AxolotlCatalogScreen(class_1937 world) {
        super((class_2561)class_2561.method_43473());
        this.world = world;
        this.variants = new HashMap<class_5762.class_5767, class_5762>();
        this.reloadAxolotl();
        this.pages = (int)Math.ceil((float)class_5762.class_5767.values().length / 2.0f) - 1;
        this.page = 0;
    }

    protected void method_25426() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(null)).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 2 + 100, 200, 20).method_46431());
        this.addPageButtons();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int uiWidth = 424;
        int uiHeight = 182;
        int bookWidth = 264;
        int bookHeight = 164;
        int x = (this.field_22789 - 424) / 2;
        int y = (this.field_22790 - 182) / 2;
        int midX = this.field_22789 / 2;
        int frameWidth = 103;
        int frameHeight = 45;
        int frameCenterY = 46 + y;
        int xOffset = -66;
        guiGraphics.method_25290(CATALOG, x, y, 0.0f, 0.0f, 424, 182, 424, 182);
        this.hoveredSummonButton = null;
        for (int i = 0; i < 2; ++i) {
            int variantOrdinal = i + this.page * 2;
            int pageCenterX = midX + xOffset;
            class_310 client = class_310.method_1551();
            if (class_5762.class_5767.values().length > variantOrdinal) {
                class_5250 title;
                String translationString;
                class_5762.class_5767 variant = class_5762.class_5767.values()[variantOrdinal];
                class_2960 location = new class_2960(variant.method_33238());
                int size = 50;
                this.renderAxolotl(guiGraphics, pageCenterX - 8, frameCenterY + size / 6, size, -60.0f, -40.0f, variant);
                class_1799 bucketStack = class_1802.field_28354.method_7854();
                class_2487 nbt = new class_2487();
                nbt.method_10582("Variant", location.toString());
                bucketStack.method_7980(nbt);
                int itemsX = pageCenterX + 51 - 16;
                int itemsY = frameCenterY + 22 - 16;
                guiGraphics.method_51445(bucketStack, itemsX, itemsY);
                itemsY -= 18;
                if (client.field_1724.method_7337()) {
                    class_1799 commandStack = class_1802.field_8866.method_7854();
                    guiGraphics.method_51445(commandStack, itemsX, itemsY);
                    if (mouseX >= itemsX && mouseX <= itemsX + 16 && mouseY >= itemsY && mouseY <= itemsY + 16) {
                        guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"Summon"), mouseX, mouseY);
                        this.hoveredSummonButton = location;
                    }
                }
                if (class_1074.method_4663((String)(translationString = "mavapi.variant." + location.method_12836() + "." + location.method_12832()))) {
                    title = class_2561.method_43471((String)translationString);
                } else {
                    Object name = location.method_12832().replace("_", "");
                    name = String.valueOf(((String)name).charAt(0)).toUpperCase(Locale.ROOT) + ((String)name).substring(1);
                    title = class_2561.method_43470((String)name);
                }
                Objects.requireNonNull(this.field_22793);
                this.renderAxolotlInfoText(guiGraphics, (class_2561)title, pageCenterX, frameCenterY + 22 - 9, 0, 1.0f, true);
                float scale = 0.7f;
                String decscriptionString = "more-axolotl.desc." + location.method_12836() + "." + location.method_12832();
                String[] stringArray = AxolotlCatalogScreen.getLinesOfMessage(decscriptionString);
                Objects.requireNonNull(this.field_22793);
                this.renderAxolotlInfoText(guiGraphics, stringArray, pageCenterX - 51 - 5, frameCenterY + 22 + 9, 0, scale, (int)(10.0f * scale));
            }
            xOffset = -xOffset;
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void renderPageIndicator(class_332 guiGraphics, int id, boolean right) {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        class_5250 rightPageIndicator = class_2561.method_43470((String)String.valueOf(id));
        guiGraphics.method_51439(this.field_22793, (class_2561)rightPageIndicator, right ? x - this.field_22793.method_27525((class_5348)rightPageIndicator) + 122 : x - 122, y - 78, 0, false);
    }

    public void addPageButtons() {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        this.nextPageButton = (class_474)this.method_37063((class_364)new class_474(x + 80 + 25, y + 65, true, button -> this.nextPage(), true));
        this.previousPageButton = (class_474)this.method_37063((class_364)new class_474(x - 105 - 25, y + 65, false, button -> this.previousPage(), true));
        this.updatePageButtons();
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.hoveredSummonButton != null && class_310.method_1551().field_1724.method_7337()) {
            String command = "summon minecraft:axolotl ~ ~ ~ {\"Variant\":'" + this.hoveredSummonButton.toString() + "'}";
            this.executeCommand(command);
        }
        return super.method_25402(d, e, i);
    }

    public void executeCommand(String s) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_310.method_1551().field_1724.field_3944.method_45730(s);
    }

    public void updatePageButtons() {
        this.nextPageButton.field_22764 = this.page < this.pages;
        this.previousPageButton.field_22764 = this.page > 0;
    }

    public void previousPage() {
        this.setPage(this.page - 1);
    }

    public void nextPage() {
        this.setPage(this.page + 1);
    }

    public void setPage(int newPage) {
        if (newPage > this.pages) {
            newPage = this.pages;
        } else if (newPage < 0) {
            newPage = 0;
        }
        this.page = newPage;
        this.reloadAxolotl();
        this.updatePageButtons();
    }

    public void renderAxolotl(class_332 guiGraphics, int x, int y, int size, float mouseX, float mouseY, class_5762.class_5767 variant) {
        class_5762 axolotlEntity = this.variants.get(variant);
        if (axolotlEntity.field_6012 == 951753697) {
            axolotlEntity.field_6012 = 0;
            for (int i = 0; i < 230; ++i) {
                class_490.method_2486((class_332)guiGraphics, (int)x, (int)(y + 1000), (int)size, (float)mouseX, (float)mouseY, (class_1309)axolotlEntity);
            }
        }
        class_490.method_2486((class_332)guiGraphics, (int)x, (int)y, (int)size, (float)mouseX, (float)mouseY, (class_1309)axolotlEntity);
    }

    public void reloadAxolotl() {
        this.variants.clear();
        for (int i = 0; i < 2; ++i) {
            int variantOrdinal = i + this.page * 2;
            if (class_5762.class_5767.values().length <= variantOrdinal) continue;
            class_5762.class_5767 variant = class_5762.class_5767.values()[variantOrdinal];
            this.variants.put(variant, AxolotlCatalogScreen.getEntityForVariant(variant, this.world));
        }
    }

    public void renderAxolotlInfoText(class_332 guiGraphics, String[] text, int x, int y, int color, float scale, int spacing) {
        this.renderAxolotlInfoText(guiGraphics, text, x, y, color, scale, spacing, false);
    }

    public void renderAxolotlInfoText(class_332 guiGraphics, String[] text, int x, int y, int color, float scale, int spacing, boolean centered) {
        try {
            for (String s : text) {
                this.renderAxolotlInfoText(guiGraphics, (class_2561)class_2561.method_43470((String)s), x, y, color, scale, centered);
                y += spacing;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renderAxolotlInfoText(class_332 guiGraphics, class_2561 text, int x, int y, int color, float scale) {
        this.renderAxolotlInfoText(guiGraphics, text, x, y, color, scale, false);
    }

    public void renderAxolotlInfoText(class_332 guiGraphics, class_2561 text, int x, int y, int color, float scale, boolean centered) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        if (centered) {
            x -= this.field_22793.method_27525((class_5348)text) / 2;
        }
        guiGraphics.method_51439(this.field_22793, text, (int)((float)x / scale), (int)((float)y / scale), color, false);
        guiGraphics.method_51448().method_22909();
    }

    public static String[] getLinesOfMessage(String key) {
        String translate = class_1074.method_4662((String)key, (Object[])new Object[0]);
        if (translate.equals(key)) {
            return new String[]{class_1074.method_4662((String)"more-axolotl.no-desc", (Object[])new Object[0])};
        }
        return translate.split("\n");
    }

    public static class_5762 getEntityForVariant(class_5762.class_5767 variant, class_1937 world) {
        class_5762 axolotlEntity = new class_5762(class_1299.field_28315, world);
        class_2487 nbt = new class_2487();
        nbt.method_10582("Variant", new class_2960(variant.method_33238()).toString());
        axolotlEntity.method_5749(nbt);
        axolotlEntity.method_5977(true);
        axolotlEntity.method_24830(true);
        axolotlEntity.field_6012 = 951753697;
        return axolotlEntity;
    }

    public boolean method_25421() {
        return false;
    }
}

