/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PokemonMeleeAttackGoal
extends class_1366 {
    public int ticksUntilNewAngerParticle = 0;
    public int ticksUntilNewAngerCry = 0;

    public PokemonMeleeAttackGoal(class_1314 mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
    }

    public void method_6268() {
        PokemonEntity pokemonEntity = (PokemonEntity)this.field_6503;
        class_1309 owner = pokemonEntity.method_35057();
        if (owner == null) {
            if (this.ticksUntilNewAngerParticle < 1) {
                CobblemonFightOrFlight.PokemonEmoteAngry((class_1308)this.field_6503);
                this.ticksUntilNewAngerParticle = 10;
            } else {
                --this.ticksUntilNewAngerParticle;
            }
            if (this.ticksUntilNewAngerCry < 1) {
                pokemonEntity.cry();
                this.ticksUntilNewAngerCry = 100 + (int)(Math.random() * 200.0);
            } else {
                --this.ticksUntilNewAngerCry;
            }
        }
        super.method_6268();
        if (!CobblemonFightOrFlight.config().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            this.field_6503.method_5942().method_6344(0.0);
        }
    }

    public boolean isTargetInBattle() {
        class_1309 class_13092 = this.field_6503.method_5968();
        if (class_13092 instanceof class_3222) {
            class_3222 targetAsPlayer = (class_3222)class_13092;
            return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(targetAsPlayer) != null;
        }
        return false;
    }

    public boolean shouldFightTarget() {
        PokemonEntity pokemonEntity = (PokemonEntity)this.field_6503;
        if (pokemonEntity.getPokemon().getLevel() < CobblemonFightOrFlight.config().minimum_attack_level) {
            return false;
        }
        class_1309 owner = pokemonEntity.method_35057();
        if (owner != null) {
            PokemonEntity targetPokemon;
            class_1309 targetOwner;
            if (!CobblemonFightOrFlight.config().do_pokemon_defend_owner) {
                return false;
            }
            if (this.field_6503.method_5968() == null || this.field_6503.method_5968() == owner) {
                return false;
            }
            class_1309 class_13092 = this.field_6503.method_5968();
            if (class_13092 instanceof PokemonEntity && (targetOwner = (targetPokemon = (PokemonEntity)class_13092).method_35057()) != null) {
                if (targetOwner == owner) {
                    return false;
                }
                if (!CobblemonFightOrFlight.config().do_player_pokemon_attack_other_player_pokemon) {
                    return false;
                }
            }
            if (this.field_6503.method_5968() instanceof class_1657 && !CobblemonFightOrFlight.config().do_player_pokemon_attack_other_players) {
                return false;
            }
        } else if (this.field_6503.method_5968() != null) {
            if (CobblemonFightOrFlight.getFightOrFlightCoefficient(pokemonEntity) <= 0.0) {
                return false;
            }
            class_1309 targetEntity = this.field_6503.method_5968();
            if (this.field_6503.method_5649(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()) > 400.0) {
                return false;
            }
        }
        return !pokemonEntity.isBusy();
    }

    public boolean method_6264() {
        return this.shouldFightTarget() && super.method_6264();
    }

    public boolean method_6266() {
        return this.shouldFightTarget() && super.method_6266();
    }

    protected void method_6288(class_1309 target, double distanceToSqr) {
        double d0 = this.method_6289(target);
        if (distanceToSqr <= d0 && this.method_28348() <= 0) {
            this.method_28346();
            this.field_6503.method_6104(class_1268.field_5808);
            this.pokemonDoHurtTarget((class_1297)target);
        }
    }

    public float calculatePokemonDamage(PokemonEntity pokemonEntity) {
        float maxAttack = Math.max(pokemonEntity.getPokemon().getAttack(), pokemonEntity.getPokemon().getSpecialAttack());
        maxAttack = Math.min(maxAttack, 255.0f);
        float minDmg = CobblemonFightOrFlight.config().minimum_attack_damage;
        float maxDmg = CobblemonFightOrFlight.config().maximum_attack_damage;
        return minDmg + (maxDmg - minDmg) * (maxAttack /= 255.0f);
    }

    public boolean pokemonDoHurtTarget(class_1297 hurtTarget) {
        if (!CobblemonFightOrFlight.config().do_pokemon_attack_in_battle && this.isTargetInBattle()) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)this.field_6503;
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (!this.pokemonTryForceEncounter(pokemonEntity, hurtTarget)) {
            boolean flag;
            int pkmLevel = pokemon.getLevel();
            ElementalType primaryType = pokemon.getPrimaryType();
            float hurtDamage = this.calculatePokemonDamage(pokemonEntity);
            float hurtKnockback = 1.0f;
            if (hurtTarget instanceof class_1309) {
                class_1309 livingHurtTarget = (class_1309)hurtTarget;
                int effectStrength = Math.max(pkmLevel / 10, 1);
                switch (primaryType.getName()) {
                    case "fire": {
                        livingHurtTarget.method_5639(effectStrength);
                        break;
                    }
                    case "ice": {
                        livingHurtTarget.method_32317(livingHurtTarget.method_32312() + effectStrength * 30);
                        break;
                    }
                    case "poison": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5899, effectStrength * 20, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "psychic": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5902, effectStrength * 20, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "fairy": 
                    case "fighting": 
                    case "steel": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5911, effectStrength * 20, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "ghost": 
                    case "dark": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_38092, (effectStrength + 2) * 25, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "ground": 
                    case "rock": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5901, (effectStrength + 2) * 25, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "electric": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, (effectStrength + 2) * 25, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "bug": {
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5903, (effectStrength + 2) * 25, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "grass": {
                        this.field_6503.method_37222(new class_1293(class_1294.field_5924, (effectStrength + 2) * 20, 0), (class_1297)this.field_6503);
                        break;
                    }
                    case "dragon": {
                        hurtDamage += 3.0f;
                        break;
                    }
                    case "flying": {
                        hurtKnockback *= 2.0f;
                        break;
                    }
                    case "water": {
                        hurtKnockback *= 2.0f;
                        livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, (effectStrength + 2) * 25, 0), (class_1297)this.field_6503);
                        break;
                    }
                }
            }
            if (flag = hurtTarget.method_5643(this.field_6503.method_37908().method_48963().method_48812((class_1309)this.field_6503), hurtDamage)) {
                if (hurtKnockback > 0.0f && hurtTarget instanceof class_1309) {
                    ((class_1309)hurtTarget).method_6005((double)(hurtKnockback * 0.5f), (double)class_3532.method_15374((float)(this.field_6503.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.field_6503.method_36454() * ((float)Math.PI / 180)))));
                    this.field_6503.method_18799(this.field_6503.method_18798().method_18805(0.6, 1.0, 0.6));
                }
                this.field_6503.method_6114(hurtTarget);
            }
            return flag;
        }
        return false;
    }

    public boolean pokemonTryForceEncounter(PokemonEntity attackingPokemon, class_1297 hurtTarget) {
        if (hurtTarget instanceof PokemonEntity) {
            PokemonEntity defendingPokemon = (PokemonEntity)hurtTarget;
            if (attackingPokemon.getPokemon().isPlayerOwned()) {
                if (defendingPokemon.getPokemon().isPlayerOwned()) {
                    if (CobblemonFightOrFlight.config().force_player_battle_on_pokemon_hurt) {
                        return this.pokemonForceEncounterPvP(attackingPokemon, defendingPokemon);
                    }
                } else if (CobblemonFightOrFlight.config().force_wild_battle_on_pokemon_hurt) {
                    return this.pokemonForceEncounterPvE(attackingPokemon, defendingPokemon);
                }
            } else if (defendingPokemon.getPokemon().isPlayerOwned() && CobblemonFightOrFlight.config().force_wild_battle_on_pokemon_hurt) {
                return this.pokemonForceEncounterPvE(defendingPokemon, attackingPokemon);
            }
        }
        return false;
    }

    public boolean pokemonForceEncounterPvP(PokemonEntity playerPokemon, PokemonEntity opponentPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            class_13092 = opponentPokemon.method_35057();
            if (class_13092 instanceof class_3222) {
                class_3222 serverOpponent = (class_3222)class_13092;
                if (serverPlayer == serverOpponent || !this.canBattlePlayer(serverPlayer) || !this.canBattlePlayer(serverOpponent)) {
                    return false;
                }
                BattleBuilder.INSTANCE.pvp1v1(serverPlayer, serverOpponent, null, null, BattleFormat.Companion.getGEN_9_SINGLES(), false, false);
            }
        }
        return false;
    }

    public boolean pokemonForceEncounterPvE(PokemonEntity playerPokemon, PokemonEntity wildPokemon) {
        class_1309 class_13092 = playerPokemon.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (!this.canBattlePlayer(serverPlayer)) {
                return false;
            }
            BattleBuilder.INSTANCE.pve(serverPlayer, wildPokemon, playerPokemon.getPokemon().getUuid(), BattleFormat.Companion.getGEN_9_SINGLES(), false, false, Cobblemon.config.getDefaultFleeDistance(), (PartyStore)Cobblemon.INSTANCE.getStorage().getParty(serverPlayer));
        }
        return false;
    }

    public boolean canBattlePlayer(class_3222 serverPlayer) {
        boolean playerHasAlivePokemon = false;
        for (Pokemon pokemon : Cobblemon.INSTANCE.getStorage().getParty(serverPlayer)) {
            if (pokemon.isFainted()) continue;
            playerHasAlivePokemon = true;
            break;
        }
        return BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(serverPlayer) == null && playerHasAlivePokemon && serverPlayer.method_5805();
    }
}

