/*
 * Decompiled with CFR 0.152.
 */
package games.dragonhowl.megamons.common.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import games.dragonhowl.megamons.common.MegaEvolution;
import games.dragonhowl.megamons.common.Megamons;
import games.dragonhowl.megamons.common.Megastone;
import games.dragonhowl.megamons.common.data.Megastones;
import games.dragonhowl.megamons.common.item.CutMegastoneItem;
import games.dragonhowl.megamons.common.item.PokemonUseItem;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\nJ'\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lgames/dragonhowl/megamons/common/item/MegaCuffItem;", "Lgames/dragonhowl/megamons/common/item/PokemonUseItem;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/cobblemon/mod/common/pokemon/Species;", "species", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1269;", "checkMegaDevolve", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/pokemon/Species;Lnet/minecraft/class_1657;)Lnet/minecraft/class_1269;", "megaSpecies", "checkMegaEvolve", "Lnet/minecraft/class_1799;", "stack", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "processInteraction", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1657;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lnet/minecraft/class_1269;", "<init>", "()V", "common"})
@SourceDebugExtension(value={"SMAP\nMegaCuffItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MegaCuffItem.kt\ngames/dragonhowl/megamons/common/item/MegaCuffItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 MegaCuffItem.kt\ngames/dragonhowl/megamons/common/item/MegaCuffItem\n*L\n72#1:99,2\n77#1:101,2\n*E\n"})
public final class MegaCuffItem
extends PokemonUseItem {
    public MegaCuffItem() {
        class_1792.class_1793 class_17932 = new class_1792.class_1793().method_7889(1);
        Intrinsics.checkNotNullExpressionValue(class_17932, "Settings().maxCount(1)");
        super(class_17932);
    }

    @Override
    @NotNull
    public class_1269 processInteraction(@NotNull class_1799 stack, @NotNull class_1657 player, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
        Pokemon pokemon = pokemonEntity.getPokemon();
        class_1799 heldItemStack = pokemon.heldItem();
        if (heldItemStack.method_7960()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.nohelditem"), true);
            return class_1269.field_5814;
        }
        class_1792 heldItem = heldItemStack.method_7909();
        if (!(heldItem instanceof CutMegastoneItem)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.notamegastone"), true);
            return class_1269.field_5814;
        }
        Megastone megastone = ((CutMegastoneItem)heldItem).getMegastone();
        class_2960 preEvolutionIdentifier = megastone.getSpecies();
        class_2960 postEvolutionIdentifier = megastone.getMegaSpecies();
        Species preEvolution = PokemonSpecies.INSTANCE.getByIdentifier(preEvolutionIdentifier);
        Species postEvolution = PokemonSpecies.INSTANCE.getByIdentifier(postEvolutionIdentifier);
        if (preEvolution == null || postEvolution == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.megastonehasnopokemon"), true);
            return class_1269.field_5814;
        }
        Species species = pokemon.getSpecies();
        if (Intrinsics.areEqual(species, preEvolution)) {
            return this.checkMegaEvolve(pokemon, postEvolution, player);
        }
        if (Intrinsics.areEqual(species, postEvolution)) {
            return this.checkMegaDevolve(pokemon, preEvolution, player);
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.wrongmegastone"), true);
        return class_1269.field_5814;
    }

    private final class_1269 checkMegaEvolve(Pokemon pokemon, Species megaSpecies, class_1657 player) {
        int maxMegaPokemon = Megamons.INSTANCE.getConfig().getMaxMegaPokemon();
        if (maxMegaPokemon <= 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.nomegasallowed"), true);
            return class_1269.field_5814;
        }
        int playerMegaCount = 0;
        PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        PlayerPartyStore playerParty = pokemonStoreManager.getParty(uUID);
        PokemonStoreManager pokemonStoreManager2 = Cobblemon.INSTANCE.getStorage();
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID2, "player.uuid");
        PCStore playerPC = pokemonStoreManager2.getPC(uUID2);
        Iterable $this$forEach$iv = (Iterable)playerParty;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon partyPokemon = (Pokemon)element$iv;
            boolean bl = false;
            if (Megastones.INSTANCE.byPostEvolution(partyPokemon.getSpecies().getResourceIdentifier()) == null) continue;
            ++playerMegaCount;
        }
        $this$forEach$iv = (Iterable)playerPC;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon pcPokemon = (Pokemon)element$iv;
            boolean bl = false;
            if (Megastones.INSTANCE.byPostEvolution(pcPokemon.getSpecies().getResourceIdentifier()) == null) continue;
            ++playerMegaCount;
        }
        if (playerMegaCount >= maxMegaPokemon) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.megacuffitem.maxmegas"), true);
            return class_1269.field_5814;
        }
        MegaEvolution.INSTANCE.evolveMega(pokemon, megaSpecies, player);
        return class_1269.field_5812;
    }

    private final class_1269 checkMegaDevolve(Pokemon pokemon, Species species, class_1657 player) {
        MegaEvolution.INSTANCE.devolveMega(pokemon, species, player);
        return class_1269.field_5812;
    }
}

