```json
{
  "title": "The Aspen Infusion",
  "icon": "affinity:asp_rite_core",
  "category": "affinity:conducting_rituals",
  "required_advancements": [
    "affinity:some_assembly_required"
  ],
  "associated_items": [
    "affinity:asp_rite_core"
  ]
}
```

Useful as though the [Assembly Augment](^affinity:assembly_augment) is, its insignificant physical size and inability
to process [Aethum Flux](^affinity:aethum_flux) considerably limit the selection of objects it can manufacture.


To address both of these shortcomings at once, you devise the {item}Asp Rite Core{} - a wondrous piece of machinery
and key to the {concept}Aspen Infusion{} ritual.

;;;;;

<recipe;affinity:assembly/asp_rite_core>

In concert with a collection of [Ritual Socles](^affinity:socle_composition), it facilitates the formation of the
{concept}flux-field{} required for ritual activity. It can then operate on many inputs at once, optionally...


@next-page

...incorporating a supply of [Aethum Flux](^affinity:aethum_flux).

---

To construct an initial ritual setup, a number of [Ritual Socles](^affinity:socle_composition) must be placed
{concept}on the same level{} as the {item}Asp Rite Core{}. To ensure maximum flux-field stability, these guidelines
have proven useful:

- Socles shall be placed {concept}at moderate distance{} from the core - neither up close nor too far

;;;;;

- Socles {concept}must not touch{} and shall be {concept}spaced evenly{}

- All socles collectively shall display {concept}a certain level of symmetry{}

The estimated flux-field stability, and thereby {concept}success rate{} of a given ritual setup, and the maximum socle
distance may be inspected using the [Wand of Inquiry](^affinity:inquiry). In order to...


@next-page

...infuse an {item}Uncanny Rod{} with the necessary materials, the following setup (which obeys all guidelines) 
may be used:

<structure;affinity:rudimentary_aspen_infusion>

;;;;;

It is to note that, given that it is a product of aethum-based magic, the flux-field {concept}thrives off environmental aethum{}.
Thus, if set up in a place with strong environmental aethum, {concept}the flux field will have high natural stability{}
and vice-versa.

---

Finally, to perform a ritual, its ingredients must be...


@next-page

...inserted into the core and placed on socles as specified by a given recipe. If [Aethum Flux](^affinity:aethum_flux) is required,
it must be available to the core as well.


Once this preparation is completed, the core can be {concept}sneak-interacted{} with using an empty hand to initiate the 
procedure (alternatively, it also seems to react to redstone).


When all goes well, the ingredients on the socles

;;;;;

are {concept}consumed one-by-one{} and infused into the prime ingredient on the core. If, due to insufficient
flux-field stability, the ritual fails, {concept}all ingredients and Aethum Flux{} consumed up to that point are
{concept}irrevocably lost{}.

@entry-end