```json
{
  "title": "Aethum Flux",
  "icon": "affinity:stone_banded_aethum_flux_node",
  "category": "affinity:aethum_flux_networks",
  "required_advancements": [
    "affinity:some_assembly_required"
  ],
  "associated_items": [
    "affinity:stone_banded_aethum_flux_node",
    "affinity:aethum_flux_cache"
  ]
}
```

A quite peculiar property of [Aethum](^affinity:aethum) is that, under the right conditions and exposed to the
appropriate materials, it manifests semi-physically as {concept}Aethum Flux{}. In this form it is much more readily
contained and consumed by machinery - making it the {concept}de-facto standard power source{} used to enable a large
variety of potent block-bound devices.

;;;;;

To get started moving flux, a [Wand of Iridescence](^affinity:wand_of_iridescence), some {item}Amethyst Shards{} and an
{item}Aethum Flux Node{} are of absolute necessity:

<recipe;affinity:assembly/stone_banded_aethum_flux_node>

Of course, further required is a means of...


@next-page

...forming flux (of which there are numerous) - the [Matter Harvesting Hearth](^affinity:matter_harvesting_heart)
might present a good starting point.


With everything acquired, the node may be {concept}placed down and an {item}Amethyst Shard{} inserted{}. Next,
{concept}place down the generator{} of your choosing, get it running through whatever means necessary and join it with
the node using your [Wand of Iridescence](^affinity:wand_of_iridescence).

;;;;;

As you will no doubt observe, {concept}each member{} of an Aethum Flux network {concept}has an internal buffer of flux{},
making the use of extra storage optional for more limited setups.


Lastly, the node must be joined with the desired {concept}Aethum Flux-powered device{}
(like an [Asp Rite Core](^affinity:aspen_infusion)), which will make it promptly move flux to the buffer of said device.


@next-page

Note that the node is vital, as it facilitates flux movement through its mounted {concept}Amethyst Shard{}. It can do
this for {concept}up to 5 connected devices{}, including other nodes, which allows for forming grand power delivery
networks. If superior transfer rates, further distances and more connections are desired, the more refined
[Copper Plated Aethum Flux Node](^affinity:copper_plated_aethum_flux_node) shall be of interest.


If, eventually, the need to

;;;;;

store increased amounts of {concept}Aethum Flux{} long-term arises, the {item}Aethum Flux Cache{} is to be explored.

<recipe;affinity:assembly/aethum_flux_cache>

Reminiscent of a fluid tank yet distinguished in...


@next-page

...function, it can {concept}permanently buffer{} an {concept}impressive quantity of flux{}. Additionally, many caches
can be stacked vertically to {concept}access their combined capacity{} through the bottommost transfer-point.


After {concept}inserting an {}{item}Amethyst Shard{} into a cache, it may be connected to at least two nodes. Hereby,
care must be taken: when connected through the standard procedure, a given node will {concept}exclusively distribute
flux to this cache{} but never pull

;;;;;

from it. To make it instead take flux from the cache, {concept}begin the binding process with the cache{} and
{concept}sneak{} while using the [Wand of Iridescence](^affinity:wand_of_iridescence). If done correctly, an
arrow {#3955E5}**→**{} will be displayed to indicate this.

@entry-end