/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class WatcherSwordItem
extends UniqueSwordItem {
    public WatcherSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            class_3218 world = (class_3218)attacker.method_37908();
            int watcherChance = Config.uniqueEffects.watcher.watcherChance;
            int omenChance = Config.uniqueEffects.watcher.omenChance;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.method_59922().method_43048(100) <= watcherChance) {
                double hradius = Config.uniqueEffects.watcher.watcherRadius;
                double vradius = Config.uniqueEffects.watcher.watcherRadius / 2.0;
                double x = target.method_23317();
                double y = target.method_23318();
                double z = target.method_23321();
                float rAmount = Config.uniqueEffects.watcher.watcherRestoreAmount;
                class_238 box = new class_238(x + hradius, y + vradius, z + hradius, x - hradius, y - vradius, z - hradius);
                for (class_1297 entity : world.method_8333((class_1297)attacker, box, class_1301.field_6154)) {
                    if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire((class_1309)entity, attacker)) continue;
                    entity.method_5643(attacker.method_48923().method_48815((class_1297)attacker, (class_1297)attacker), rAmount);
                    attacker.method_6025(rAmount);
                    class_2338 position2 = entity.method_24515();
                    world.method_8396(null, position2, (class_3414)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), entity.method_5634(), 0.05f, 1.2f);
                }
            }
            if (attacker.method_59922().method_43048(100) <= omenChance) {
                class_2338 position = target.method_24515();
                float overallAbsorptionCap = Config.uniqueEffects.abilityAbsorptionCap;
                float absorptionCap = Config.uniqueEffects.watcher.omenAbsorptionCap;
                float threshold = Config.uniqueEffects.watcher.omenInstantKillThreshold * target.method_6063();
                float remainingHealth = target.method_6032();
                if (remainingHealth <= threshold) {
                    attacker.method_6073(Math.min(Math.min(absorptionCap, overallAbsorptionCap), attacker.method_6067() + remainingHealth));
                    world.method_8396(null, position, (class_3414)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), target.method_5634(), 0.7f, 1.2f);
                    target.method_5643(attacker.method_48923().method_48815((class_1297)attacker, (class_1297)attacker), 1000.0f);
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (class_2394)class_2398.field_11215, (class_2394)class_2398.field_11215, (class_2394)class_2398.field_11219, true);
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip1").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.simplyswords.watchersworditem.tooltip3", (Object[])new Object[]{Float.valueOf(Config.uniqueEffects.watcher.omenInstantKillThreshold * 100.0f)}).method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip4").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip5").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip6").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.watchersworditem.tooltip7").method_10862(Styles.TEXT));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
    }

    @Override
    protected class_2960 getConfigPath() {
        return class_2960.method_60654((String)"simplyswords.unique_effects.watcher");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int watcherChance;
        @ValidatedDouble.Restrict(min=1.0)
        public double watcherRadius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float watcherRestoreAmount;
        @ValidatedFloat.Restrict(min=0.0f, max=100.0f)
        public float omenAbsorptionCap;
        @ValidatedInt.Restrict(min=0, max=100)
        public int omenChance;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float omenInstantKillThreshold;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ItemsRegistry.WATCHER_CLAYMORE.get();
            supplierArray[1] = () -> ItemsRegistry.WATCHING_WARGLAIVE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.watcherChance = 5;
            this.watcherRadius = 8.0;
            this.watcherRestoreAmount = 0.5f;
            this.omenAbsorptionCap = 20.0f;
            this.omenChance = 5;
            this.omenInstantKillThreshold = 0.25f;
        }
    }
}

