/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.loot;

import dev.architectury.event.events.common.LootEvent;
import java.util.Set;
import net.bandit.many_bows.config.BowLootConfig;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;

public class ModLootModifiers {
    private static final BowLootConfig CONFIG = BowLootConfig.loadConfig();
    private static final Set<class_5321<class_52>> EASY_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"));
    private static final Set<class_5321<class_52>> MEDIUM_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/jungle_temple"), ModLootModifiers.createKey("minecraft", "chests/pillager_outpost"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"), ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"));
    private static final Set<class_5321<class_52>> HARD_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/stronghold_corridor"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));
    private static final Set<class_5321<class_52>> ENDGAME_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/end_city_treasure"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));

    private static class_5321<class_52> createKey(String namespace, String path) {
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)namespace, (String)path));
    }

    public static void registerLootModifiers() {
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            if (!builtin) {
                return;
            }
            if (ModLootModifiers.CONFIG.easyLootEnabled && EASY_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createCommonBowPool(ModLootModifiers.CONFIG.easyLootDropChance));
            }
            if (ModLootModifiers.CONFIG.mediumLootEnabled && MEDIUM_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createUncommonBowPool(ModLootModifiers.CONFIG.mediumLootDropChance));
            }
            if (ModLootModifiers.CONFIG.hardLootEnabled && HARD_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createRareBowPool(ModLootModifiers.CONFIG.hardLootDropChance));
            }
            if (ModLootModifiers.CONFIG.endgameLootEnabled && ENDGAME_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createEpicBowPool(ModLootModifiers.CONFIG.endgameLootDropChance));
            }
        });
    }

    private static class_55.class_56 createCommonBowPool(float chance) {
        return class_55.method_347().method_352((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.ANCIENT_SAGE_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.AETHERS_CALL.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.BURNT_RELIC.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.ARCANE_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.CYROHEART_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.POWER_CRYSTAL.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.EMERALD_SAGE_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.TORCHBEARER.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.DEMONS_GRASP.get()))).method_356(class_219.method_932((float)chance));
    }

    private static class_55.class_56 createUncommonBowPool(float chance) {
        return class_55.method_347().method_352((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.ARCANE_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.CYROHEART_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.POWER_CRYSTAL.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.TORCHBEARER.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.EMERALD_SAGE_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.DEMONS_GRASP.get()))).method_356(class_219.method_932((float)chance));
    }

    private static class_55.class_56 createRareBowPool(float chance) {
        return class_55.method_347().method_352((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.SENTINELS_WRATH.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.CURSED_STONE.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.SOLAR_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.ARC_HEAVENS.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.SCATTER_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.VITALITY_WEAVER.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.SPECTRAL_WHISPER.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.WEBSTRING.get()))).method_356(class_219.method_932((float)chance));
    }

    private static class_55.class_56 createEpicBowPool(float chance) {
        return class_55.method_347().method_352((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.FLAME_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.DARK_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.DRAGONS_BREATH.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.WIND_BOW.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.SHULKER_BLAST.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.ASTRAL_BOUND.get()))).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ItemRegistry.AURORAS_GRACE.get()))).method_356(class_219.method_932((float)chance));
    }
}

