/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ScatterBow
extends class_1753 {
    private static final int MAX_ARROWS = 8;

    public ScatterBow(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7840(class_1799 bowStack, class_1937 level, class_1309 entity, int chargeTime) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            List projectiles = ScatterBow.method_57390((class_1799)bowStack, (class_1799)player.method_18808(bowStack), (class_1309)player);
            boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
            if (!projectiles.isEmpty() || hasInfinity || player.method_31549().field_7477) {
                int charge = this.method_7881(bowStack, entity) - chargeTime;
                float power = ScatterBow.method_7722((int)charge);
                int arrowsAvailable = player.method_31549().field_7477 ? 8 : Math.min(8, this.getArrowCount(player));
                for (int i = 0; i < arrowsAvailable; ++i) {
                    class_1667 arrow = (class_1667)class_1299.field_6122.method_5883(level);
                    if (arrow == null) continue;
                    arrow.method_7432((class_1297)player);
                    arrow.method_5814(player.method_23317(), player.method_23320(), player.method_23321());
                    class_6880 rangedDamageAttr = level.method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage")).orElse(null);
                    if (rangedDamageAttr != null) {
                        class_1324 attrInstance = player.method_5996(rangedDamageAttr);
                        if (attrInstance != null) {
                            float damage = (float)attrInstance.method_6194();
                            arrow.method_7438((double)(damage / 11.0f));
                        } else {
                            arrow.method_7438(2.0);
                        }
                    } else {
                        arrow.method_7438(2.0);
                    }
                    this.applyPowerEnchantment((class_1665)arrow, bowStack, level);
                    this.applyKnockbackEnchantment((class_1665)arrow, bowStack, (class_1309)player, level);
                    this.applyFlameEnchantment((class_1665)arrow, bowStack, level);
                    arrow.field_7572 = hasInfinity ? class_1665.class_1666.field_7594 : class_1665.class_1666.field_7593;
                    float yawOffset = (level.method_8409().method_43057() - 0.5f) * 20.0f;
                    float pitchOffset = (level.method_8409().method_43057() - 0.5f) * 10.0f;
                    arrow.method_24919((class_1297)player, player.method_36455() + pitchOffset, player.method_36454() + yawOffset, 0.0f, power * 3.0f, 1.0f);
                    level.method_8649((class_1297)arrow);
                }
            }
        }
    }

    private int getArrowCount(class_1657 player) {
        int arrowCount = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            class_1799 projectile = player.method_18808(stack);
            if (projectile.method_7960()) continue;
            arrowCount += projectile.method_7947();
        }
        return arrowCount;
    }

    private void removeArrowsFromInventory(class_1657 player, int count) {
        int removed = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !(stack.method_7909() instanceof class_1744)) continue;
            int toRemove = Math.min(stack.method_7947(), count - removed);
            stack.method_7934(toRemove);
            if ((removed += toRemove) < count) continue;
            break;
        }
    }

    private void applyFlameEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> flame = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9126);
        int flameLevel = class_1890.method_8225(flame, (class_1799)bow);
        if (flameLevel > 0) {
            arrow.method_5639(5.0f);
        }
    }

    private void applyKnockbackEnchantment(class_1665 arrow, class_1799 bow, class_1309 shooter, class_1937 level) {
        class_6880<class_1887> punch = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9116);
        int punchLevel = class_1890.method_8225(punch, (class_1799)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.method_45325(class_5134.field_23718));
            class_243 knockbackVec = arrow.method_18798().method_1029().method_1021((double)punchLevel * 0.6 * resistance);
            arrow.method_5762(knockbackVec.field_1352, 0.1, knockbackVec.field_1350);
        }
    }

    private void applyPowerEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> power = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9103);
        int powerLevel = class_1890.method_8225(power, (class_1799)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.method_7438(arrow.method_7448() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(class_1799 bow, class_1937 level) {
        class_6880<class_1887> infinity = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9125);
        return class_1890.method_8225(infinity, (class_1799)bow) > 0;
    }

    private class_6880<class_1887> getEnchantmentHolder(class_1937 level, class_5321<class_1887> enchantmentKey) {
        return level.method_30349().method_30530(class_7924.field_41265).method_40290(enchantmentKey);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if (class_437.method_25442()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.scatter_bow.tooltip").method_27692(class_124.field_1065));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.scatter_bow.tooltip.ability").method_27692(class_124.field_1077));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.hold_shift"));
        }
    }
}

