/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_9822;

public class MonumentPieces {
    private MonumentPieces() {
    }

    public static List<class_3443> createMonumentBuilding(class_5455 registryAccess, class_3485 StructureTemplateManager, class_5819 random, int x, int y, int z, String monumentType, class_9822 liquidSettings) {
        class_2378 poolRegistry = registryAccess.method_30530(class_7924.field_41249);
        ArrayList<class_3443> pieces = new ArrayList<class_3443>();
        MonumentBuilding mainBuilding = new MonumentBuilding((class_2378<class_3785>)poolRegistry, StructureTemplateManager, random, monumentType, liquidSettings);
        mainBuilding.addMainBody(pieces, (class_2378<class_3785>)poolRegistry, StructureTemplateManager, random, class_2470.field_11467, monumentType, liquidSettings);
        pieces.addAll(mainBuilding.childPieces);
        pieces.forEach(piece -> GeneralUtils.movePieceProperly(piece, x, y, z));
        return pieces;
    }

    private static class_3443 getJigsawPiece(class_2378<class_3785> poolRegistry, class_3485 structureTemplateManager, String poolPath, class_2338 blockPos, class_2470 rotation, class_5819 random, String type, class_9822 liquidSettings) {
        class_3784 poolEntry;
        class_2960 resourceLocation = class_2960.method_12829((String)poolPath.toLowerCase(Locale.ROOT));
        class_3785 pool = (class_3785)poolRegistry.method_10223(resourceLocation);
        if (pool == null || pool.method_16632() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {}  Will not generate monument piece at spot.", (Object)(String.valueOf(resourceLocation) + " - Monument type: " + type));
            poolEntry = (class_3784)class_3784.method_30438().apply(class_3785.class_3786.field_16687);
        } else {
            poolEntry = pool.method_16631(random);
        }
        return new class_3790(structureTemplateManager, poolEntry, blockPos, poolEntry.method_19308(), rotation, poolEntry.method_16628(structureTemplateManager, blockPos, rotation), liquidSettings);
    }

    private static class_2338 getRoomPosition(RoomGraph roomGraph, int specialOffset) {
        int index = roomGraph.index;
        int x = index % 5;
        int z = index / 5 % 5;
        int y = index / 25;
        return new class_2338(x * 8, y * 4, -(z + specialOffset) * 8 + 1).method_10069(9, 0, 35);
    }

    private static class_2470 getOpeningRotationFull(class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11043 -> class_2470.field_11467;
            case class_2350.field_11034 -> class_2470.field_11463;
            case class_2350.field_11035 -> class_2470.field_11464;
            case class_2350.field_11039 -> class_2470.field_11465;
        };
    }

    public static class MonumentBuilding
    extends MonumentPiece {
        private RoomGraph sourceRoom;
        private RoomGraph coreRoom;
        protected final List<class_3443> childPieces = Lists.newArrayList();

        public MonumentBuilding(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_5819 random, String type, class_9822 liquidSettings) {
            super(null);
            class_2338 pos;
            List<RoomGraph> graphList = this.generateRoomGraph(random);
            this.sourceRoom.claimed = true;
            this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/core", MonumentPieces.getRoomPosition(this.coreRoom, 2), class_2470.field_11467, random, type, liquidSettings));
            ArrayList fitterList = Lists.newArrayList();
            fitterList.add(new FitDoubleXYRoom());
            fitterList.add(new FitDoubleYZRoom());
            fitterList.add(new FitDoubleZRoom());
            fitterList.add(new FitDoubleXRoom());
            fitterList.add(new FitDoubleYRoom());
            fitterList.add(new FitSimpleTopRoom());
            fitterList.add(new FitSimplePillarRoom(random));
            fitterList.add(new FitSimpleRoom());
            block0: for (RoomGraph chosenRoomGraph : graphList) {
                if (chosenRoomGraph.claimed || chosenRoomGraph.isSpecial()) continue;
                for (MonumentRoomFitter fitter : fitterList) {
                    if (!fitter.fits(chosenRoomGraph)) continue;
                    this.childPieces.add(fitter.create(poolRegistry, StructureTemplateManager, class_2470.field_11467, chosenRoomGraph, random, type, liquidSettings));
                    fitter.createOpenings(this.childPieces, poolRegistry, StructureTemplateManager, class_2470.field_11467, chosenRoomGraph, random, type, liquidSettings);
                    continue block0;
                }
            }
            if (this.sourceRoom.hasOpening[class_2350.field_11039.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).method_10069(0, 1, 3);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/entrance_wall", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (this.sourceRoom.hasOpening[class_2350.field_11034.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).method_10069(6, 1, 3);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/entrance_wall", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (this.sourceRoom.hasOpening[class_2350.field_11043.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).method_10069(3, 1, 0);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (this.sourceRoom.hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(this.sourceRoom, 1).method_10069(2, 4, 2);
                this.childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }

        public void addMainBody(List<class_3443> pieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_5819 random, class_2470 rotation, String type, class_9822 liquidSettings) {
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/body/ne_corner", new class_2338(29, 0, 0), rotation, random, type, liquidSettings));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/body/nw_corner", new class_2338(0, 0, 0), rotation, random, type, liquidSettings));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/body/se_corner", new class_2338(29, 0, 29), rotation, random, type, liquidSettings));
            pieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/body/sw_corner", new class_2338(0, 0, 29), rotation, random, type, liquidSettings));
        }

        /*
         * WARNING - void declaration
         */
        private List<RoomGraph> generateRoomGraph(class_5819 random) {
            RoomGraph[] roomGraph = new RoomGraph[75];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int l = MonumentBuilding.getRoomIndex(i, 0, j);
                    roomGraph[l] = new RoomGraph(l);
                }
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                for (int l2 = 0; l2 < 4; ++l2) {
                    int j4 = MonumentBuilding.getRoomIndex(i2, 1, l2);
                    roomGraph[j4] = new RoomGraph(j4);
                }
            }
            for (int j2 = 1; j2 < 4; ++j2) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    int k4 = MonumentBuilding.getRoomIndex(j2, 2, i3);
                    roomGraph[k4] = new RoomGraph(k4);
                }
            }
            this.sourceRoom = roomGraph[GRIDROOM_SOURCE_INDEX];
            for (int k2 = 0; k2 < 5; ++k2) {
                for (int j3 = 0; j3 < 5; ++j3) {
                    for (int i4 = 0; i4 < 3; ++i4) {
                        int l4 = MonumentBuilding.getRoomIndex(k2, i4, j3);
                        if (roomGraph[l4] == null) continue;
                        for (class_2350 class_23502 : class_2350.values()) {
                            int l1;
                            int i1 = k2 + class_23502.method_10148();
                            int j1 = i4 + class_23502.method_10164();
                            int k1 = j3 + class_23502.method_10165();
                            if (i1 < 0 || i1 >= 5 || k1 < 0 || k1 >= 5 || j1 < 0 || j1 >= 3 || roomGraph[l1 = MonumentBuilding.getRoomIndex(i1, j1, k1)] == null) continue;
                            if (k1 == j3) {
                                roomGraph[l4].setConnection(class_23502, roomGraph[l1]);
                                continue;
                            }
                            roomGraph[l4].setConnection(class_23502.method_10153(), roomGraph[l1]);
                        }
                    }
                }
            }
            RoomGraph roomGraph1 = new RoomGraph(1003);
            RoomGraph roomGraph2 = new RoomGraph(1001);
            RoomGraph roomGraph3 = new RoomGraph(1002);
            roomGraph[GRIDROOM_TOP_CONNECT_INDEX].setConnection(class_2350.field_11036, roomGraph1);
            roomGraph[GRIDROOM_LEFTWING_CONNECT_INDEX].setConnection(class_2350.field_11035, roomGraph2);
            roomGraph[GRIDROOM_RIGHTWING_CONNECT_INDEX].setConnection(class_2350.field_11035, roomGraph3);
            roomGraph1.claimed = true;
            roomGraph2.claimed = true;
            roomGraph3.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = roomGraph[MonumentBuilding.getRoomIndex(random.method_43048(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[class_2350.field_11034.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11043.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11034.method_10146()].connections[class_2350.field_11043.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11036.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11034.method_10146()].connections[class_2350.field_11036.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11043.method_10146()].connections[class_2350.field_11036.method_10146()].claimed = true;
            this.coreRoom.connections[class_2350.field_11034.method_10146()].connections[class_2350.field_11043.method_10146()].connections[class_2350.field_11036.method_10146()].claimed = true;
            ObjectArrayList list = new ObjectArrayList();
            for (RoomGraph roomGraph4 : roomGraph) {
                if (roomGraph4 == null) continue;
                roomGraph4.updateOpenings();
                list.add((Object)roomGraph4);
            }
            roomGraph1.updateOpenings();
            class_156.method_43028((List)list, (class_5819)random);
            boolean bl = true;
            for (RoomGraph selectedRoomGraph : list) {
                int n = 0;
                for (int k5 = 0; n < 2 && k5 < 5; ++k5) {
                    void var7_14;
                    int l5 = random.method_43048(6);
                    if (!selectedRoomGraph.hasOpening[l5]) continue;
                    int i6 = class_2350.method_10143((int)l5).method_10153().method_10146();
                    selectedRoomGraph.hasOpening[l5] = false;
                    selectedRoomGraph.connections[l5].hasOpening[i6] = false;
                    if (selectedRoomGraph.findSource((int)var7_14++) && selectedRoomGraph.connections[l5].findSource((int)var7_14++)) {
                        ++n;
                        continue;
                    }
                    selectedRoomGraph.hasOpening[l5] = true;
                    selectedRoomGraph.connections[l5].hasOpening[i6] = true;
                }
            }
            list.add((Object)roomGraph1);
            list.add((Object)roomGraph2);
            list.add((Object)roomGraph3);
            return list;
        }
    }

    static class RoomGraph {
        final int index;
        final RoomGraph[] connections = new RoomGraph[6];
        final boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        private int scanIndex;

        public RoomGraph(int index) {
            this.index = index;
        }

        public void setConnection(class_2350 direction, RoomGraph roomGraph) {
            this.connections[direction.method_10146()] = roomGraph;
            roomGraph.connections[direction.method_10153().method_10146()] = this;
        }

        public void updateOpenings() {
            for (int i = 0; i < 6; ++i) {
                this.hasOpening[i] = this.connections[i] != null;
            }
        }

        public boolean findSource(int index) {
            if (this.isSource) {
                return true;
            }
            this.scanIndex = index;
            for (int i = 0; i < 6; ++i) {
                if (this.connections[i] == null || !this.hasOpening[i] || this.connections[i].scanIndex == index || !this.connections[i].findSource(index)) continue;
                return true;
            }
            return false;
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }
    }

    protected static abstract class MonumentPiece {
        protected static final int GRIDROOM_SOURCE_INDEX = MonumentPiece.getRoomIndex(2, 0, 0);
        protected static final int GRIDROOM_TOP_CONNECT_INDEX = MonumentPiece.getRoomIndex(2, 2, 0);
        protected static final int GRIDROOM_LEFTWING_CONNECT_INDEX = MonumentPiece.getRoomIndex(0, 1, 0);
        protected static final int GRIDROOM_RIGHTWING_CONNECT_INDEX = MonumentPiece.getRoomIndex(4, 1, 0);
        protected RoomGraph roomGraph;

        protected static int getRoomIndex(int x, int y, int z) {
            return y * 25 + z * 5 + x;
        }

        protected MonumentPiece(RoomGraph roomGraph) {
            this.roomGraph = roomGraph;
        }
    }

    static class FitSimpleTopRoom
    implements MonumentRoomFitter {
        FitSimpleTopRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return !roomGraph.hasOpening[class_2350.field_11039.method_10146()] && !roomGraph.hasOpening[class_2350.field_11034.method_10146()] && !roomGraph.hasOpening[class_2350.field_11043.method_10146()] && !roomGraph.hasOpening[class_2350.field_11035.method_10146()] && !roomGraph.hasOpening[class_2350.field_11036.method_10146()];
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/simple_top", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
        }
    }

    static class FitSimplePillarRoom
    implements MonumentRoomFitter {
        private final class_5819 random;

        FitSimplePillarRoom(class_5819 random) {
            this.random = random;
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return this.random.method_43056() && !roomGraph.hasOpening[class_2350.field_11033.method_10146()] && !roomGraph.hasOpening[class_2350.field_11036.method_10146()];
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/simple_pillar", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (!roomGraph.hasOpening[direction.method_10146()]) continue;
                class_2470 rotation = MonumentPieces.getOpeningRotationFull(direction);
                class_2338 pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(3, 1, 3).method_10079(direction, 3);
                if (rotation == class_2470.field_11463) {
                    pos = pos.method_10069(1, 0, 0);
                } else if (rotation == class_2470.field_11464) {
                    pos = pos.method_10069(1, 0, 1);
                } else if (rotation == class_2470.field_11465) {
                    pos = pos.method_10069(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, rotation, random, type, liquidSettings));
            }
        }
    }

    static class FitSimpleRoom
    implements MonumentRoomFitter {
        FitSimpleRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return true;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/simple", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (!roomGraph.hasOpening[direction.method_10146()]) continue;
                class_2470 rotation = MonumentPieces.getOpeningRotationFull(direction);
                class_2338 pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(3, 1, 3).method_10079(direction, 3);
                if (rotation == class_2470.field_11463) {
                    pos = pos.method_10069(1, 0, 0);
                } else if (rotation == class_2470.field_11464) {
                    pos = pos.method_10069(1, 0, 1);
                } else if (rotation == class_2470.field_11465) {
                    pos = pos.method_10069(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_1", pos, rotation, random, type, liquidSettings));
            }
            if (roomGraph.hasOpening[class_2350.field_11036.method_10146()]) {
                class_2338 pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(2, 4, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static class FitDoubleZRoom
    implements MonumentRoomFitter {
        FitDoubleZRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[class_2350.field_11043.method_10146()] && !roomGraph.connections[class_2350.field_11043.method_10146()].claimed;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            RoomGraph roomGraph1 = roomGraph;
            if (!roomGraph.hasOpening[class_2350.field_11043.method_10146()] || roomGraph.connections[class_2350.field_11043.method_10146()].claimed) {
                roomGraph1 = roomGraph.connections[class_2350.field_11035.method_10146()];
            }
            roomGraph1.claimed = true;
            roomGraph1.connections[class_2350.field_11043.method_10146()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/double_z", MonumentPieces.getRoomPosition(roomGraph, 2), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            class_2338 pos;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 pos2;
                class_2470 rotation;
                if (direction != class_2350.field_11043 && roomGraph.hasOpening[direction.method_10146()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(4, 1, 12).method_10079(direction, 4);
                    if (rotation == class_2470.field_11463) {
                        pos2 = pos2.method_10069(-1, 0, -1);
                    } else if (rotation == class_2470.field_11464) {
                        pos2 = pos2.method_10069(0, 0, -1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                }
                if (direction == class_2350.field_11035 || !roomGraph.connections[class_2350.field_11043.method_10146()].hasOpening[direction.method_10146()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(3, 1, 4).method_10079(direction, 4);
                if (rotation == class_2470.field_11463) {
                    pos2 = pos2.method_10069(0, 0, -1);
                } else if (rotation == class_2470.field_11464) {
                    pos2 = pos2.method_10069(1, 0, -1);
                } else if (rotation == class_2470.field_11465) {
                    pos2 = pos2.method_10069(1, 0, 0);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
            }
            if (roomGraph.hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 4, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11043.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static class FitDoubleYZRoom
    implements MonumentRoomFitter {
        FitDoubleYZRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            if (roomGraph.hasOpening[class_2350.field_11043.method_10146()] && !roomGraph.connections[class_2350.field_11043.method_10146()].claimed && roomGraph.hasOpening[class_2350.field_11036.method_10146()] && !roomGraph.connections[class_2350.field_11036.method_10146()].claimed) {
                RoomGraph monumentPieces$roomdefinition = roomGraph.connections[class_2350.field_11043.method_10146()];
                return monumentPieces$roomdefinition.hasOpening[class_2350.field_11036.method_10146()] && !monumentPieces$roomdefinition.connections[class_2350.field_11036.method_10146()].claimed;
            }
            return false;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            roomGraph.connections[class_2350.field_11043.method_10146()].claimed = true;
            roomGraph.connections[class_2350.field_11036.method_10146()].claimed = true;
            roomGraph.connections[class_2350.field_11043.method_10146()].connections[class_2350.field_11036.method_10146()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/double_yz", MonumentPieces.getRoomPosition(roomGraph, 2), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            class_2338 pos;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 pos2;
                class_2470 rotation;
                if (direction != class_2350.field_11043) {
                    if (roomGraph.hasOpening[direction.method_10146()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(4, 1, 12).method_10079(direction, 4);
                        if (rotation == class_2470.field_11463) {
                            pos2 = pos2.method_10069(-1, 0, -1);
                        } else if (rotation == class_2470.field_11464) {
                            pos2 = pos2.method_10069(0, 0, -1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                    }
                    if (roomGraph.connections[class_2350.field_11036.method_10146()].hasOpening[direction.method_10146()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(4, 1, 11).method_10079(direction, 5);
                        if (rotation == class_2470.field_11463) {
                            pos2 = pos2.method_10069(-2, 0, -1);
                        } else if (rotation == class_2470.field_11464) {
                            pos2 = pos2.method_10069(1, 0, -1);
                        } else if (rotation == class_2470.field_11465) {
                            pos2 = pos2.method_10069(1, 0, 2);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_shelf", pos2, rotation, random, type, liquidSettings));
                    }
                }
                if (direction == class_2350.field_11035) continue;
                if (roomGraph.connections[class_2350.field_11043.method_10146()].hasOpening[direction.method_10146()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(3, 1, 4).method_10079(direction, 4);
                    if (rotation == class_2470.field_11463) {
                        pos2 = pos2.method_10069(0, 0, -1);
                    } else if (rotation == class_2470.field_11464) {
                        pos2 = pos2.method_10069(1, 0, -1);
                    } else if (rotation == class_2470.field_11465) {
                        pos2 = pos2.method_10069(1, 0, 0);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                }
                if (!roomGraph.connections[class_2350.field_11036.method_10146()].connections[class_2350.field_11043.method_10146()].hasOpening[direction.method_10146()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 1, 5).method_10079(direction, 5);
                if (rotation == class_2470.field_11463) {
                    pos2 = pos2.method_10069(0, 0, -3);
                } else if (rotation == class_2470.field_11464) {
                    pos2 = pos2.method_10069(2, 0, -2);
                } else if (rotation == class_2470.field_11465) {
                    pos2 = pos2.method_10069(3, 0, 0);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_shelf", pos2, rotation, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11036.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11036.method_10146()].connections[class_2350.field_11043.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 8, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static class FitDoubleYRoom
    implements MonumentRoomFitter {
        FitDoubleYRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[class_2350.field_11036.method_10146()] && !roomGraph.connections[class_2350.field_11036.method_10146()].claimed;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            roomGraph.connections[class_2350.field_11036.method_10146()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/double_y", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 pos;
                class_2470 rotation;
                if (roomGraph.hasOpening[direction.method_10146()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(3, 1, 3).method_10079(direction, 4);
                    pos = rotation == class_2470.field_11463 ? pos.method_10069(0, 0, -2) : (rotation == class_2470.field_11464 ? pos.method_10069(3, 0, 0) : (rotation == class_2470.field_11465 ? pos.method_10069(1, 0, 3) : pos.method_10069(-2, 0, 1)));
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/arch", pos, rotation, random, type, liquidSettings));
                }
                if (!roomGraph.connections[class_2350.field_11036.method_10146()].hasOpening[direction.method_10146()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(3, 5, 3).method_10079(direction, 4);
                pos = rotation == class_2470.field_11463 ? pos.method_10069(0, 0, -2) : (rotation == class_2470.field_11464 ? pos.method_10069(3, 0, 0) : (rotation == class_2470.field_11465 ? pos.method_10069(1, 0, 3) : pos.method_10069(-2, 0, 1)));
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/arch", pos, rotation, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11036.ordinal()].hasOpening[class_2350.field_11036.method_10146()]) {
                class_2338 pos = MonumentPieces.getRoomPosition(roomGraph, 1).method_10069(2, 8, 2);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static class FitDoubleXYRoom
    implements MonumentRoomFitter {
        FitDoubleXYRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            if (roomGraph.hasOpening[class_2350.field_11034.method_10146()] && !roomGraph.connections[class_2350.field_11034.method_10146()].claimed && roomGraph.hasOpening[class_2350.field_11036.method_10146()] && !roomGraph.connections[class_2350.field_11036.method_10146()].claimed) {
                RoomGraph monumentPieces$roomdefinition = roomGraph.connections[class_2350.field_11034.method_10146()];
                return monumentPieces$roomdefinition.hasOpening[class_2350.field_11036.method_10146()] && !monumentPieces$roomdefinition.connections[class_2350.field_11036.method_10146()].claimed;
            }
            return false;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            roomGraph.connections[class_2350.field_11034.method_10146()].claimed = true;
            roomGraph.connections[class_2350.field_11036.method_10146()].claimed = true;
            roomGraph.connections[class_2350.field_11034.method_10146()].connections[class_2350.field_11036.method_10146()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/double_xy", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            class_2338 pos;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 pos2;
                class_2470 rotation;
                if (direction != class_2350.field_11034) {
                    if (roomGraph.hasOpening[direction.method_10146()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(3, 1, 11).method_10079(direction, 4);
                        if (rotation == class_2470.field_11464) {
                            pos2 = pos2.method_10069(1, 0, 0);
                        } else if (rotation == class_2470.field_11465) {
                            pos2 = pos2.method_10069(1, 0, 1);
                        } else if (rotation == class_2470.field_11467) {
                            pos2 = pos2.method_10069(0, 0, 1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                    }
                    if (roomGraph.connections[class_2350.field_11036.method_10146()].hasOpening[direction.method_10146()]) {
                        rotation = MonumentPieces.getOpeningRotationFull(direction);
                        pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(3, 5, 11).method_10079(direction, 4);
                        if (rotation == class_2470.field_11464) {
                            pos2 = pos2.method_10069(1, 0, 0);
                        } else if (rotation == class_2470.field_11465) {
                            pos2 = pos2.method_10069(1, 0, 1);
                        } else if (rotation == class_2470.field_11467) {
                            pos2 = pos2.method_10069(0, 0, 1);
                        }
                        childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                    }
                }
                if (direction == class_2350.field_11039) continue;
                if (roomGraph.connections[class_2350.field_11034.method_10146()].hasOpening[direction.method_10146()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(11, 1, 11).method_10079(direction, 4);
                    if (rotation == class_2470.field_11463) {
                        pos2 = pos2.method_10069(0, 0, 0);
                    } else if (rotation == class_2470.field_11464) {
                        pos2 = pos2.method_10069(1, 0, 0);
                    } else if (rotation == class_2470.field_11467) {
                        pos2 = pos2.method_10069(0, 0, 1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                }
                if (!roomGraph.connections[class_2350.field_11036.method_10146()].connections[class_2350.field_11034.method_10146()].hasOpening[direction.method_10146()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(11, 5, 11).method_10079(direction, 4);
                if (rotation == class_2470.field_11463) {
                    pos2 = pos2.method_10069(0, 0, 0);
                } else if (rotation == class_2470.field_11464) {
                    pos2 = pos2.method_10069(1, 0, 0);
                } else if (rotation == class_2470.field_11467) {
                    pos2 = pos2.method_10069(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11036.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11036.method_10146()].connections[class_2350.field_11034.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(10, 8, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static class FitDoubleXRoom
    implements MonumentRoomFitter {
        FitDoubleXRoom() {
        }

        @Override
        public boolean fits(RoomGraph roomGraph) {
            return roomGraph.hasOpening[class_2350.field_11034.method_10146()] && !roomGraph.connections[class_2350.field_11034.method_10146()].claimed;
        }

        @Override
        public class_3443 create(class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 rotation, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            roomGraph.claimed = true;
            roomGraph.connections[class_2350.field_11034.method_10146()].claimed = true;
            return MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/rooms/double_x", MonumentPieces.getRoomPosition(roomGraph, 1), rotation, random, type, liquidSettings);
        }

        @Override
        public void createOpenings(List<class_3443> childPieces, class_2378<class_3785> poolRegistry, class_3485 StructureTemplateManager, class_2470 none, RoomGraph roomGraph, class_5819 random, String type, class_9822 liquidSettings) {
            class_2338 pos;
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 pos2;
                class_2470 rotation;
                if (direction != class_2350.field_11034 && roomGraph.hasOpening[direction.method_10146()]) {
                    rotation = MonumentPieces.getOpeningRotationFull(direction);
                    pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(3, 1, 11).method_10079(direction, 4);
                    if (rotation == class_2470.field_11464) {
                        pos2 = pos2.method_10069(1, 0, 0);
                    } else if (rotation == class_2470.field_11465) {
                        pos2 = pos2.method_10069(1, 0, 1);
                    } else if (rotation == class_2470.field_11467) {
                        pos2 = pos2.method_10069(0, 0, 1);
                    }
                    childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
                }
                if (direction == class_2350.field_11039 || !roomGraph.connections[class_2350.field_11034.method_10146()].hasOpening[direction.method_10146()]) continue;
                rotation = MonumentPieces.getOpeningRotationFull(direction);
                pos2 = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(11, 1, 11).method_10079(direction, 4);
                if (rotation == class_2470.field_11463) {
                    pos2 = pos2.method_10069(0, 0, 0);
                } else if (rotation == class_2470.field_11464) {
                    pos2 = pos2.method_10069(1, 0, 0);
                } else if (rotation == class_2470.field_11467) {
                    pos2 = pos2.method_10069(0, 0, 1);
                }
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/wall_3", pos2, rotation, random, type, liquidSettings));
            }
            if (roomGraph.hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(2, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
            if (roomGraph.connections[class_2350.field_11034.method_10146()].hasOpening[class_2350.field_11036.method_10146()]) {
                pos = MonumentPieces.getRoomPosition(roomGraph, 2).method_10069(10, 4, 10);
                childPieces.add(MonumentPieces.getJigsawPiece(poolRegistry, StructureTemplateManager, "repurposed_structures:monuments/" + type + "/openings/floor", pos, class_2470.field_11467, random, type, liquidSettings));
            }
        }
    }

    static interface MonumentRoomFitter {
        public boolean fits(RoomGraph var1);

        public class_3443 create(class_2378<class_3785> var1, class_3485 var2, class_2470 var3, RoomGraph var4, class_5819 var5, String var6, class_9822 var7);

        public void createOpenings(List<class_3443> var1, class_2378<class_3785> var2, class_3485 var3, class_2470 var4, RoomGraph var5, class_5819 var6, String var7, class_9822 var8);
    }
}

