/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.misc.maptrades.MerchantMapUpdating;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements class_3853.class_1652 {
        private final int emeraldCost;
        private final class_5321<class_3195> destination;
        private final class_6862<class_3195> destinationTag;
        private final String displayName;
        private final class_6880.class_6883<class_9428> destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, class_6880.class_6883<class_9428> mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_12829((String)csf.replaceFirst("#", "")));
            } else {
                this.destination = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)class_2960.method_12829((String)csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        @Nullable
        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            class_1937 class_19372 = entity.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return null;
            }
            class_3218 serverlevel = (class_3218)class_19372;
            return this.getOffer(serverlevel, entity);
        }

        private class_6885<class_3195> getHolderSet(class_3218 level) {
            class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
            return class_6885.method_40246((class_6880[])new class_6880[]{registry.method_40290(this.destination)});
        }

        private boolean mapValid(class_3218 level) {
            class_6885 holderSet;
            if (this.destinationTag == null) {
                holderSet = this.getHolderSet(level);
            } else {
                Optional optionalHolders = level.method_30349().method_30530(class_7924.field_41246).method_40266(this.destinationTag);
                if (optionalHolders.isEmpty()) {
                    return false;
                }
                holderSet = (class_6885)optionalHolders.get();
            }
            boolean isValidSpawning = true;
            for (class_6880 structureHolder : holderSet) {
                if (level.method_14178().method_46642().method_46708(structureHolder).isEmpty()) {
                    isValidSpawning = false;
                    break;
                }
                if (!level.method_14178().method_12129().method_12098().method_28443().stream().noneMatch(e -> ((class_3195)structureHolder.comp_349()).method_41607().method_40241(e))) continue;
                isValidSpawning = false;
                break;
            }
            return isValidSpawning;
        }

        private class_1914 getOffer(class_3218 level, class_1297 entity) {
            if (!this.mapValid(level)) {
                return null;
            }
            if (this.destinationTag == null) {
                class_6885<class_3195> holderSet = this.getHolderSet(level);
                return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, holderSet, this.spawnRegionSearchRadius);
            }
            return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, this.destinationTag, this.spawnRegionSearchRadius);
        }
    }
}

