/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.events.RegisterVillagerTradesEvent;
import com.telepathicgrunt.repurposedstructures.events.RegisterWanderingTradesEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.RegisterReloadListenerEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStartEvent;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStopEvent;
import com.telepathicgrunt.repurposedstructures.misc.FabricReloadListener;
import com.telepathicgrunt.repurposedstructures.world.biomemodifiers.BiomeModifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_7923;

public class RepurposedStructuresFabric
implements ModInitializer {
    public void onInitialize() {
        RSModdedLootConfig.setup();
        RepurposedStructures.init();
        BiomeModifier.addFeatures();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ServerGoingToStartEvent.EVENT.invoke(new ServerGoingToStartEvent(server));
            RepurposedStructuresFabric.setupWanderingTrades();
            RepurposedStructuresFabric.setupVillagerTrades();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ServerGoingToStopEvent.EVENT.invoke(ServerGoingToStopEvent.INSTANCE));
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener((class_2960)id, (class_3302)listener))));
    }

    private static void setupWanderingTrades() {
        Int2ObjectMap trades = class_3853.field_17724;
        List<class_3853.class_1652> basic = Arrays.stream((class_3853.class_1652[])trades.get(1)).collect(Collectors.toList());
        List<class_3853.class_1652> rare = Arrays.stream((class_3853.class_1652[])trades.get(2)).collect(Collectors.toList());
        RegisterWanderingTradesEvent.EVENT.invoke(new RegisterWanderingTradesEvent(basic::add, rare::add));
        trades.put(1, (Object)basic.toArray(new class_3853.class_1652[0]));
        trades.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static void setupVillagerTrades() {
        Map trades = class_3853.field_17067;
        for (class_3852 profession : class_7923.field_41195) {
            int i;
            if (profession == null) continue;
            Int2ObjectMap profTrades = trades.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap listings = new Int2ObjectOpenHashMap();
            for (i = 1; i <= 5; ++i) {
                if (profTrades.containsKey(i)) {
                    List list = Arrays.stream((class_3853.class_1652[])profTrades.get(i)).collect(Collectors.toList());
                    listings.put(i, list);
                    continue;
                }
                listings.put(i, new ArrayList());
            }
            RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent(profession, (arg_0, arg_1) -> RepurposedStructuresFabric.lambda$setupVillagerTrades$4((Int2ObjectMap)listings, arg_0, arg_1)));
            for (i = 1; i <= 5; ++i) {
                profTrades.put(i, (Object)((List)listings.get(i)).toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private static /* synthetic */ void lambda$setupVillagerTrades$4(Int2ObjectMap listings, Integer i, class_3853.class_1652 listing) {
        ((List)listings.get(i.intValue())).add(listing);
    }
}

