/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.TargetHelper;
import net.bettercombat.logic.knockback.ConfigurableKnockback;
import net.bettercombat.mixin.player.LivingEntityAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.AttributeModifierHelper;
import net.bettercombat.utils.MathHelper;
import net.bettercombat.utils.SoundHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2824;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ServerNetwork {
    static final Logger LOGGER = LogUtils.getLogger();
    public static class_2960 TEMPORARY_ATTACK = class_2960.method_60655((String)"bettercombat", (String)"temp_attack");

    public static void handleAttackAnimation(Packets.AttackAnimation packet, MinecraftServer server, class_3222 player) {
        class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
        if (world == null || world.field_9236) {
            return;
        }
        Packets.AttackAnimation forwardPacket = new Packets.AttackAnimation(player.method_5628(), packet.animatedHand(), packet.animationName(), packet.length(), packet.upswing());
        try {
            if (Platform.networkS2C_CanSend(player, Packets.AttackAnimation.ID)) {
                Platform.networkS2C_Send(player, forwardPacket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Platform.tracking(player).forEach(serverPlayer -> {
            try {
                if (Platform.networkS2C_CanSend(serverPlayer, Packets.AttackAnimation.ID)) {
                    Platform.networkS2C_Send(serverPlayer, forwardPacket);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void handleAttackRequest(Packets.C2S_AttackRequest request, MinecraftServer server, class_3222 player, class_3244 handler) {
        class_3218 world = (class_3218)Iterables.tryFind((Iterable)server.method_3738(), element -> element == player.method_37908()).orNull();
        if (world == null || world.field_9236) {
            return;
        }
        AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)player, request.comboCount());
        if (hand == null) {
            LOGGER.error("Server handling Packets.C2S_AttackRequest - No current attack hand!");
            LOGGER.error("Combo count: " + request.comboCount() + " is dual wielding: " + PlayerAttackHelper.isDualWielding((class_1657)player));
            LOGGER.error("Main-hand stack: " + String.valueOf(player.method_6047()));
            LOGGER.error("Off-hand stack: " + String.valueOf(player.method_6079()));
            LOGGER.error("Selected slot server: " + player.method_31548().field_7545 + " | client: " + request.selectedSlot());
            return;
        }
        WeaponAttributes.Attack attack = hand.attack();
        WeaponAttributes attributes = hand.attributes();
        boolean useVanillaPacket = Packets.C2S_AttackRequest.UseVanillaPacket;
        world.method_8503().method_40000(() -> {
            ((PlayerAttackProperties)player).setComboCount(request.comboCount());
            PlayerAttackHelper.swapHandAttributes((class_1657)player, hand.isOffHand(), () -> {
                double damageBaseMultiplier = 0.0;
                double range = 18.0;
                boolean isDualWielding = PlayerAttackHelper.isDualWielding((class_1657)player);
                if (attributes != null && attack != null) {
                    range = PlayerAttackHelper.getRangeForItem((class_1657)player, hand.itemStack());
                    double comboMultiplier = attack.damageMultiplier() - 1.0;
                    damageBaseMultiplier += comboMultiplier;
                    float dualWieldingMultiplier = PlayerAttackHelper.getDualWieldingAttackDamageMultiplier((class_1657)player, hand) - 1.0f;
                    damageBaseMultiplier += (double)dualWieldingMultiplier;
                    SoundHelper.playSound(world, (class_1297)player, attack.swingSound());
                    if (BetterCombatMod.config.allow_reworked_sweeping && request.entityIds().length > 1) {
                        boolean playEffects;
                        double multiplier = 0.0f - BetterCombatMod.config.reworked_sweeping_maximum_damage_penalty / (float)BetterCombatMod.config.reworked_sweeping_extra_target_count * (float)Math.min(BetterCombatMod.config.reworked_sweeping_extra_target_count, request.entityIds().length - 1);
                        double sweepRatio = player.method_45325(class_5134.field_51577);
                        damageBaseMultiplier += multiplier + (double)BetterCombatMod.config.reworked_sweeping_maximum_damage_penalty * sweepRatio;
                        boolean bl = playEffects = !BetterCombatMod.config.reworked_sweeping_sound_and_particles_only_for_swords || hand.itemStack().method_7909() instanceof class_1829;
                        if (BetterCombatMod.config.reworked_sweeping_plays_sound && playEffects) {
                            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, player.method_5634(), 1.0f, 1.0f);
                        }
                        if (BetterCombatMod.config.reworked_sweeping_emits_particles && playEffects) {
                            player.method_7263();
                        }
                    }
                }
                Multimap<class_6880<class_1320>, class_1322> damageModifier = null;
                if (damageBaseMultiplier != 0.0) {
                    AttributeModifierHelper.fromModifier((class_6880<class_1320>)class_5134.field_23721, null);
                    damageModifier = AttributeModifierHelper.fromModifier((class_6880<class_1320>)class_5134.field_23721, new class_1322(TEMPORARY_ATTACK, damageBaseMultiplier, class_1322.class_1323.field_6330));
                    player.method_6127().method_59932(damageModifier);
                }
                float attackCooldown = PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)player);
                float knockbackMultiplier = 1.0f;
                if (BetterCombatMod.config.knockback_reduced_for_fast_attacks) {
                    knockbackMultiplier = MathHelper.clamp(attackCooldown / BetterCombatMod.config.knockback_reduction_threshold, 0.1f, 1.0f);
                    switch (BetterCombatMod.config.knockback_reduction_curve) {
                        case SQUARE: {
                            knockbackMultiplier *= knockbackMultiplier;
                            break;
                        }
                        case HALF_SQUARE: {
                            knockbackMultiplier = (knockbackMultiplier * knockbackMultiplier + knockbackMultiplier) * 0.5f;
                            break;
                        }
                    }
                }
                int lastAttackedTicks = ((LivingEntityAccessor)player).getLastAttackedTicks();
                if (!useVanillaPacket) {
                    player.method_5660(request.isSneaking());
                }
                double validationRangeSquared = range * range * (double)BetterCombatMod.config.target_search_range_multiplier;
                for (int entityId : request.entityIds()) {
                    class_1309 livingEntity;
                    boolean isDirectHit;
                    boolean isBossPart = false;
                    class_1297 entity = world.method_8469(entityId);
                    if (entity == null) {
                        isBossPart = true;
                        entity = world.method_31424(entityId);
                    }
                    if (entity == null || entity.equals((Object)player.method_5854()) && !TargetHelper.isAttackableMount(entity) || entity instanceof class_1531 && ((class_1531)entity).method_6912()) continue;
                    boolean bl = isDirectHit = entityId == request.cursorTarget();
                    if (!TargetHelper.isHitAllowed(isDirectHit, TargetHelper.getRelation((class_1657)player, entity))) continue;
                    if (entity instanceof class_1309) {
                        livingEntity = (class_1309)entity;
                        if (BetterCombatMod.config.allow_fast_attacks) {
                            livingEntity.field_6008 = 0;
                        }
                        if (knockbackMultiplier != 1.0f) {
                            ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(knockbackMultiplier);
                        }
                    }
                    ((LivingEntityAccessor)player).setLastAttackedTicks(lastAttackedTicks);
                    if (!isBossPart && useVanillaPacket) {
                        class_2824 vanillaAttackPacket = class_2824.method_34206((class_1297)entity, (boolean)request.isSneaking());
                        handler.method_12062(vanillaAttackPacket);
                    } else if (!BetterCombatMod.config.server_target_range_validation || player.method_5858(entity) <= validationRangeSquared) {
                        if (entity instanceof class_1542 || entity instanceof class_1303 || entity instanceof class_1665 || entity == player) {
                            handler.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.method_5477().getString());
                            return;
                        }
                        player.method_7324(entity);
                    }
                    if (!(entity instanceof class_1309)) continue;
                    livingEntity = (class_1309)entity;
                    if (knockbackMultiplier == 1.0f) continue;
                    ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(1.0f);
                }
                if (!useVanillaPacket) {
                    player.method_14234();
                }
                if (damageModifier != null) {
                    player.method_6127().method_59935(damageModifier);
                }
                ((PlayerAttackProperties)player).setComboCount(-1);
            });
        });
    }

    public static void handleBlockHit(Packets.C2S_BlockHit packet, MinecraftServer server, class_3222 player) {
        class_1937 world = player.method_37908();
        if (world == null) {
            return;
        }
        class_2680 block = world.method_8320(packet.pos());
        if (block == null || block.method_26215()) {
            return;
        }
        class_2498 soundGroup = block.method_26231();
        if (soundGroup != null) {
            world.method_43128(null, (double)packet.pos().method_10263(), (double)packet.pos().method_10264(), (double)packet.pos().method_10260(), soundGroup.method_10596(), player.method_5634(), 1.0f, 1.0f);
        }
    }
}

