/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_863;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_863.class})
public class ColliderDebugRenderer {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderColliderDebug(class_4587 matrices, class_4597.class_4598 vertexConsumers, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (!((MinecraftClientAccessor)client).getEntityRenderDispatcher().method_3958()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (!BetterCombatClientMod.config.isDebugOBBEnabled) {
            return;
        }
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332()) {
            return;
        }
        if (client.field_1724.method_6047() == null) {
            return;
        }
        MinecraftClient_BetterCombat extendedClient = (MinecraftClient_BetterCombat)client;
        int comboCount = extendedClient.getComboCount();
        AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)client.field_1724, comboCount);
        if (hand == null) {
            return;
        }
        WeaponAttributes attributes = hand.attributes();
        if (attributes == null) {
            return;
        }
        class_1297 cursorTarget = extendedClient.getCursorTarget();
        double range = PlayerAttackHelper.getRangeForItem((class_1657)player, hand.itemStack());
        TargetFinder.TargetResult target = TargetFinder.findAttackTargetResult((class_1657)player, cursorTarget, hand.attack(), range);
        boolean collides = target.entities.size() > 0;
        class_243 cameraOffset = camera.method_19326().method_22882();
        OrientedBoundingBox obb = target.obb.copy().offset(cameraOffset).updateVertex();
        List<OrientedBoundingBox> collidingObbs = target.entities.stream().map(entity -> new OrientedBoundingBox(entity.method_5829()).offset(cameraOffset).scale(0.95).updateVertex()).collect(Collectors.toList());
        this.drawOutline(matrices, obb, collidingObbs, collides);
    }

    private void drawOutline(class_4587 matrixStack, OrientedBoundingBox obb, List<OrientedBoundingBox> otherObbs, boolean collides) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        if (collides) {
            this.outlineOBB(matrixStack, obb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        } else {
            this.outlineOBB(matrixStack, obb, bufferBuilder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f);
        }
        this.look(matrixStack, obb, bufferBuilder, 0.5f);
        for (OrientedBoundingBox otherObb : otherObbs) {
            this.outlineOBB(matrixStack, otherObb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
    }

    private void outlineOBB(class_4587 matrixStack, OrientedBoundingBox box, class_287 buffer, float red1, float green1, float blue1, float red2, float green2, float blue2, float alpha) {
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        buffer.method_22918(matrix4f, (float)box.vertex1.field_1352, (float)box.vertex1.field_1351, (float)box.vertex1.field_1350).method_1336(0, 0, 0, 0);
        buffer.method_22918(matrix4f, (float)box.vertex1.field_1352, (float)box.vertex1.field_1351, (float)box.vertex1.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex2.field_1352, (float)box.vertex2.field_1351, (float)box.vertex2.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex3.field_1352, (float)box.vertex3.field_1351, (float)box.vertex3.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex4.field_1352, (float)box.vertex4.field_1351, (float)box.vertex4.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex1.field_1352, (float)box.vertex1.field_1351, (float)box.vertex1.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex5.field_1352, (float)box.vertex5.field_1351, (float)box.vertex5.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex6.field_1352, (float)box.vertex6.field_1351, (float)box.vertex6.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex2.field_1352, (float)box.vertex2.field_1351, (float)box.vertex2.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex6.field_1352, (float)box.vertex6.field_1351, (float)box.vertex6.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex7.field_1352, (float)box.vertex7.field_1351, (float)box.vertex7.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex3.field_1352, (float)box.vertex3.field_1351, (float)box.vertex3.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex7.field_1352, (float)box.vertex7.field_1351, (float)box.vertex7.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex8.field_1352, (float)box.vertex8.field_1351, (float)box.vertex8.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex4.field_1352, (float)box.vertex4.field_1351, (float)box.vertex4.field_1350).method_22915(red1, green1, blue1, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex8.field_1352, (float)box.vertex8.field_1351, (float)box.vertex8.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex5.field_1352, (float)box.vertex5.field_1351, (float)box.vertex5.field_1350).method_22915(red2, green2, blue2, alpha);
        buffer.method_22918(matrix4f, (float)box.vertex5.field_1352, (float)box.vertex5.field_1351, (float)box.vertex5.field_1350).method_1336(0, 0, 0, 0);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_1336(0, 0, 0, 0);
    }

    private void look(class_4587 matrixStack, OrientedBoundingBox box, class_287 buffer, float alpha) {
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 0.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.axisZ.field_1352, (float)box.axisZ.field_1351, (float)box.axisZ.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.axisY.field_1352, (float)box.axisY.field_1351, (float)box.axisY.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.axisX.field_1352, (float)box.axisX.field_1351, (float)box.axisX.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha);
        buffer.method_22918(matrix4f, (float)box.center.field_1352, (float)box.center.field_1351, (float)box.center.field_1350).method_22915(0.0f, 0.0f, 0.0f, alpha);
    }

    public void printDebug(OrientedBoundingBox obb) {
        class_243 extent_x = obb.axisX.method_1021(obb.extent.field_1352);
        class_243 extent_y = obb.axisY.method_1021(obb.extent.field_1351);
        class_243 extent_z = obb.axisZ.method_1021(obb.extent.field_1350);
        System.out.println("Center: " + this.vec3Short(obb.center) + " Extent: " + this.vec3Short(obb.extent));
        System.out.println("scaledAxisX: " + this.vec3Short(obb.scaledAxisX) + "scaledAxisY: " + this.vec3Short(obb.scaledAxisY) + "scaledAxisZ: " + this.vec3Short(obb.scaledAxisZ));
        System.out.println("1:" + this.vec3Short(obb.vertex1) + " 2:" + this.vec3Short(obb.vertex2) + " 3:" + this.vec3Short(obb.vertex3) + " 4:" + this.vec3Short(obb.vertex4));
        System.out.println("5:" + this.vec3Short(obb.vertex5) + " 6:" + this.vec3Short(obb.vertex6) + " 7:" + this.vec3Short(obb.vertex7) + " 8:" + this.vec3Short(obb.vertex8));
    }

    private String vec3Short(class_243 vec) {
        return "{" + String.format("%.3f", vec.field_1352) + ", " + String.format("%.3f", vec.field_1351) + ", " + String.format("%.3f", vec.field_1350) + "}";
    }

    private class_243[] getVertices(class_238 box) {
        return new class_243[]{new class_243(box.field_1323, (double)((float)box.field_1322), (double)((float)box.field_1321)), new class_243(box.field_1320, (double)((float)box.field_1322), (double)((float)box.field_1321)), new class_243(box.field_1323, (double)((float)box.field_1325), (double)((float)box.field_1321)), new class_243(box.field_1323, (double)((float)box.field_1322), (double)((float)box.field_1324)), new class_243(box.field_1320, (double)((float)box.field_1325), (double)((float)box.field_1321)), new class_243(box.field_1323, (double)((float)box.field_1325), (double)((float)box.field_1324)), new class_243(box.field_1320, (double)((float)box.field_1322), (double)((float)box.field_1324)), new class_243(box.field_1320, (double)((float)box.field_1325), (double)((float)box.field_1324))};
    }
}

