/*
 * Decompiled with CFR 0.152.
 */
package com.impillagers.mod.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.impillagers.mod.Impillagers;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;

public class ImpillagerProfessionHandler {
    private static final String CONFIG_PATH = "/data/impillagers/entity/impillager/impillager_professions.json";
    private static final Set<String> VALID_POI_SET;
    private static final Map<String, ProfessionTexturePair> PROFESSION_TEXTURES;
    private static final class_2960 DEFAULT_FALLBACK_TEXTURE;

    private static boolean resourceExists(class_2960 id) {
        String resourcePath = "/assets/" + id.method_12836() + "/" + id.method_12832();
        return Impillagers.class.getResourceAsStream(resourcePath) != null;
    }

    public static Set<String> getValidPoiSet() {
        return VALID_POI_SET;
    }

    public static class_2960 getImpillagerTextureForProfession(String professionKey) {
        ProfessionTexturePair pair = PROFESSION_TEXTURES.get(professionKey);
        return pair == null || pair.impillager == null ? DEFAULT_FALLBACK_TEXTURE : pair.impillager;
    }

    public static class_2960 getZombieTextureForProfession(String professionKey) {
        ProfessionTexturePair pair = PROFESSION_TEXTURES.get(professionKey);
        return pair == null || pair.zombie == null ? DEFAULT_FALLBACK_TEXTURE : pair.zombie;
    }

    public static Set<String> getProfessionKeys() {
        return Collections.unmodifiableSet(PROFESSION_TEXTURES.keySet());
    }

    static {
        block26: {
            VALID_POI_SET = new HashSet<String>();
            PROFESSION_TEXTURES = new HashMap<String, ProfessionTexturePair>();
            try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(ImpillagerProfessionHandler.class.getResourceAsStream(CONFIG_PATH)));){
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (jsonObject.has("profession_textures") && jsonObject.get("profession_textures").isJsonObject()) {
                    JsonObject textures = jsonObject.getAsJsonObject("profession_textures");
                    for (Map.Entry entry : textures.entrySet()) {
                        class_2960 zombieTexture;
                        class_2960 impTexture;
                        String key = (String)entry.getKey();
                        try {
                            class_2960.method_60654((String)key);
                        }
                        catch (Exception e) {
                            Impillagers.LOGGER.error("Invalid profession key detected in JSON: {}", (Object)key);
                            continue;
                        }
                        String[] parts = key.split(":", 2);
                        String namespace = parts[0];
                        String professionName = parts[1];
                        class_2960 poiId = class_2960.method_60655((String)namespace, (String)(professionName + "_poi"));
                        VALID_POI_SET.add(poiId.toString());
                        if (!((JsonElement)entry.getValue()).isJsonObject()) {
                            Impillagers.LOGGER.error("Expected an object for profession key {} but found: {}", (Object)key, entry.getValue());
                            continue;
                        }
                        JsonObject texturePairObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        if (texturePairObj.has("impillager") && texturePairObj.get("impillager").isJsonPrimitive()) {
                            String impStr = texturePairObj.get("impillager").getAsString();
                            try {
                                impTexture = class_2960.method_60654((String)impStr);
                                if (!ImpillagerProfessionHandler.resourceExists(impTexture)) {
                                    Impillagers.LOGGER.error("Impillager texture resource not found for key {}: {}. Falling back to nitwit texture.", (Object)key, (Object)impStr);
                                    impTexture = null;
                                }
                            }
                            catch (Exception e) {
                                Impillagers.LOGGER.error("Invalid impillager texture identifier for key {}: {}. Falling back to nitwit texture.", (Object)key, (Object)impStr);
                                impTexture = null;
                            }
                        } else {
                            Impillagers.LOGGER.error("Missing 'impillager' texture for key {}. Falling back to nitwit texture.", (Object)key);
                            impTexture = null;
                        }
                        if (texturePairObj.has("zombieimpillager") && texturePairObj.get("zombieimpillager").isJsonPrimitive()) {
                            String zomStr = texturePairObj.get("zombieimpillager").getAsString();
                            try {
                                zombieTexture = class_2960.method_60654((String)zomStr);
                                if (!ImpillagerProfessionHandler.resourceExists(zombieTexture)) {
                                    Impillagers.LOGGER.error("Zombie impillager texture resource not found for key {}: {}. Falling back to nitwit texture.", (Object)key, (Object)zomStr);
                                    zombieTexture = null;
                                }
                            }
                            catch (Exception e) {
                                Impillagers.LOGGER.error("Invalid zombieimpillager texture identifier for key {}: {}. Falling back to nitwit texture.", (Object)key, (Object)zomStr);
                                zombieTexture = null;
                            }
                        } else {
                            Impillagers.LOGGER.error("Missing 'zombieimpillager' texture for key {}. Falling back to nitwit texture.", (Object)key);
                            zombieTexture = null;
                        }
                        PROFESSION_TEXTURES.put(key, new ProfessionTexturePair(impTexture, zombieTexture));
                    }
                    break block26;
                }
                Impillagers.LOGGER.error("Warning: 'profession_textures' is missing or not an object in /data/impillagers/entity/impillager/impillager_professions.json");
            }
            catch (Exception e) {
                Impillagers.LOGGER.error("Error reading configuration from /data/impillagers/entity/impillager/impillager_professions.json", (Throwable)e);
            }
        }
        ProfessionTexturePair nitwitPair = PROFESSION_TEXTURES.get("minecraft:nitwit");
        if (nitwitPair != null && nitwitPair.impillager != null) {
            DEFAULT_FALLBACK_TEXTURE = nitwitPair.impillager;
        } else {
            DEFAULT_FALLBACK_TEXTURE = class_2960.method_60655((String)"impillagers", (String)"textures/entity/impillager/professions/nitwit.png");
            Impillagers.LOGGER.error("Cannot find valid nitwit texture in JSON, falling back to hard-coded default: {}", (Object)DEFAULT_FALLBACK_TEXTURE);
        }
    }

    public record ProfessionTexturePair(class_2960 impillager, class_2960 zombie) {
    }
}

