/*
 * Decompiled with CFR 0.152.
 */
package com.impillagers.mod.item.custom;

import com.google.common.collect.ImmutableMap;
import com.impillagers.mod.component.ModDataComponentTypes;
import com.impillagers.mod.effect.ModEffects;
import com.impillagers.mod.item.ModArmorMaterials;
import com.impillagers.mod.util.HudOverlayOpacityPayload;
import com.impillagers.mod.util.ModTags;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8710;

public class FrogMaskItem
extends class_1738 {
    private static final Map<class_6880<class_1741>, List<class_1293>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put(ModArmorMaterials.FROG_MASK_MATERIAL, List.of(new class_1293(ModEffects.CALL_OF_THE_IMPS, 40, 0, false, false))).build();

    public FrogMaskItem(class_6880<class_1741> material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.hasHelmetOn(player)) {
                this.evaluateArmorEffects(player);
            } else {
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new HudOverlayOpacityPayload(0.0f));
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void evaluateArmorEffects(class_1657 player) {
        for (Map.Entry<class_6880<class_1741>, List<class_1293>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_6880<class_1741> mapArmorMaterial = entry.getKey();
            List<class_1293> mapStatusEffects = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffects);
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_6880<class_1741> mapArmorMaterial, List<class_1293> mapStatusEffect) {
        boolean hasPlayerEffect = mapStatusEffect.stream().allMatch(statusEffectInstance -> player.method_6059(statusEffectInstance.method_5579()));
        if (!hasPlayerEffect) {
            for (class_1293 instance : mapStatusEffect) {
                player.method_6092(new class_1293(instance.method_5579(), instance.method_5584(), instance.method_5578(), instance.method_5591(), instance.method_5581()));
            }
        }
    }

    private boolean hasHelmetOn(class_1657 player) {
        class_1799 helmet = player.method_31548().method_7372(3);
        return !helmet.method_7960();
    }

    private boolean hasCorrectArmorOn(class_6880<class_1741> material, class_1657 player) {
        for (class_1799 armorStack : player.method_31548().field_7548) {
            class_1738 helmet;
            if (!(armorStack.method_7909() instanceof FrogMaskItem) || (helmet = (class_1738)player.method_31548().method_7372(3).method_7909()).method_7686() != material) continue;
            this.updateVillageCoordinates(armorStack, player);
            float threshold = 45.0f;
            double angle = this.isLookingAtVillage(armorStack, player, threshold);
            if (!(angle >= 0.0)) continue;
            return true;
        }
        return false;
    }

    private void updateVillageCoordinates(class_1799 stack, class_1657 player) {
        class_3218 serverWorld = (class_3218)player.method_37908();
        class_2338 villageLocation = serverWorld.method_8487(ModTags.StructureKeys.IMPILLAGER_VILLAGE, class_2338.method_49638((class_2374)player.method_19538()), 20000, false);
        if (villageLocation != null && !villageLocation.equals(stack.method_57824(ModDataComponentTypes.COORDINATES))) {
            stack.method_57379(ModDataComponentTypes.COORDINATES, (Object)villageLocation);
        }
    }

    private double isLookingAtVillage(class_1799 stack, class_1657 player, float threshold) {
        class_2338 village = (class_2338)stack.method_57824(ModDataComponentTypes.COORDINATES);
        if (village != null) {
            class_243 viewDirection = new class_243(player.method_5828((float)1.0f).field_1352, 0.0, player.method_5828((float)1.0f).field_1350).method_1029();
            class_243 villageDirection = new class_243((double)village.method_10263() - player.method_23317(), 0.0, (double)village.method_10260() - player.method_23321()).method_1029();
            double dotProduct = viewDirection.method_1026(villageDirection);
            double angle = Math.acos(dotProduct);
            angle = Math.toDegrees(angle);
            float opacity = this.calculateOpacity(angle, threshold);
            if (!player.method_5770().method_8608()) {
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new HudOverlayOpacityPayload(opacity));
            }
            if (angle < (double)threshold) {
                return angle;
            }
        }
        return -1.0;
    }

    public float calculateOpacity(double angle, double threshold) {
        if (angle >= threshold) {
            return 0.0f;
        }
        double ratio = angle / threshold;
        return (float)(1.0 - Math.pow(ratio, 2.0));
    }
}

