/*
 * Decompiled with CFR 0.152.
 */
package com.impillagers.mod.entity.custom.impillager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.impillagers.mod.effect.ModEffects;
import com.impillagers.mod.entity.ModEntities;
import com.impillagers.mod.entity.ai.brain.task.ImpillagerTaskListProvider;
import com.impillagers.mod.entity.custom.impillager.ImpillagerTextures;
import com.impillagers.mod.entity.mob.Impillager;
import com.impillagers.mod.item.ModItems;
import com.impillagers.mod.sounds.ModSoundEvents;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_4095;
import net.minecraft.class_4129;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4307;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_7244;
import org.jetbrains.annotations.Nullable;

public class ImpillagerEntity
extends class_1646 {
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public static final class_2940<String> TEXTURE_KEY = class_2945.method_12791(ImpillagerEntity.class, (class_2941)class_2943.field_13326);
    private static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18438, (Object)class_4140.field_18439, (Object)class_4140.field_25160, (Object)class_4140.field_18440, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19006, (Object)class_4140.field_18443, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22332, (Object)class_4140.field_38397, (Object[])new class_4140[]{class_4140.field_18445, class_4140.field_18446, class_4140.field_18447, class_4140.field_18448, class_4140.field_18449, class_4140.field_26389, class_4140.field_19007, class_4140.field_18451, class_4140.field_18452, class_4140.field_18453, class_4140.field_18873, class_4140.field_19008, class_4140.field_19009, class_4140.field_19293, class_4140.field_19385, class_4140.field_20616, class_4140.field_19386, class_4140.field_25754, class_4140.field_22355, class_4140.field_22475, class_4140.field_22357});
    private static final ImmutableList<class_4149<? extends class_4148<? super class_1646>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_19010, (Object)class_4149.field_18469, (Object)class_4149.field_18470, (Object)class_4149.field_19011, (Object)class_4149.field_18875, (Object)class_4149.field_25756);

    public ImpillagerEntity(class_1299<? extends class_1646> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        if (!world.field_9236) {
            this.field_6011.method_12778(TEXTURE_KEY, (Object)ImpillagerTextures.selectRandomTextureKey());
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TEXTURE_KEY, (Object)"");
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (data == TEXTURE_KEY && ((String)this.field_6011.method_12789(TEXTURE_KEY)).isEmpty()) {
            this.field_6011.method_12778(TEXTURE_KEY, (Object)ImpillagerTextures.selectRandomTextureKey());
        }
    }

    public class_2960 getCustomTexture() {
        String textureKey = (String)this.field_6011.method_12789(TEXTURE_KEY);
        return ImpillagerTextures.getTextureByKey(textureKey).orElse(class_2960.method_12829((String)"fallback_texture"));
    }

    public void setTextureKey(String textureKey) {
        this.field_6011.method_12778(TEXTURE_KEY, (Object)textureKey);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        String textureKey = (String)this.field_6011.method_12789(TEXTURE_KEY);
        if (textureKey != null && !textureKey.isEmpty()) {
            nbt.method_10582("TextureKey", textureKey);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("TextureKey")) {
            this.field_6011.method_12778(TEXTURE_KEY, (Object)nbt.method_10558("TextureKey"));
        }
    }

    public static class_5132.class_5133 createVillagerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.7).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23717, 48.0);
    }

    public boolean method_6049(class_1293 effect) {
        return !effect.method_55654(class_1294.field_5899) && super.method_6049(effect);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_20506() > 0) {
            this.method_20507(this.method_20506() - 1);
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 160;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public class_4095<class_1646> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<class_1646> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        class_4095 brain = this.method_28306().method_28335(dynamic);
        this.initBrain((class_4095<class_1646>)brain);
        return brain;
    }

    public void method_19179(class_3218 world) {
        class_4095<class_1646> brain = this.method_18868();
        brain.method_18900(world, (class_1309)this);
        this.field_18321 = brain.method_18911();
        this.initBrain(this.method_18868());
    }

    private void initBrain(class_4095<class_1646> brain) {
        class_3852 villagerProfession = this.method_7231().method_16924();
        if (this.method_6109()) {
            brain.method_18884(class_4170.field_18605);
            brain.method_18881(class_4168.field_18885, class_4129.method_19990((float)0.5f));
        } else {
            brain.method_18884(class_4170.field_18606);
            brain.method_24529(class_4168.field_18596, class_4129.method_19021((class_3852)villagerProfession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18439, (Object)class_4141.field_18456)));
        }
        brain.method_18881(class_4168.field_18594, ImpillagerTaskListProvider.createCoreTasks(villagerProfession, 0.5f));
        brain.method_24529(class_4168.field_18598, class_4129.method_19023((class_3852)villagerProfession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18440, (Object)class_4141.field_18456)));
        brain.method_18881(class_4168.field_18597, class_4129.method_19022((class_3852)villagerProfession, (float)0.5f));
        brain.method_18881(class_4168.field_18595, ImpillagerTaskListProvider.createIdleTasks(villagerProfession, 0.5f));
        brain.method_18881(class_4168.field_18599, class_4129.method_19025((class_3852)villagerProfession, (float)0.5f));
        brain.method_18881(class_4168.field_19042, class_4129.method_19991((class_3852)villagerProfession, (float)0.5f));
        brain.method_18881(class_4168.field_19041, class_4129.method_19992((class_3852)villagerProfession, (float)0.5f));
        brain.method_18881(class_4168.field_19043, class_4129.method_19993((class_3852)villagerProfession, (float)0.5f));
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24526(class_4168.field_18595);
        brain.method_18871(this.method_37908().method_8532(), this.method_37908().method_8510());
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        boolean playerNearby = this.method_37908().method_18460((class_1297)this, 5.0) != null;
        return playerNearby ? ModSoundEvents.IMPILLAGER_PURSUE : ModSoundEvents.IMPILLAGER_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.IMPILLAGER_DAMAGE;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.IMPILLAGER_DEATH;
    }

    public static class_3414 getRangedAttackSound() {
        return ModSoundEvents.IMPILLAGER_ATTACK_RANGED;
    }

    protected class_3414 getMeleeAttackSound() {
        return ModSoundEvents.IMPILLAGER_ATTACK_MELEE;
    }

    public class_3414 method_18010() {
        return ModSoundEvents.IMPILLAGER_YES;
    }

    protected class_3414 method_18012(boolean sold) {
        return sold ? ModSoundEvents.IMPILLAGER_YES : ModSoundEvents.IMPILLAGER_NO;
    }

    public void method_20010() {
        this.method_56078(ModSoundEvents.IMPILLAGER_CELEBRATE);
    }

    public class_1646 method_7225(class_3218 world, class_1296 entity) {
        return (class_1646)ModEntities.IMPILLAGER.method_5883((class_1937)world);
    }

    public boolean method_5931() {
        return true;
    }

    public boolean method_6054() {
        return true;
    }

    protected int method_6110() {
        return this.field_6194;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(ModItems.IMPILLAGER_SPAWN_EGG) || !this.method_5805() || this.method_18009() || this.method_6113()) {
            return super.method_5992(player, hand);
        }
        if (this.method_6109()) {
            this.sayNo();
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (!this.method_37908().field_9236) {
            boolean bl = this.method_8264().isEmpty();
            if (hand == class_1268.field_5808 && bl) {
                this.sayNo();
            }
            if (bl) {
                return class_1269.field_21466;
            }
            this.beginTradeWith(player);
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    private void sayNo() {
        this.method_20507(20);
        if (!this.method_37908().method_8608()) {
            this.method_56078(ModSoundEvents.IMPILLAGER_NO);
        }
    }

    private void beginTradeWith(class_1657 customer) {
        this.prepareOffersFor(customer);
        this.method_8259(customer);
        this.method_17449(customer, this.method_5476(), this.method_7231().method_16925());
    }

    private void prepareOffersFor(class_1657 player) {
        int k;
        double d;
        class_1293 statusEffectInstance;
        int i = this.method_20594(player);
        if (i != 0) {
            for (class_1914 tradeOffer : this.method_8264()) {
                tradeOffer.method_8245(-class_3532.method_15375((float)((float)i * tradeOffer.method_19278())));
            }
        }
        if (player.method_6059(ModEffects.SMELLY)) {
            statusEffectInstance = player.method_6112(ModEffects.SMELLY);
            assert (statusEffectInstance != null);
            for (class_1914 tradeOffer : this.method_8264()) {
                d = 0.3625;
                k = (int)Math.floor(d * (double)tradeOffer.method_8246().method_7947());
                tradeOffer.method_8245(-Math.max(k, 2));
            }
        }
        if (player.method_6059(class_1294.field_18980)) {
            statusEffectInstance = player.method_6112(ModEffects.SMELLY);
            assert (statusEffectInstance != null);
            for (class_1914 tradeOffer : this.method_8264()) {
                d = 0.3625;
                k = (int)Math.floor(d * (double)tradeOffer.method_8246().method_7947());
                tradeOffer.method_8245(Math.max(k, 5));
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (bl && source.method_5529() instanceof class_1309) {
            ImpillagerTaskListProvider.onAttacked(this, (class_1309)source.method_5529());
        }
        return bl;
    }

    public boolean method_6121(class_1297 target) {
        if (!(target instanceof class_1309)) {
            return false;
        }
        this.method_37908().method_8421((class_1297)this, (byte)4);
        this.method_56078(this.getMeleeAttackSound());
        return Impillager.tryAttack((class_1309)this, (class_1309)target);
    }

    public void method_20688(class_3218 world, long time, int requiredCount) {
        class_238 box;
        List list;
        List<class_1646> list2;
        if (this.method_20687(time) && (list2 = (list = world.method_18467(class_1646.class, box = this.method_5829().method_1009(10.0, 10.0, 10.0))).stream().filter(villager -> villager.method_20687(time)).limit(5L).toList()).size() >= requiredCount && class_7244.method_42122(ModEntities.DUNG_GOLEM, (class_3730)class_3730.field_16471, (class_3218)world, (class_2338)this.method_24515(), (int)10, (int)8, (int)6, (class_7244.class_7502)class_7244.class_7502.field_39401).isPresent()) {
            list.forEach(class_4307::method_30233);
        }
    }
}

