/*
 * Decompiled with CFR 0.152.
 */
package com.impillagers.mod.effect;

import com.impillagers.mod.sounds.ModSoundEvents;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class ModEffectClient {
    private static double currentZoomProgress;
    private static double targetZoomProgress;
    private static final int NUM_FIREFLY_CHANNELS = 4;
    private static final int NUM_SECONDARY_CHANNELS = 4;
    private static final float FIREFLY_MAX_VOLUME = 1.2f;
    private static final float FROG_MAX_VOLUME = 1.2f;
    private static final float IMP_MAX_VOLUME = 0.6f;
    private static final int[] fireflyCooldowns;
    private static final float[] fireflyVolumeOffsets;
    private static final int[] secondaryCooldowns;
    private static final float[] secondaryVolumeOffsets;
    private static final Random random;
    private static final class_3414[] FIREFLY_SOUNDS;
    private static final class_3414[] FROG_SOUNDS;
    private static final class_3414[] IMPILLAGER_SOUNDS;

    public static void updateZoomState(double progress) {
        targetZoomProgress = Math.max(0.0, Math.min(progress, 1.0));
    }

    public static double getAdjustedFOV(double baseFOV) {
        if (baseFOV < 40.0) {
            return baseFOV;
        }
        double smoothingFactor = 0.1;
        currentZoomProgress = ModEffectClient.lerp(smoothingFactor, currentZoomProgress, targetZoomProgress);
        double exponent = 3.0;
        double effectiveZoomProgress = Math.pow(currentZoomProgress, exponent);
        return baseFOV - effectiveZoomProgress * 30.0;
    }

    private static double lerp(double alpha, double start, double end) {
        return start + alpha * (end - start);
    }

    public static void updateSoundEffects() {
        int i;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (currentZoomProgress > 0.0 && fireflyCooldowns[i] <= 0) {
                double volume = currentZoomProgress * (double)fireflyVolumeOffsets[i] * (double)1.2f;
                ModEffectClient.playSound(client, FIREFLY_SOUNDS[0], (float)volume);
                ModEffectClient.fireflyCooldowns[i] = 40 + random.nextInt(61);
                continue;
            }
            int n = i;
            fireflyCooldowns[n] = fireflyCooldowns[n] - 1;
        }
        for (i = 0; i < 4; ++i) {
            if (currentZoomProgress > 0.0 && secondaryCooldowns[i] <= 0) {
                float channelMaxVolume;
                class_3414 chosenSound;
                double frogChance = (double)0.3f + (1.0 - currentZoomProgress) * (double)0.7f;
                double chance = random.nextDouble();
                if (chance < frogChance) {
                    chosenSound = FROG_SOUNDS[random.nextInt(FROG_SOUNDS.length)];
                    channelMaxVolume = 1.2f;
                } else {
                    chosenSound = IMPILLAGER_SOUNDS[random.nextInt(IMPILLAGER_SOUNDS.length)];
                    channelMaxVolume = 0.6f;
                }
                double volume = currentZoomProgress * (double)secondaryVolumeOffsets[i] * (double)channelMaxVolume;
                ModEffectClient.playSound(client, chosenSound, (float)volume);
                ModEffectClient.secondaryCooldowns[i] = 60 + random.nextInt(121);
                continue;
            }
            int n = i;
            secondaryCooldowns[n] = secondaryCooldowns[n] - 1;
        }
    }

    private static void playSound(class_310 client, class_3414 sound, float volume) {
        client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)volume));
    }

    static {
        int i;
        currentZoomProgress = 0.0;
        targetZoomProgress = 0.0;
        fireflyCooldowns = new int[4];
        fireflyVolumeOffsets = new float[4];
        secondaryCooldowns = new int[4];
        secondaryVolumeOffsets = new float[4];
        random = new Random();
        FIREFLY_SOUNDS = new class_3414[]{ModSoundEvents.FIREFLY_BUSH};
        FROG_SOUNDS = new class_3414[]{class_3417.field_37313, class_3417.field_37315, class_3417.field_37320};
        IMPILLAGER_SOUNDS = new class_3414[]{ModSoundEvents.IMPILLAGER_AMBIENT, ModSoundEvents.IMPILLAGER_ATTACK_RANGED, ModSoundEvents.IMPILLAGER_CELEBRATE};
        for (i = 0; i < 4; ++i) {
            ModEffectClient.fireflyVolumeOffsets[i] = 0.8f + random.nextFloat() * 0.4f;
            ModEffectClient.fireflyCooldowns[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            ModEffectClient.secondaryVolumeOffsets[i] = 0.8f + random.nextFloat() * 0.4f;
            ModEffectClient.secondaryCooldowns[i] = 0;
        }
    }
}

