/*
 * Decompiled with CFR 0.152.
 */
package com.impillagers.mod.command.enchantment;

import com.impillagers.mod.Impillagers;
import com.impillagers.mod.command.ModCommandListener;
import com.impillagers.mod.mixin.ArrowEntityAccessor;
import com.impillagers.mod.mixin.PersistentProjectileEntityAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class DistributionCommand
implements ModCommandListener.IEffectHandler {
    @Override
    public void handleEffect(class_2168 source) {
        class_1297 potentialProjectile = source.method_9228();
        if (potentialProjectile instanceof class_1665) {
            class_1309 living;
            class_1309 owner;
            class_1665 projectileEntity = (class_1665)potentialProjectile;
            Set enchantmentEntries = null;
            class_1844 potionContents = null;
            if (!(projectileEntity instanceof class_1667)) {
                Impillagers.LOGGER.warn("Distribution Enchantment: Distribution was triggered by a non-arrow or non-spear projectile named: {}", (Object)Objects.requireNonNull(source.method_9228()).method_5476());
                return;
            }
            enchantmentEntries = ((PersistentProjectileEntityAccessor)projectileEntity).getWeapon().method_58657().method_57539();
            int distributionLevel = DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Distribution");
            if (distributionLevel == 0) {
                return;
            }
            class_1937 world = projectileEntity.method_37908();
            class_243 impactLocation = this.calculateImpactLocation(projectileEntity, world);
            class_1309 class_13092 = owner = projectileEntity.method_24921() instanceof class_1309 ? (class_1309)projectileEntity.method_24921() : null;
            float radius = distributionLevel == 2 ? 3.0f : (distributionLevel == 3 ? 4.0f : 2.0f);
            class_238 area = this.calculateEffectArea(impactLocation.field_1352, impactLocation.field_1351, impactLocation.field_1350, Float.valueOf(radius));
            for (class_1297 entity : world.method_8390(class_1309.class, area, e -> true)) {
                if (!(entity instanceof class_1309)) continue;
                living = (class_1309)entity;
                living.method_5643(projectileEntity.method_48923().method_48803(projectileEntity, (class_1297)owner), (float)Math.round((float)(1.5 + 1.25 * (double)(DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Power") + 1)) * 2.0f) / 2.0f);
            }
            if (projectileEntity instanceof class_1667) {
                potionContents = ((ArrowEntityAccessor)projectileEntity).GetPotionContents();
            }
            if (potionContents.method_57405()) {
                this.applyLingeringPotion(projectileEntity, potionContents, radius, owner, world);
                for (class_1297 entity : world.method_8390(class_1309.class, area, e -> true)) {
                    if (!(entity instanceof class_1309)) continue;
                    living = (class_1309)entity;
                    for (class_1293 effect : potionContents.method_57397()) {
                        living.method_6092(new class_1293(effect));
                    }
                }
            }
            this.checkCombos(enchantmentEntries, radius, impactLocation, world, area);
            if (projectileEntity instanceof class_1667) {
                projectileEntity.method_5768();
            }
        } else {
            Impillagers.LOGGER.debug("Distribution Enchantment: Distribution was triggered by a non-projectile named: {}", (Object)Objects.requireNonNull(source.method_9228()).method_5476());
        }
    }

    private void checkCombos(Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantmentEntries, float radius, class_243 impactLocation, class_1937 world, class_238 area) {
        int totalKnockbackLevel;
        if (DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Flame") > 0 || DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Fire Aspect") > 0) {
            int intRadius = (int)Math.ceil(radius);
            for (int dx = -intRadius; dx <= intRadius; ++dx) {
                for (int dz = -intRadius; dz <= intRadius; ++dz) {
                    if (!((float)(dx * dx + dz * dz) <= radius * radius)) continue;
                    for (int dy = -1; dy <= 1; ++dy) {
                        class_2338 targetPos = this.calculateBlockPos(impactLocation).method_10069(dx, dy, dz);
                        if (!world.method_8320(targetPos).method_26215() || world.method_8320(targetPos.method_10074()).method_26215() || !(Math.random() < 0.6)) continue;
                        world.method_8652(targetPos, class_2246.field_10036.method_9564(), 3);
                    }
                }
            }
            world.method_8396(null, new class_2338((int)impactLocation.field_1352, (int)impactLocation.field_1351, (int)impactLocation.field_1350), class_3417.field_15013, class_3419.field_15245, 2.0f, 1.4f);
            for (class_1297 entity : world.method_8390(class_1309.class, area, e -> true)) {
                entity.method_5639(5.0f);
            }
        }
        if ((totalKnockbackLevel = DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Knockback") + DistributionCommand.getEnchantmentLevel(enchantmentEntries, "Enchantment Punch")) > 0) {
            for (class_1297 entity : world.method_8390(class_1309.class, area, e -> true)) {
                double dz;
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                double dx = impactLocation.field_1352 - living.method_23317();
                double distance = Math.sqrt(dx * dx + (dz = impactLocation.field_1350 - living.method_23321()) * dz);
                if (distance < 0.001) {
                    distance = 0.001;
                }
                dx /= distance;
                dz /= distance;
                double resistance = 0.0;
                if (living.method_6127().method_45331(class_5134.field_23718)) {
                    resistance = living.method_45325(class_5134.field_23718);
                }
                double knockbackMultiplier = 1.0 - resistance;
                double baseUpwardBoost = 0.3;
                living.method_6005((double)totalKnockbackLevel, dx, dz);
                living.method_5762(0.0, baseUpwardBoost * knockbackMultiplier, 0.0);
            }
            world.method_8396(null, new class_2338((int)impactLocation.field_1352, (int)impactLocation.field_1351, (int)impactLocation.field_1350), (class_3414)class_3417.field_49049.comp_349(), class_3419.field_15245, 2.0f, 1.0f);
        }
    }

    public static int getEnchantmentLevel(Set<Object2IntMap.Entry<class_6880<class_1887>>> enchantmentEntries, String targetId) {
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantmentEntries) {
            if (!((class_1887)((class_6880)entry.getKey()).comp_349()).toString().equals(targetId)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    private void applyLingeringPotion(class_1665 projectileEntity, class_1844 potionContents, float radius, class_1309 owner, class_1937 world) {
        class_243 impactLocation = this.calculateImpactLocation(projectileEntity, world);
        double centerX = impactLocation.field_1352;
        double centerY = impactLocation.field_1351;
        double centerZ = impactLocation.field_1350;
        class_1295 areaEffectCloudEntity = new class_1295(projectileEntity.method_37908(), centerX, centerY, centerZ);
        areaEffectCloudEntity.method_5607(owner);
        areaEffectCloudEntity.method_5603(radius);
        areaEffectCloudEntity.method_5609(-0.5f);
        areaEffectCloudEntity.method_5595(10);
        areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
        areaEffectCloudEntity.method_57280(potionContents);
        projectileEntity.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        world.method_8396(null, new class_2338((int)impactLocation.field_1352, (int)impactLocation.field_1351, (int)impactLocation.field_1350), class_3417.field_14839, class_3419.field_15245, 2.0f, 1.0f);
    }

    private class_243 calculateImpactLocation(class_1665 projectileEntity, class_1937 world) {
        double centerZ;
        double centerY;
        double centerX;
        class_1309 intersectingEntity = world.method_8333((class_1297)projectileEntity, projectileEntity.method_5829(), entity -> entity instanceof class_1309).stream().map(entity -> (class_1309)entity).findFirst().orElse(null);
        if (intersectingEntity != null && intersectingEntity.method_5805()) {
            class_243 entityPos = intersectingEntity.method_19538();
            class_2338 blockPos = intersectingEntity.method_24515();
            if (!world.method_8320(blockPos).method_26215()) {
                centerX = (double)Math.round(((double)blockPos.method_10263() + 0.5) * 2.0) / 2.0;
                centerY = blockPos.method_10264();
                centerZ = (double)Math.round(((double)blockPos.method_10260() + 0.5) * 2.0) / 2.0;
            } else {
                centerX = entityPos.method_10216();
                centerY = entityPos.method_10214();
                centerZ = entityPos.method_10215();
            }
        } else {
            class_2338 arrowPos = projectileEntity.method_24515();
            class_2338 solidBlockPos = null;
            for (int i = 1; i <= 5; ++i) {
                class_2338 candidate = arrowPos.method_10087(i);
                if (world.method_8320(candidate).method_26215()) continue;
                solidBlockPos = candidate;
                break;
            }
            if (solidBlockPos != null) {
                centerX = (double)Math.round(((double)solidBlockPos.method_10263() + 0.5) * 2.0) / 2.0;
                centerY = solidBlockPos.method_10264();
                centerZ = (double)Math.round(((double)solidBlockPos.method_10260() + 0.5) * 2.0) / 2.0;
            } else {
                centerX = (double)Math.round(((double)arrowPos.method_10263() + 0.5) * 2.0) / 2.0;
                centerY = arrowPos.method_10264();
                centerZ = (double)Math.round(((double)arrowPos.method_10260() + 0.5) * 2.0) / 2.0;
            }
        }
        return new class_243(centerX, centerY, centerZ);
    }

    private class_238 calculateEffectArea(Double X, Double Y, Double Z, Float radius) {
        return new class_238(X - (double)radius.floatValue(), Y - (double)radius.floatValue(), Z - (double)radius.floatValue(), X + (double)radius.floatValue(), Y + (double)radius.floatValue(), Z + (double)radius.floatValue());
    }

    private class_2338 calculateBlockPos(class_243 impactLocation) {
        return new class_2338((int)Math.round(impactLocation.field_1352), (int)Math.round(impactLocation.field_1351), (int)Math.round(impactLocation.field_1350));
    }
}

