/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2960;

public final class EnumProvider<T extends Enum<T>>
implements KeyedValueProvider<T> {
    private final Class<T> clazz;
    private final BiMap<class_2960, T> values;

    public EnumProvider(Class<T> enumClazz, String modId) {
        this.clazz = enumClazz;
        this.values = (BiMap)Stream.of((Enum[])enumClazz.getEnumConstants()).collect(ImmutableBiMap.toImmutableBiMap(t -> ResourceLocationHelper.fromNamespaceAndPath(modId, class_156.method_30309((String)t.name(), class_2960::method_29184)), Function.identity()));
    }

    @Override
    public Optional<T> getValue(class_2960 name) {
        return Optional.ofNullable((Enum)this.values.get((Object)name));
    }

    @Override
    public class_2960 getKey(T value) {
        class_2960 resourceLocation = (class_2960)this.values.inverse().get(value);
        Objects.requireNonNull(resourceLocation, "resource location is null");
        return resourceLocation;
    }

    @Override
    public Stream<Map.Entry<class_2960, T>> stream() {
        return this.values.entrySet().stream();
    }

    @Override
    public Stream<T> streamValues() {
        return this.values.values().stream();
    }

    @Override
    public String name() {
        return this.clazz.getSimpleName();
    }
}

