/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.event.v1.data;

import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.impl.event.data.EventDefaultedFloat;
import fuzs.puzzleslib.impl.event.data.ValueDefaultedFloat;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface DefaultedFloat
extends MutableFloat {
    public static DefaultedFloat fromValue(float value) {
        return new ValueDefaultedFloat(value);
    }

    public static DefaultedFloat fromEvent(Consumer<Float> consumer, Supplier<Float> supplier, Supplier<Float> defaultSupplier) {
        return new EventDefaultedFloat(consumer, supplier, defaultSupplier);
    }

    public static DefaultedFloat fromEventWithValue(Consumer<Float> consumer, Supplier<Float> supplier, float defaultValue) {
        return DefaultedFloat.fromEvent(consumer, supplier, () -> Float.valueOf(defaultValue));
    }

    public float getAsDefaultFloat();

    public Optional<Float> getAsOptionalFloat();

    default public void applyDefaultFloat() {
        this.accept(this.getAsDefaultFloat());
    }

    default public void mapDefaultFloat(UnaryOperator<Float> operator) {
        this.applyDefaultFloat();
        this.mapFloat(operator);
    }
}

