/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.struct;

import com.khazoda.basicweapons.item.ClubItem;
import com.khazoda.basicweapons.item.DaggerItem;
import com.khazoda.basicweapons.item.GlaiveItem;
import com.khazoda.basicweapons.item.HammerItem;
import com.khazoda.basicweapons.item.QuarterstaffItem;
import com.khazoda.basicweapons.item.SpearItem;
import com.khazoda.basicweapons.materialpack.EarlyLoadedMaterial;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum WeaponType {
    DAGGER("dagger", 1.0f, -1.6f, 0.0, DaggerItem::new),
    HAMMER("hammer", 7.0f, -3.4f, 0.0, HammerItem::new),
    CLUB("club", 5.0f, -3.0f, 0.0, ClubItem::new),
    SPEAR("spear", 2.0f, -2.8f, 2.0, SpearItem::new),
    QUARTERSTAFF("quarterstaff", 1.0f, -2.3f, 1.25, QuarterstaffItem::new),
    GLAIVE("glaive", 5.0f, -3.2f, 1.25, GlaiveItem::new);

    private final String id;
    private final float baseDamage;
    private final float baseSpeed;
    private final double baseReach;
    private final WeaponFactory factory;

    private WeaponType(String id, float baseDamage, float baseSpeed, double baseReach, WeaponFactory factory) {
        this.id = id;
        this.baseDamage = baseDamage;
        this.baseSpeed = baseSpeed;
        this.baseReach = baseReach;
        this.factory = factory;
    }

    public String getId() {
        return this.id;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public float getBaseSpeed() {
        return this.baseSpeed;
    }

    public double getBaseReach() {
        return this.baseReach;
    }

    public class_1792 create(class_1832 material, float damageModifier, float speedModifier, float reachModifier, class_1792.class_1793 properties) {
        float extraSpeed = speedModifier;
        double extraReach = reachModifier;
        if (material instanceof EarlyLoadedMaterial.TierWithReach) {
            extraSpeed += ((EarlyLoadedMaterial.TierWithReach)material).getAttackSpeedBonus();
            extraReach += (double)((EarlyLoadedMaterial.TierWithReach)material).getReachBonus();
        }
        return this.factory.create(material, this.baseDamage + damageModifier, this.baseSpeed + extraSpeed, this.baseReach + extraReach, properties);
    }

    public static float getDamageModifier(WeaponType type, class_1832 material) {
        if (type == DAGGER && material == class_1834.field_8929) {
            return -1.0f;
        }
        if (type == HAMMER) {
            if (material == class_1834.field_8922) {
                return -6.0f;
            }
            if (material == class_1834.field_8927) {
                return -3.0f;
            }
            if (material == class_1834.field_8929) {
                return -6.0f;
            }
            return -1.0f;
        }
        return 0.0f;
    }

    public static float getSpeedModifier(WeaponType type, class_1832 material) {
        if (type == DAGGER && material == class_1834.field_8929) {
            return 1.0f;
        }
        if (type == HAMMER) {
            if (material == class_1834.field_8922) {
                return 0.4f;
            }
            if (material == class_1834.field_8927) {
                return 0.2f;
            }
            if (material == class_1834.field_8929) {
                return 0.6f;
            }
            if (material == class_1834.field_22033) {
                return 0.2f;
            }
            return 0.1f;
        }
        return 0.0f;
    }

    public static float getReachModifier(WeaponType type, class_1832 material) {
        return 0.0f;
    }

    @FunctionalInterface
    public static interface WeaponFactory {
        public class_1792 create(class_1832 var1, float var2, float var3, double var4, class_1792.class_1793 var6);
    }
}

