/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.registry;

import com.khazoda.basicweapons.BasicWeaponsCommon;
import com.khazoda.basicweapons.material.ConditionalToolMaterials;
import com.khazoda.basicweapons.materialpack.MaterialPackLoader;
import com.khazoda.basicweapons.struct.WeaponType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public class WeaponRegistry {
    private static final Map<String, Supplier<class_1792>> ITEMS = new LinkedHashMap<String, Supplier<class_1792>>();
    private static final Map<WeaponType, List<Supplier<class_1792>>> ITEMS_BY_TYPE = new EnumMap<WeaponType, List<Supplier<class_1792>>>(WeaponType.class);
    private static final Map<class_1832, List<Supplier<class_1792>>> ITEMS_BY_MATERIAL = new HashMap<class_1832, List<Supplier<class_1792>>>();
    public static final List<MaterialEntry> VANILLA_MATERIALS = Arrays.asList(new MaterialEntry((class_1832)class_1834.field_8922, "wooden"), new MaterialEntry((class_1832)class_1834.field_8927, "stone"), new MaterialEntry((class_1832)class_1834.field_8923, "iron"), new MaterialEntry((class_1832)class_1834.field_8929, "golden"), new MaterialEntry((class_1832)class_1834.field_8930, "diamond"), new MaterialEntry((class_1832)class_1834.field_22033, "netherite", class_1792.class_1793::method_24359));
    public static final MaterialEntry BRONZE_MATERIAL_ENTRY = new MaterialEntry(ConditionalToolMaterials.BRONZE, "bronze");

    public static void init() {
        for (MaterialEntry material : VANILLA_MATERIALS) {
            WeaponRegistry.registerAllWeaponsForMaterial(material);
        }
        if (BasicWeaponsCommon.bronze_mod_loaded) {
            WeaponRegistry.registerAllWeaponsForMaterial(BRONZE_MATERIAL_ENTRY);
        }
    }

    public static void registerAllWeaponsForMaterial(MaterialEntry material) {
        for (WeaponType type : WeaponType.values()) {
            String itemId = material.prefix() + "_" + type.getId();
            class_1792.class_1793 itemSettings = material.settingsModifier().apply(new class_1792.class_1793());
            float damageModifier = WeaponType.getDamageModifier(type, material.material());
            float speedModifier = WeaponType.getSpeedModifier(type, material.material());
            float reachModifier = WeaponType.getReachModifier(type, material.material());
            Supplier<class_1792> itemSupplier = BasicWeaponsCommon.ITEM_REGISTRAR.register(itemId, () -> type.create(material.material, damageModifier, speedModifier, reachModifier, itemSettings));
            ITEMS.put(itemId, itemSupplier);
            ITEMS_BY_TYPE.computeIfAbsent(type, k -> new ArrayList()).add(itemSupplier);
            ITEMS_BY_MATERIAL.computeIfAbsent(material.material(), k -> new ArrayList()).add(itemSupplier);
        }
    }

    public static void registerAllWeaponsForMaterial(String materialName) {
        class_1832 material = MaterialPackLoader.getMaterial(materialName);
        WeaponRegistry.registerAllWeaponsForMaterial(new MaterialEntry(material, materialName));
    }

    public static List<class_1792> getItemsByType(WeaponType type) {
        return ITEMS_BY_TYPE.getOrDefault((Object)type, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public static List<class_1792> getItemsByMaterial(class_1832 material) {
        return ITEMS_BY_MATERIAL.getOrDefault(material, Collections.emptyList()).stream().map(Supplier::get).filter(Objects::nonNull).toList();
    }

    public record MaterialEntry(class_1832 material, String prefix, Function<class_1792.class_1793, class_1792.class_1793> settingsModifier) {
        public MaterialEntry(class_1832 material, String prefix) {
            this(material, prefix, settings -> settings);
        }
    }
}

