/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicweapons.materialpack;

import com.khazoda.basicweapons.materialpack.MaterialPackConstants;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public class ResourceAndDatapackCustomLoader
implements class_3285 {
    private final File packsFolder;
    private final boolean isRequired;
    private final class_3264 packType;
    private static final class_5352 MATERIAL = class_5352.method_45281(class_2561::method_27661, (boolean)true);
    private static final Predicate<Path> IS_VALID_RESOURCE_PACK = pack -> Files.isDirectory(pack.resolve(MaterialPackConstants.ASSETS_PATH), new LinkOption[0]) && Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);
    private static final Predicate<Path> IS_VALID_DATA_PACK = pack -> Files.isDirectory(pack.resolve(MaterialPackConstants.DATA_PATH), new LinkOption[0]) && Files.isRegularFile(pack.resolve("pack.mcmeta"), new LinkOption[0]);

    public ResourceAndDatapackCustomLoader(class_3264 packType, boolean isRequired) {
        this.packsFolder = packType == class_3264.field_14188 ? new File(MaterialPackConstants.RESOURCEPACK_TARGET) : new File(MaterialPackConstants.DATAPACK_TARGET);
        this.packType = packType;
        this.isRequired = isRequired;
    }

    private String formatPackName(String folderName) {
        String[] sections = folderName.split("_");
        if (sections.length >= 2) {
            String materialName = sections[1];
            String[] materialWords = materialName.split("-");
            StringBuilder formatted = new StringBuilder();
            for (String word : materialWords) {
                if (word.isEmpty()) continue;
                formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
            }
            return formatted.toString().trim() + (this.packType == class_3264.field_14188 ? " Material Resources" : " Material Data");
        }
        return folderName + (this.packType == class_3264.field_14188 ? " Material Resources" : " Material Data");
    }

    public void method_14453(Consumer<class_3288> packConsumer) {
        if (!this.packsFolder.exists() || !this.packsFolder.isDirectory()) {
            return;
        }
        File[] packs = this.packsFolder.listFiles(file -> (file.isDirectory() || file.getName().endsWith(".zip")) && new File(file, "pack.mcmeta").exists() && (this.packType == class_3264.field_14188 ? IS_VALID_RESOURCE_PACK.test(file.toPath()) : IS_VALID_DATA_PACK.test(file.toPath())));
        if (packs != null) {
            for (File packFile : packs) {
                class_9225 selectionConfig;
                class_3288.class_7680 resources;
                String packId = "basicweapons:" + (packFile.getName().endsWith(".zip") ? packFile.getName().substring(0, packFile.getName().length() - 4) : packFile.getName());
                final Path packPath = packFile.toPath();
                String displayName = this.formatPackName(packFile.getName());
                class_9224 location = new class_9224(packId, (class_2561)class_2561.method_43470((String)displayName), MATERIAL, Optional.empty());
                class_3288 pack = class_3288.method_45275((class_9224)location, (class_3288.class_7680)(resources = new class_3288.class_7680(){

                    public class_3262 method_52424(class_9224 info) {
                        return new class_3259(info, packPath);
                    }

                    public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
                        return new class_3259(info, packPath);
                    }
                }), (class_3264)this.packType, (class_9225)(selectionConfig = new class_9225(this.isRequired, class_3288.class_3289.field_14281, true)));
                if (pack == null) continue;
                packConsumer.accept(pack);
            }
        }
    }
}

