/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.random;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u00020\u000f2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\r0\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lnet/barribob/maelstrom/general/random/WeightedRandom;", "E", "", "Ljava/util/Random;", "random", "<init>", "(Ljava/util/Random;)V", "", "weight", "result", "add", "(DLjava/lang/Object;)Lnet/barribob/maelstrom/general/random/WeightedRandom;", "", "Lkotlin/Pair;", "collection", "", "addAll", "(Ljava/util/Collection;)V", "next", "()Ljava/lang/Object;", "Ljava/util/NavigableMap;", "map", "Ljava/util/NavigableMap;", "Ljava/util/Random;", "total", "D", "BOMD"})
@SourceDebugExtension(value={"SMAP\nWeightedRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedRandom.kt\nnet/barribob/maelstrom/general/random/WeightedRandom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class WeightedRandom<E> {
    @NotNull
    private final Random random;
    @NotNull
    private final NavigableMap<Double, E> map;
    private double total;

    public WeightedRandom(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
        this.map = new TreeMap();
    }

    public /* synthetic */ WeightedRandom(Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            random = new Random();
        }
        this(random);
    }

    @NotNull
    public final WeightedRandom<E> add(double weight, E result) {
        if (weight <= 0.0) {
            return this;
        }
        if (!(!Double.isNaN(weight) && !Double.isInfinite(weight))) {
            boolean bl = false;
            String string = "The weight for random collection is invalid: " + weight;
            throw new IllegalArgumentException(string.toString());
        }
        this.total += weight;
        ((Map)this.map).put(this.total, result);
        return this;
    }

    public final void addAll(@NotNull Collection<? extends Pair<Double, ? extends E>> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        for (Pair<Double, E> pair : collection) {
            this.add(((Number)pair.getFirst()).doubleValue(), pair.getSecond());
        }
    }

    public final E next() {
        double value = this.random.nextDouble() * this.total;
        return this.map.higherEntry(value).getValue();
    }

    public WeightedRandom() {
        this(null, 1, null);
    }
}

