/*
 * Decompiled with CFR 0.152.
 */
package artifacts.util;

import artifacts.component.ability.AttributeModifiers;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.AttackEffects;
import artifacts.component.ability.mobeffect.EquipmentMobEffects;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.component.ability.mobeffect.PostDamageEffects;
import artifacts.component.ability.mobeffect.PostEatingEffects;
import artifacts.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_8110;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class TooltipHelper {
    public static void addAttributeTooltips(Consumer<class_2561> consumer, class_1799 stack, class_1792.class_9635 context) {
        class_9285 itemAttributeModifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        boolean hasSlotTooltip = false;
        if (itemAttributeModifiers.comp_2394()) {
            for (class_1304 slot : class_1304.values()) {
                MutableBoolean b = new MutableBoolean(false);
                stack.method_57354(slot, (holder, attributeModifier) -> b.setTrue());
                if (!b.booleanValue()) continue;
                hasSlotTooltip = true;
                TooltipHelper.addAbilityAttributeTooltips(stack, context, consumer);
            }
        }
        if (!hasSlotTooltip) {
            if (TooltipHelper.getAbility(ModDataComponents.ATTRIBUTE_MODIFIERS.get(), stack).isPresent() || TooltipHelper.getAbility(ModDataComponents.MOB_EFFECTS.get(), stack).isPresent()) {
                consumer.accept(class_5244.field_39003);
                consumer.accept((class_2561)class_2561.method_43471((String)"item.modifiers.body").method_27692(class_124.field_1080));
            }
            TooltipHelper.addAbilityAttributeTooltips(stack, context, consumer);
        }
        TooltipHelper.addWhenHurtTooltips(consumer, context, stack);
        TooltipHelper.addPerFoodPointEatenTooltip(consumer, context, stack);
        TooltipHelper.addAttacksInflictTooltip(consumer, context, stack);
    }

    @Unique
    private static void addAbilityAttributeTooltips(class_1799 stack, class_1792.class_9635 context, Consumer<class_2561> tooltip) {
        TooltipHelper.getAbility(ModDataComponents.ATTRIBUTE_MODIFIERS.get(), stack).ifPresent(ability -> {
            for (AttributeModifiers.Entry entry : ability.entries()) {
                TooltipHelper.addAbilityAttributeTooltip(tooltip, entry);
            }
        });
        TooltipHelper.getAbility(ModDataComponents.MOB_EFFECTS.get(), stack).ifPresent(ability -> {
            for (EquipmentMobEffects.Entry entry : ability.entries()) {
                MobEffectProvider provider = entry.provider();
                TooltipHelper.addMobEffectTooltip(tooltip, context, (class_1291)provider.mobEffect().comp_349(), (Integer)provider.duration().get(), (Integer)provider.level().get(), 1.0, provider.condition() == EntityCondition.ALWAYS);
            }
        });
    }

    @Unique
    private static void addAbilityAttributeTooltip(Consumer<class_2561> tooltip, AttributeModifiers.Entry entry) {
        double amount = (Double)entry.amount().get();
        if (entry.operation() != class_1322.class_1323.field_6328) {
            amount *= 100.0;
        } else if (entry.attribute().equals((Object)class_5134.field_23718)) {
            amount *= 10.0;
        }
        if (amount > 0.0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entry.operation().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(amount), class_2561.method_43471((String)((class_1320)entry.attribute().comp_349()).method_26830())}).method_27692(((class_1320)entry.attribute().comp_349()).method_60494(true)));
        } else if (amount < 0.0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + entry.operation().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(amount *= -1.0), class_2561.method_43471((String)((class_1320)entry.attribute().comp_349()).method_26830())}).method_27692(((class_1320)entry.attribute().comp_349()).method_60494(false)));
        }
    }

    @Unique
    private static void addWhenHurtTooltips(Consumer<class_2561> tooltip, class_1792.class_9635 context, class_1799 stack) {
        MutableBoolean flag = new MutableBoolean(false);
        ArrayList list = new ArrayList();
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_EFFECTS.get(), stack).ifPresent(ability -> {
            for (PostDamageEffects.Entry entry : ability.entries()) {
                if (entry.tag().isEmpty()) {
                    flag.setTrue();
                    continue;
                }
                list.add(entry.tag().get());
            }
        });
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), stack).ifPresent(ability -> {
            if (ability.tag().isEmpty()) {
                flag.setTrue();
            } else if (!list.contains(ability.tag().get())) {
                list.add(ability.tag().get());
            }
        });
        if (flag.booleanValue()) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.when_hurt").method_27692(class_124.field_1080));
            TooltipHelper.addWhenHurtTooltip(tooltip, context, stack, null);
        }
        for (class_6862 tag : list) {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.when_hurt.%s".formatted(tag.comp_327().toString().replace("minecraft:", "").replace(':', '.'))).method_27692(class_124.field_1080));
            TooltipHelper.addWhenHurtTooltip(tooltip, context, stack, (class_6862<class_8110>)tag);
        }
    }

    private static void addWhenHurtTooltip(Consumer<class_2561> tooltip, class_1792.class_9635 context, class_1799 stack, @Nullable class_6862<class_8110> tag) {
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_EFFECTS.get(), stack).ifPresent(ability -> {
            for (PostDamageEffects.Entry entry : ability.entries()) {
                if ((!entry.tag().isEmpty() || tag != null) && (!entry.tag().isPresent() || !entry.tag().get().equals((Object)tag))) continue;
                TooltipHelper.addMobEffectTooltip(tooltip, context, (class_1291)entry.provider().mobEffect().comp_349(), (Integer)entry.provider().duration().get(), (Integer)entry.provider().level().get(), (Double)entry.chance().get(), false);
            }
        });
        TooltipHelper.getAbility(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), stack).ifPresent(ability -> {
            if (ability.tag().isEmpty() && tag == null || ability.tag().isPresent() && ability.tag().get().equals((Object)tag)) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{TooltipHelper.formatDurationSeconds(context, (Integer)ability.cooldown().get())}).method_27692(class_124.field_1065));
            }
        });
    }

    private static void addPerFoodPointEatenTooltip(Consumer<class_2561> tooltip, class_1792.class_9635 context, class_1799 stack) {
        TooltipHelper.getAbility(ModDataComponents.POST_EATING_EFFECTS.get(), stack).ifPresent(ability -> {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.per_food_point_restored").method_27692(class_124.field_1080));
            for (PostEatingEffects.Entry entry : ability.entries()) {
                MobEffectProvider provider = entry.provider();
                TooltipHelper.addMobEffectTooltip(tooltip, context, (class_1291)provider.mobEffect().comp_349(), (Integer)provider.duration().get(), (Integer)provider.level().get(), 1.0, false);
            }
        });
    }

    private static void addAttacksInflictTooltip(Consumer<class_2561> tooltip, class_1792.class_9635 context, class_1799 stack) {
        TooltipHelper.getAbility(ModDataComponents.ATTACK_EFFECTS.get(), stack).ifPresent(ability -> {
            tooltip.accept(class_5244.field_39003);
            tooltip.accept((class_2561)class_2561.method_43471((String)"artifacts.tooltip.attacks_inflict").method_27692(class_124.field_1080));
            for (AttackEffects.Entry entry : ability.entries()) {
                TooltipHelper.addMobEffectTooltip(tooltip, context, (class_1291)entry.provider().mobEffect().comp_349(), (Integer)entry.provider().duration().get(), (Integer)entry.provider().level().get(), (Double)entry.chance().get(), false);
                if ((Integer)entry.cooldown().get() <= 0) continue;
                tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.cooldown", (Object[])new Object[]{TooltipHelper.formatDurationSeconds(context, (Integer)entry.cooldown().get())}).method_27692(class_124.field_1065));
            }
        });
    }

    private static void addMobEffectTooltip(Consumer<class_2561> tooltip, class_1792.class_9635 context, class_1291 mobEffect, int duration, int level, double chance, boolean isInfinite) {
        class_5250 mutableComponent = class_2561.method_43471((String)mobEffect.method_5567());
        if (level > 1) {
            mutableComponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, class_2561.method_43471((String)("potion.potency." + (level - 1)))});
        }
        if (!isInfinite) {
            mutableComponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, TooltipHelper.formatDurationSeconds(context, duration)});
        }
        if (class_3532.method_20390((double)chance, (double)1.0)) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.plus_mob_effect", (Object[])new Object[]{mutableComponent}).method_27692(mobEffect.method_18792().method_18793()));
        } else {
            tooltip.accept((class_2561)class_2561.method_43469((String)"artifacts.tooltip.plus_mob_effect_chance", (Object[])new Object[]{mutableComponent, Math.round(chance * 100.0)}).method_27692(mobEffect.method_18792().method_18793()));
        }
    }

    private static class_5250 formatDurationSeconds(class_1792.class_9635 context, int seconds) {
        return class_2561.method_43470((String)class_3544.method_15439((int)(seconds * 20), (float)context.method_59531()));
    }

    public static <A extends EquipmentAbility> Optional<A> getAbility(class_9331<A> type, class_1799 stack) {
        EquipmentAbility ability;
        Object object = stack.method_57824(type);
        if (object instanceof EquipmentAbility && (ability = (EquipmentAbility)object).isNonCosmetic()) {
            return Optional.of(ability);
        }
        return Optional.empty();
    }

    public static boolean isCosmetic(class_1799 stack) {
        for (class_9336 component : stack.method_57353()) {
            EquipmentAbility ability;
            Object object = component.comp_2444();
            if (!(object instanceof EquipmentAbility) || !(ability = (EquipmentAbility)object).isNonCosmetic()) continue;
            return false;
        }
        return true;
    }
}

