/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EntityCondition;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.component.ability.TickingCompositeAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModMobEffects;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record EquipmentMobEffects(List<Entry> entries) implements TickingCompositeAbility<Entry>
{
    private static final Set<class_6880<class_1291>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(class_1294.field_5905, ModMobEffects.MAGNETISM);
    public static final Codec<EquipmentMobEffects> CODEC = CompositeAbility.codec(Entry.CODEC, EquipmentMobEffects::new, EquipmentMobEffects::entries);
    public static final class_9139<class_9129, EquipmentMobEffects> STREAM_CODEC = CompositeAbility.streamCodec(Entry.STREAM_CODEC, EquipmentMobEffects::new, EquipmentMobEffects::entries);

    public record Entry(MobEffectProvider provider) implements TickingAbility
    {
        public static final Codec<Entry> CODEC = MobEffectProvider.codec(false).xmap(Entry::new, Entry::provider);
        public static final class_9139<class_9129, Entry> STREAM_CODEC = MobEffectProvider.STREAM_CODEC.method_56432(Entry::new, Entry::provider);

        @Override
        public void onUnequip(class_1309 entity) {
            class_1293 instance = entity.method_6112(this.provider.mobEffect());
            if (instance != null && instance.method_5578() == this.provider.getAmplifier() && instance.method_5581() == ((Boolean)this.provider.spawnParticles().get()).booleanValue() && instance.method_5592() == ((Boolean)this.provider.showIcon().get()).booleanValue() && instance.method_48557(this.provider.getDuration(1) * 20 + 19)) {
                entity.method_6016(this.provider.mobEffect());
            }
        }

        @Override
        public void wornTick(class_1309 entity, boolean isOnCooldown, boolean isDisabled) {
            if (!isDisabled && !isOnCooldown && this.provider.canApply(entity)) {
                entity.method_6092(this.provider.createEffect());
            }
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider().isNonCosmetic();
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            if (CUSTOM_TOOLTIP_MOB_EFFECTS.contains(this.provider.mobEffect())) {
                class_2960 id = class_7923.field_41174.method_10221((Object)((class_1291)this.provider.mobEffect().comp_349()));
                writer.add(Objects.requireNonNull(id).method_12832(), new Object[0]);
            }
            if (this.provider.mobEffect().comp_349() == class_1294.field_5925.comp_349()) {
                Value nightVisionStrength = (Value)writer.stack().method_57824(ModDataComponents.REDUCED_NIGHT_VISION.get());
                if (nightVisionStrength != null && (Double)nightVisionStrength.get() < 0.5) {
                    writer.add("night_vision.partial", new Object[0]);
                } else {
                    writer.add("night_vision.full", new Object[0]);
                }
            }
            if (this.provider.mobEffect().comp_349() == class_1294.field_5923.comp_349()) {
                if (this.provider.condition() == EntityCondition.ALWAYS) {
                    writer.add("water_breathing.infinite", new Object[0]);
                } else {
                    writer.add("water_breathing.limited", new Object[0]);
                }
            }
        }
    }
}

