/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.Artifacts;
import artifacts.component.SwimData;
import artifacts.component.ability.SwimInAir;
import artifacts.equipment.EquipmentHelper;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModDataComponents;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class HeliumFlamingoOverlay {
    private static final class_2960 HELIUM_FLAMINGO_ICON = Artifacts.id("textures/gui/icons.png");

    public static boolean renderOverlay(int height, class_332 guiGraphics, int screenWidth, int screenHeight) {
        class_1309 player;
        block7: {
            block6: {
                class_1297 class_12972 = class_310.method_1551().method_1560();
                if (!(class_12972 instanceof class_1309)) break block6;
                player = (class_1309)class_12972;
                if (EquipmentHelper.hasAbilityActive(ModDataComponents.SWIM_IN_AIR.get(), player, false)) break block7;
            }
            return false;
        }
        SwimData swimData = PlatformServices.platformHelper.getSwimData(player);
        if (swimData == null) {
            return false;
        }
        double progress = 1.0 - swimData.getSwimProgress();
        RenderSystem.enableBlend();
        int left = screenWidth / 2 + 91;
        int top = screenHeight - height;
        if (progress == 1.0) {
            return false;
        }
        int duration = swimData.isSwimming() ? SwimInAir.getFlightDuration(player) : SwimInAir.getRechargeDuration(player);
        int full = class_3532.method_15384((double)((progress - 2.0 / (double)duration) * 10.0));
        int partial = class_3532.method_15384((double)(progress * 10.0)) - full;
        for (int i = 0; i < full + partial; ++i) {
            guiGraphics.method_25291(HELIUM_FLAMINGO_ICON, left - i * 8 - 9, top, -90, (float)(i < full ? 0 : 9), 0.0f, 9, 9, 32, 16);
        }
        RenderSystem.disableBlend();
        return true;
    }
}

