/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class EnderscapeStructureMusic {
    private static final Map<class_3222, Integer> playerTimers = new HashMap<class_3222, Integer>();
    private static final Map<class_3222, class_2960> playerStructures = new HashMap<class_3222, class_2960>();
    private static int structureChangeTimer = 0;

    private static void tryStructureChange(class_3222 player, class_2960 structure) {
        class_2960 currentStructure = playerStructures.get(player);
        if (currentStructure == null || !currentStructure.equals((Object)structure)) {
            playerStructures.put(player, structure);
            playerTimers.put(player, 1200);
        }
    }

    private static class_2960 getStructure(class_3218 level, class_3222 player) {
        class_7225.class_7226 registry = level.method_30349().method_46762(class_7924.field_41246);
        List structures = registry.method_42017().toList();
        for (class_6880.class_6883 structure : structures) {
            if (structure == null || !level.method_27056().method_28388(class_2338.method_49638((class_2374)player.method_19538()), (class_3195)structure.comp_349()).method_16657()) continue;
            return structure.method_40237().method_29177();
        }
        return class_2960.method_60656((String)"none");
    }

    static {
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            if (!level.method_8608()) {
                playerStructures.clear();
                playerTimers.clear();
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            playerStructures.remove(player);
            playerTimers.remove(player);
        });
        ServerTickEvents.START_WORLD_TICK.register(level -> {
            if (!playerTimers.isEmpty()) {
                Iterator<Map.Entry<class_3222, Integer>> iterator = playerTimers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<class_3222, Integer> entry = iterator.next();
                    int newTimer = entry.getValue() - 1;
                    if (newTimer <= 0) {
                        class_3222 player = entry.getKey();
                        if (playerStructures.containsKey(player)) {
                            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundStructureChangedPayload(playerStructures.get(player)));
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.setValue(newTimer);
                }
            }
            if (structureChangeTimer-- <= 0) {
                for (class_3222 player : level.method_18766(class_1309::method_5805)) {
                    EnderscapeStructureMusic.tryStructureChange(player, EnderscapeStructureMusic.getStructure(level, player));
                }
                structureChangeTimer = 240;
            }
        });
    }
}

