/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.registry.EnderscapeTrimMaterials;
import net.bunten.enderscape.registry.EnderscapeTrimPatterns;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public final class EnderscapeAssetModifications {
    private static final List<String> ARMOR_PIECE_TYPES = List.of("helmet", "chestplate", "leggings", "boots");
    private static final List<class_2960> ARMOR_MATERIALS = List.of(class_2960.method_60656((String)"leather"), class_2960.method_60656((String)"chainmail"), class_2960.method_60656((String)"iron"), class_2960.method_60656((String)"golden"), class_2960.method_60656((String)"diamond"), class_2960.method_60656((String)"netherite"));

    private static void registerItemModelModification(String armorPieceType, class_2960 armorMaterial) {
        Mixson.registerEvent((int)1, (String)class_2960.method_60655((String)armorMaterial.method_12836(), (String)("models/item/" + armorMaterial.method_12832() + "_" + armorPieceType)).toString(), (String)Enderscape.id("add_trims_to_" + armorMaterial.method_12832() + "_" + armorPieceType).toString(), context -> {
            JsonObject rootJson = ((JsonElement)context.getFile()).getAsJsonObject();
            JsonArray overridesArray = rootJson.getAsJsonArray("overrides");
            EnderscapeTrimMaterials.TRIM_MATERIALS.forEach((trimMaterial, value) -> {
                JsonObject newCase = new JsonObject();
                JsonObject predicate = new JsonObject();
                predicate.addProperty("trim_type", (Number)value);
                newCase.add("predicate", (JsonElement)predicate);
                newCase.addProperty("model", Enderscape.id("item/" + armorMaterial.method_12832() + "_" + armorPieceType + "_" + trimMaterial.method_29177().method_12832() + "_trim").toString());
                overridesArray.add((JsonElement)newCase);
            });
            ArrayList<JsonElement> overrideList = new ArrayList<JsonElement>();
            for (JsonElement override : overridesArray) {
                overrideList.add(override);
            }
            overrideList.sort((a, b) -> {
                JsonElement typeA = a.getAsJsonObject().getAsJsonObject("predicate").get("trim_type");
                JsonElement typeB = b.getAsJsonObject().getAsJsonObject("predicate").get("trim_type");
                if (typeA == null || !typeA.isJsonPrimitive() || typeB == null || !typeB.isJsonPrimitive()) {
                    return 0;
                }
                return Float.compare(typeA.getAsFloat(), typeB.getAsFloat());
            });
            JsonArray sortedOverrides = new JsonArray();
            overrideList.forEach(arg_0 -> ((JsonArray)sortedOverrides).add(arg_0));
            rootJson.add("overrides", (JsonElement)sortedOverrides);
        }, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerTrimPatternTextures() {
        Mixson.registerEvent((int)1, (String)class_2960.method_60656((String)"atlases/armor_trims").toString(), (String)Enderscape.id("add_trim_patterns_to_armor_trims_atlas").toString(), context -> {
            JsonObject rootJson = ((JsonElement)context.getFile()).getAsJsonObject();
            JsonArray sourcesArray = rootJson.getAsJsonArray("sources");
            for (JsonElement sourceElement : sourcesArray) {
                JsonObject sourceObject = sourceElement.getAsJsonObject();
                String type = sourceObject.get("type").getAsString();
                if (!"paletted_permutations".equals(type) && !"minecraft:paletted_permutations".equals(type)) continue;
                JsonArray texturesArray = sourceObject.getAsJsonArray("textures");
                EnderscapeTrimPatterns.TRIM_PATTERNS.forEach(pattern -> {
                    String name = pattern.method_29177().method_12832();
                    texturesArray.add(Enderscape.id("trims/models/armor/" + name).toString());
                    texturesArray.add(Enderscape.id("trims/models/armor/" + name + "_leggings").toString());
                });
                break;
            }
        }, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerTrimMaterialsToAtlas(String atlasName) {
        Mixson.registerEvent((int)1, (String)class_2960.method_60656((String)("atlases/" + atlasName)).toString(), (String)Enderscape.id("add_trim_materials_to_" + atlasName + "_atlas").toString(), context -> {
            JsonObject rootJson = ((JsonElement)context.getFile()).getAsJsonObject();
            JsonArray sourcesArray = rootJson.getAsJsonArray("sources");
            for (JsonElement sourceElement : sourcesArray) {
                JsonObject sourceObject = sourceElement.getAsJsonObject();
                String type = sourceObject.get("type").getAsString();
                if (!"paletted_permutations".equals(type) && !"minecraft:paletted_permutations".equals(type)) continue;
                JsonObject permutationsJson = sourceObject.getAsJsonObject("permutations");
                EnderscapeTrimMaterials.TRIM_MATERIALS.forEach((material, value) -> {
                    String trimName = material.method_29177().method_12832();
                    permutationsJson.addProperty(trimName, Enderscape.id("trims/color_palettes/" + trimName).toString());
                });
                break;
            }
        }, (ResourceReference[])new ResourceReference[0]);
    }

    static {
        ARMOR_PIECE_TYPES.forEach(armorType -> ARMOR_MATERIALS.forEach(material -> EnderscapeAssetModifications.registerItemModelModification(armorType, material)));
        EnderscapeAssetModifications.registerItemModelModification("helmet", class_2960.method_60656((String)"turtle"));
        EnderscapeAssetModifications.registerItemModelModification("leggings", Enderscape.id("drift"));
        EnderscapeAssetModifications.registerTrimMaterialsToAtlas("armor_trims");
        EnderscapeAssetModifications.registerTrimMaterialsToAtlas("blocks");
        EnderscapeAssetModifications.registerTrimPatternTextures();
    }
}

