/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.List;
import java.util.function.Predicate;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorItem;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public record MirrorUseChecks(@Nullable class_2561 failureComponent, Predicate<MirrorContext> shouldProceed) {
    public static final MirrorUseChecks IS_RUNNING_ON_SERVER = new MirrorUseChecks(null, context -> !context.level().method_8608());
    public static final MirrorUseChecks IS_LINKED_TO_LODESTONE = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.unlinked"), context -> MirrorItem.isLinked(context.stack()));
    public static final MirrorUseChecks CAN_TRAVEL_TO_LODESTONE = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.wrong_dimension"), MirrorUseChecks::canTravelTo);
    public static final MirrorUseChecks IS_SAME_COORDINATE_SCALE = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.wrong_coordinate_scale"), MirrorItem::isSameCoordinateScale);
    public static final MirrorUseChecks ISNT_TOO_FAR_FROM_LODESTONE = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.too_far"), context -> !MirrorUseChecks.isTooFar(context));
    public static final MirrorUseChecks FUEL_EXCEEDS_COST = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.need_fuel"), NebuliteToolItem::fuelExceedsCost);
    public static final MirrorUseChecks USER_IS_NOT_TOO_BIG = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.unsafe"), context -> !MirrorUseChecks.isTooBig(context));
    public static final MirrorUseChecks TELEPORT_POSITION_IS_SAFE = new MirrorUseChecks((class_2561)class_2561.method_43471((String)"item.enderscape.mirror.message.unsafe"), context -> MirrorItem.getTeleportPosition(context).isPresent());
    public static final List<MirrorUseChecks> CHECKS_IN_ORDER = List.of(IS_RUNNING_ON_SERVER, IS_LINKED_TO_LODESTONE, CAN_TRAVEL_TO_LODESTONE, IS_SAME_COORDINATE_SCALE, ISNT_TOO_FAR_FROM_LODESTONE, FUEL_EXCEEDS_COST, USER_IS_NOT_TOO_BIG, TELEPORT_POSITION_IS_SAFE);

    public boolean fails(MirrorContext context) {
        return !this.shouldProceed.test(context);
    }

    public class_1269 getFailureResult(MirrorContext context) {
        return this.failureComponent != null ? MirrorUseChecks.failureResult(context, (class_2561)class_2561.method_43471((String)this.failureComponent.getString()).method_27692(class_124.field_1061)) : class_1269.field_21466;
    }

    private static class_1269 failureResult(MirrorContext context, class_2561 failureComponent) {
        class_1309 user = context.user();
        class_1799 stack = context.stack();
        user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), EnderscapeItemSounds.MIRROR_FAILURE, user.method_5634(), 0.65f, class_3532.method_15344((class_5819)user.method_59922(), (float)0.9f, (float)1.1f));
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            player.method_7353(failureComponent, true);
            player.method_7357().method_7906(stack.method_7909(), 20);
        }
        user.method_32876((class_6880)class_5712.field_28146);
        return class_1269.field_5812;
    }

    private static boolean canTravelTo(MirrorContext context) {
        return MirrorItem.hasTransdimensional(context) || MirrorItem.isSameDimension(context, context.linkedDimension());
    }

    private static boolean isTooFar(MirrorContext context) {
        return context.item().fuelCost(context) > MirrorItem.maxFuel(context.stack());
    }

    private static boolean isTooBig(MirrorContext context) {
        class_1309 user = context.user();
        class_4048 dimensions = user.method_18377(user.method_18376());
        float limit = 4.0f;
        return dimensions.comp_2185() > limit || dimensions.comp_2186() > limit;
    }
}

