/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorUseChecks;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantmentEffectComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MirrorItem
extends NebuliteToolItem {
    public MirrorItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean bl) {
        MirrorItem.updateLodestoneTracker(stack, level);
    }

    public static void updateLodestoneTracker(class_1799 stack, class_1937 level) {
        if (level instanceof class_3218) {
            class_9291 ticked;
            class_3218 server = (class_3218)level;
            class_9291 tracker = (class_9291)stack.method_57824(class_9334.field_49614);
            if (tracker != null && (ticked = tracker.method_58115(server)) != tracker) {
                stack.method_57379(class_9334.field_49614, (Object)ticked);
            }
        }
    }

    @Override
    public int fuelCost(NebuliteToolContext context) {
        class_1799 stack = context.stack();
        class_1309 user = context.user();
        MirrorContext mirror = MirrorContext.of(context);
        if (mirror.dimension() != mirror.linkedDimension()) {
            return MirrorItem.maxFuel(stack);
        }
        return 1 + this.distanceBetweenPoints(user.method_24515(), mirror.linkedPos()) / this.getTotalDistanceForCostIncrease(context);
    }

    @Override
    public boolean displayHudWhen(NebuliteToolContext context) {
        return true;
    }

    @Override
    public boolean hideInvalidOutlineWhen(NebuliteToolContext context) {
        MirrorContext mirrorContext = MirrorContext.of(context);
        boolean isLinked = MirrorItem.isLinked(context.stack());
        boolean exceedsCost = MirrorItem.fuelExceedsCost(context);
        boolean sameDimension = MirrorItem.isSameDimension(mirrorContext, mirrorContext.linkedDimension());
        boolean hasTransdimensional = MirrorItem.hasTransdimensional(mirrorContext);
        return isLinked && exceedsCost && (sameDimension || hasTransdimensional && MirrorItem.isSameCoordinateScale(mirrorContext));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        MirrorContext context = new MirrorContext(stack, world, (class_1309)player);
        for (MirrorUseChecks check : MirrorUseChecks.CHECKS_IN_ORDER) {
            if (!check.fails(context)) continue;
            return new class_1271(check.getFailureResult(context), (Object)stack);
        }
        return MirrorItem.teleport(context, false) ? class_1271.method_22427((Object)stack) : new class_1271(MirrorUseChecks.TELEPORT_POSITION_IS_SAFE.getFailureResult(context), (Object)stack);
    }

    public static boolean teleport(MirrorContext context, boolean fromDispenser) {
        block2: {
            class_243 position;
            boolean sameDimension;
            class_4208 destination;
            class_4208 prior;
            class_1309 user;
            block4: {
                block3: {
                    user = context.user();
                    prior = new class_4208(context.dimension(), user.method_23312());
                    destination = new class_4208(context.linkedDimension(), context.linkedPos());
                    Optional<class_243> optional = MirrorItem.getTeleportPosition(context);
                    sameDimension = MirrorItem.isSameDimension(context, (class_5321<class_1937>)destination.comp_2207());
                    if (!optional.isPresent()) break block2;
                    position = optional.get();
                    class_1309 class_13092 = context.user();
                    if (!(class_13092 instanceof class_1657)) break block3;
                    class_1657 player = (class_1657)class_13092;
                    if (player.method_31549().field_7477 && !fromDispenser) break block4;
                }
                MirrorItem.useFuel(context);
            }
            MirrorItem.doPreTeleportEffects(user, !sameDimension, context, prior.comp_2208().method_46558());
            MirrorItem.teleportToLocation(context, class_2338.method_49638((class_2374)position), !sameDimension);
            MirrorItem.awardMirrorStatistics(context, prior, destination, fromDispenser);
            return true;
        }
        return false;
    }

    public static Optional<class_243> getTeleportPosition(MirrorContext context) {
        class_243 offsetPos;
        class_265 shape;
        class_1309 user;
        class_3218 level = context.linkedLevel();
        Optional freePos = level.method_33594((class_1297)(user = context.user()), shape = class_259.method_1078((class_238)class_238.method_30048((class_243)(offsetPos = context.linkedPos().method_10084().method_61082().method_1031(0.0, (double)user.method_17682() / 2.0, 0.0)), (double)(user.method_17681() + 1.0f), (double)(user.method_17682() + 1.0f), (double)(user.method_17681() + 1.0f)).method_1014(1.0E-6)), offsetPos, (double)user.method_17681(), (double)user.method_17682(), (double)user.method_17681());
        if (freePos.isPresent()) {
            class_243 pos = (class_243)freePos.get();
            class_2338.class_2339 mutable = class_2338.method_49638((class_2374)pos).method_25503();
            for (int i = 0; i < 8; ++i) {
                if (level.method_8320(mutable.method_10074()).method_26206((class_1922)level, (class_2338)mutable, class_2350.field_11036)) {
                    return Optional.of(class_243.method_24954((class_2382)mutable));
                }
                mutable.method_10098(class_2350.field_11033);
            }
        }
        return Optional.empty();
    }

    private static void doPreTeleportEffects(class_1309 user, boolean sameDimension, MirrorContext context, class_243 priorVec3) {
        user.method_5848();
        user.field_6017 = 0.0f;
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (user.method_6128()) {
                player.method_23670();
            }
            EnderscapeServerNetworking.sendMirrorInfoPayload(player, sameDimension);
        }
        context.serverLevel().method_14199((class_2394)EnderscapeParticles.MIRROR_TELEPORT_OUT, priorVec3.field_1352, priorVec3.field_1351 + 0.5, priorVec3.field_1350, 50, 0.5, 1.0, 0.5, 0.1);
    }

    private static void teleportToLocation(MirrorContext context, class_2338 destination, boolean transdimensional) {
        class_3218 level = context.linkedLevel();
        class_243 pos = destination.method_61082();
        class_1309 user = context.user();
        user.method_48105(level, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), 0.0f, 0.0f);
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            if (transdimensional) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundTransdimensionalTravelSoundPayload());
            }
        }
        level.method_14199((class_2394)EnderscapeParticles.MIRROR_TELEPORT_IN, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 50, 0.5, 1.0, 0.5, 0.1);
        level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, EnderscapeItemSounds.MIRROR_TELEPORT, user.method_5634(), 0.65f, 1.0f);
        level.method_32888((class_6880)class_5712.field_39446, user.method_19538(), class_5712.class_7397.method_43285((class_1297)user));
    }

    private static void awardMirrorStatistics(MirrorContext context, class_4208 prior, class_4208 destination, boolean fromDispenser) {
        class_1309 class_13092 = context.user();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            if (!player.method_31549().field_7477 || fromDispenser) {
                player.method_7357().method_7906(context.stack().method_7909(), 100);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)context.stack().method_7909()));
            player.method_7281(EnderscapeStats.MIRROR_TELEPORT);
            double distance = Math.sqrt(Math.pow(destination.comp_2208().method_10263() - prior.comp_2208().method_10263(), 2.0) + Math.pow(destination.comp_2208().method_10260() - prior.comp_2208().method_10260(), 2.0));
            int centimeterDistance = Math.round((float)distance * 100.0f);
            if (centimeterDistance > 0) {
                player.method_7339(EnderscapeStats.MIRROR_ONE_CM, centimeterDistance);
            }
            EnderscapeCriteria.MIRROR_TELEPORT.trigger(player, context.stack(), prior, destination);
        }
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        class_1799 stack = context.method_8041();
        if (state.method_27852(class_2246.field_23261)) {
            MirrorItem.writeData(stack, pos, (class_5321<class_1937>)context.method_8045().method_27983());
            world.method_8396(null, pos, EnderscapeItemSounds.MIRROR_LINK, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public boolean method_7886(class_1799 stack) {
        return MirrorItem.wasLinkedBefore(stack) || super.method_7886(stack);
    }

    public class_2561 method_7864(class_1799 stack) {
        return MirrorItem.isLinked(stack) ? class_2561.method_43471((String)(this.method_7876() + ".linked")) : super.method_7864(stack);
    }

    private class_5250 tooltip(String name, Object ... objects) {
        return class_2561.method_43469((String)("item.enderscape.mirror.desc." + name), (Object[])objects);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> list, class_1836 flag) {
        class_310 client = class_310.method_1551();
        EnderscapeConfig config = EnderscapeConfig.getInstance();
        MirrorContext context = new MirrorContext(stack, (class_1937)client.field_1687, (class_1309)client.field_1724);
        if (MirrorItem.isLinked(stack) && config.mirrorTooltipEnabled) {
            class_124 typeColor = class_124.field_1080;
            class_124 valueColor = class_124.field_1078;
            if (!config.mirrorTooltipShiftToDisplay || class_437.method_25442()) {
                class_2338 user = context.user().method_24515();
                class_2338 linkedPos = context.linkedPos();
                class_5321<class_1937> linkedDimension = context.linkedDimension();
                if (config.mirrorTooltipDisplayCoordinates) {
                    class_5250 position = this.tooltip("position.coordinates", linkedPos.method_10263(), linkedPos.method_10264(), linkedPos.method_10260()).method_27692(valueColor);
                    class_5250 unknown = this.tooltip("position.unknown", new Object[0]).method_27692(valueColor);
                    list.add((class_2561)this.tooltip("position", MirrorItem.isSameDimension(context, linkedDimension) ? position : unknown).method_27692(typeColor));
                }
                if (config.mirrorTooltipDisplayDistance) {
                    float step = (float)this.getDistanceForCostIncrease(stack) / 2.0f;
                    int roundedDistance = (int)((float)Math.round((float)this.distanceBetweenPoints(user, linkedPos) / step) * step);
                    class_5250 approximate = this.tooltip("distance.approximate_value", roundedDistance).method_27692(valueColor);
                    class_5250 unknown = this.tooltip("distance.unknown", new Object[0]).method_27692(valueColor);
                    list.add((class_2561)this.tooltip("distance", MirrorItem.isSameDimension(context, linkedDimension) ? approximate : unknown).method_27692(typeColor));
                }
                if (config.mirrorTooltipDisplayDimension) {
                    class_5250 dimension = class_2561.method_43471((String)class_156.method_646((String)"dimension", (class_2960)linkedDimension.method_29177())).method_27692(valueColor);
                    list.add((class_2561)this.tooltip("dimension", dimension).method_27692(typeColor));
                }
            } else {
                list.add((class_2561)this.tooltip("unshifted", new Object[0]).method_27692(typeColor));
            }
        }
    }

    public static boolean is(class_1799 stack) {
        return stack.method_7909() instanceof MirrorItem;
    }

    public static boolean wasLinkedBefore(class_1799 stack) {
        return stack.method_57826(class_9334.field_49614);
    }

    public static boolean isLinked(class_1799 stack) {
        return MirrorItem.wasLinkedBefore(stack) && ((class_9291)stack.method_57824(class_9334.field_49614)).comp_2402().isPresent();
    }

    public static boolean isSameCoordinateScale(MirrorContext context) {
        class_7225.class_7226 registry = context.level().method_30349().method_46762(class_7924.field_41241);
        class_5321 beginning = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)context.dimension().method_29177());
        class_5321 linked = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)context.linkedDimension().method_29177());
        return class_2874.method_31109((class_2874)((class_2874)((class_6880.class_6883)registry.method_46746(beginning).get()).comp_349()), (class_2874)((class_2874)((class_6880.class_6883)registry.method_46746(linked).get()).comp_349())) == 1.0;
    }

    public static float getAdditionalCostIncreaseDistance(class_1799 stack, class_1309 user, float f) {
        MutableFloat mutable = new MutableFloat(f);
        class_1890.method_8220((class_1799)stack, (holder, i) -> ((class_1887)holder.comp_349()).method_60506(EnderscapeEnchantmentEffectComponents.MIRROR_DISTANCE_FOR_COST_INCREASE, user.method_59922(), i, mutable));
        return Math.max(0.0f, mutable.floatValue());
    }

    public static void writeData(class_1799 stack, class_2338 pos, class_5321<class_1937> dimension) {
        stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(class_4208.method_19443(dimension, (class_2338)pos)), true));
    }

    public static boolean isSameDimension(MirrorContext context, class_5321<class_1937> dimension) {
        return context.dimension() == dimension;
    }

    public static boolean hasTransdimensional(MirrorContext context) {
        try {
            class_7225.class_7226 registry = context.level().method_30349().method_46762(class_7924.field_41265);
            Optional enchantment = registry.method_46746(EnderscapeEnchantments.TRANSDIMENSIONAL);
            return class_1890.method_8225((class_6880)((class_6880)enchantment.get()), (class_1799)context.stack()) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getTotalDistanceForCostIncrease(NebuliteToolContext context) {
        class_1799 stack = context.stack();
        return (int)MirrorItem.getAdditionalCostIncreaseDistance(context.stack(), context.user(), this.getDistanceForCostIncrease(stack));
    }

    private int getDistanceForCostIncrease(class_1799 stack) {
        if (stack.method_57826(EnderscapeDataComponents.DISTANCE_FOR_COST_TO_INCREASE)) {
            return (Integer)stack.method_57824(EnderscapeDataComponents.DISTANCE_FOR_COST_TO_INCREASE);
        }
        throw new IllegalStateException("Cost increase distance is not defined.");
    }

    private int distanceBetweenPoints(class_2338 pos, class_2338 pos2) {
        float x = pos.method_10263() - pos2.method_10263();
        float z = pos.method_10260() - pos2.method_10260();
        return (int)class_3532.method_15355((float)(x * x + z * z));
    }
}

