/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import net.bunten.enderscape.block.MurublightShelfBlock;
import net.bunten.enderscape.feature.LargeMurublightChanterelleConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class LargeMurublightChanterelleGenerator {
    public static boolean tryGenerate(class_1936 level, class_5819 random, class_2338 origin, LargeMurublightChanterelleConfig config) {
        class_2350 direction = config.direction();
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            throw new IllegalStateException("Cannot use direction " + direction.method_10151() + " for " + String.valueOf(LargeMurublightChanterelleConfig.class));
        }
        class_2338 attached = origin.method_10093(direction.method_10153());
        if (level.method_8320(attached).method_26206((class_1922)level, attached, direction)) {
            for (int i = 0; i < config.tries(); ++i) {
                int height = config.height().method_35008(random);
                if (!LargeMurublightChanterelleGenerator.isEnoughAir(level, origin, direction, height)) continue;
                return LargeMurublightChanterelleGenerator.generate(level, origin, random, config, height);
            }
        }
        return false;
    }

    public static boolean generate(class_1936 level, class_2338 origin, class_5819 random, LargeMurublightChanterelleConfig config, int height) {
        class_2350 direction = config.direction();
        if (level.method_8320(origin.method_10093(direction.method_10153())).method_27852(EnderscapeBlocks.CORRUPT_OVERGROWTH)) {
            BlockUtil.place(level, origin.method_10093(direction.method_10153()), EnderscapeBlocks.MIRESTONE.method_9564());
        }
        BlockUtil.place(level, origin, class_2246.field_10124.method_9564());
        LargeMurublightChanterelleGenerator.generateCap(level, origin.method_10079(direction, --height), direction, config.cap_radius().method_35008(random), 1.0f);
        LargeMurublightChanterelleGenerator.generateMiniCaps(level, origin, random, config, height);
        for (int a = 0; a < height; ++a) {
            BlockUtil.place(level, origin.method_10079(direction, a), (class_2680)EnderscapeBlocks.MURUBLIGHT_STEM.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)direction.method_10166()));
        }
        for (int b = 0; b < height; ++b) {
            if (b % 4 != 0 || b <= 0) continue;
            LargeMurublightChanterelleGenerator.generateMurublightShelves(level, origin.method_10079(direction, b), random, config);
        }
        return true;
    }

    protected static void generateCap(class_1936 level, class_2338 pos, class_2350 direction, int radius, float rounding) {
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)((float)radius * rounding))) continue;
                int y = direction.method_10166() != class_2350.class_2351.field_11052 ? 1 : 0;
                int offset = 0;
                if (radius > 4 && distance >= (double)((float)radius * 0.3f)) {
                    ++offset;
                }
                if (radius > 3 && distance >= (double)((float)radius * 0.7f)) {
                    ++offset;
                }
                class_2338 pos2 = pos.method_10069(x, y, z).method_10079(direction, -offset);
                BlockUtil.replace(level, pos2, EnderscapeBlocks.MURUBLIGHT_CAP.method_9564());
            }
        }
    }

    protected static void generateMiniCaps(class_1936 level, class_2338 pos, class_5819 random, LargeMurublightChanterelleConfig config, int height) {
        class_2350 direction = config.direction();
        class_2338.class_2339 mutable = pos.method_25503().method_10098(direction.method_10153());
        int lastX = 0;
        int lastZ = 0;
        block0: for (int i = 0; i < height / 4; ++i) {
            mutable.method_10104(direction, 4);
            for (int e = 0; e < 8; ++e) {
                int x = class_3532.method_15395((class_5819)random, (int)-1, (int)1);
                int z = class_3532.method_15395((class_5819)random, (int)-1, (int)1);
                if (x == 0 || z == 0 || x == lastX && z == lastZ) continue;
                LargeMurublightChanterelleGenerator.generateCap(level, mutable.method_10069(x, 0, z), direction, 3, 0.7f);
                lastX = x;
                lastZ = z;
                continue block0;
            }
        }
    }

    protected static void generateMurublightShelves(class_1936 level, class_2338 pos, class_5819 random, LargeMurublightChanterelleConfig config) {
        class_2350 direction = config.direction();
        for (class_2350 dir2 : class_2350.values()) {
            if (dir2.method_10166() == direction.method_10166()) continue;
            for (int i = -2; i < 2; ++i) {
                class_2338 pos2 = pos.method_10093(dir2).method_10069(0, i, 0);
                class_2680 state = (class_2680)EnderscapeBlocks.MURUBLIGHT_SHELF.method_9564().method_11657((class_2769)MurublightShelfBlock.FACING, (Comparable)dir2);
                if (!state.method_26184((class_4538)level, pos2) || !level.method_22347(pos2) || !(random.method_43057() >= 0.45f)) continue;
                BlockUtil.replace(level, pos2, state);
            }
        }
    }

    public static boolean isEnoughAir(class_1936 level, class_2338 start, class_2350 direction, int height) {
        for (int i = 1; i < height + 1; ++i) {
            if (level.method_22347(start.method_10079(direction, i))) continue;
            return false;
        }
        return height % 4 == 0;
    }
}

