/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class Driftlet
extends AbstractDrifter {
    public static int MAX_GROWTH_AGE = 24000;
    private int growthAge;

    public Driftlet(class_1299<? extends AbstractDrifter> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return Driftlet.createBaseDrifterAttributes().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23720, 0.5);
    }

    private void ageUp() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            Drifter drifter = (Drifter)this.method_29243(EnderscapeEntities.DRIFTER, true);
            drifter.method_5943((class_5425)server, this.method_37908().method_8404(drifter.method_24515()), class_3730.field_16468, null);
            drifter.method_5971();
            drifter.method_60490(this.method_18377(this.method_18376()));
            this.method_29243(class_1299.field_6098, true);
        }
    }

    private void setGrowthAge(int value) {
        this.growthAge = value;
        if (this.growthAge >= MAX_GROWTH_AGE && this.method_37908().method_18026(this.method_5829().method_1014(1.0))) {
            this.ageUp();
        }
    }

    private void increaseAge(int seconds) {
        this.setGrowthAge(this.growthAge + seconds * 20);
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_GROWTH_AGE - this.growthAge);
    }

    @Override
    public class_3414 getJumpSound() {
        return EnderscapeEntitySounds.DRIFTLET_JUMP;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            this.setGrowthAge(this.growthAge + 1);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Age", this.growthAge);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setGrowthAge(nbt.method_10550("Age"));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(EnderscapeItemTags.DRIFTER_FOOD)) {
            this.method_6475(player, hand, stack);
            this.increaseAge(class_1296.method_41321((int)this.getTicksUntilGrowth()));
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected class_3414 method_5994() {
        return EnderscapeEntitySounds.DRIFTLET_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return EnderscapeEntitySounds.DRIFTLET_HURT;
    }

    protected class_3414 method_6002() {
        return EnderscapeEntitySounds.DRIFTLET_DEATH;
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }
}

