/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.world;

import com.mojang.blaze3d.systems.RenderSystem;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class EnderscapeSkybox {
    public static final class_7833 SKY_ROTATION_AXIS = class_7833.field_40716;
    public static float fogStartDensity = 1.0f;
    public static float fogEndDensity = 1.0f;
    public static Vector4f nebulaColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static Vector4f starColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private static final class_291 nebula1 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 2L);
    private static final class_291 nebula2 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 3L);
    private static final class_291 stars = EnderscapeSkybox.createStarsBuffer();

    public static float gammaFactor() {
        if (!EnderscapeConfig.getInstance().skyboxScalesBrightnessWithGamma) {
            return 1.0f;
        }
        float gamma = ((Double)class_310.method_1551().field_1690.method_42473().method_41753()).floatValue();
        float scale = (float)EnderscapeConfig.getInstance().skyboxBrightnessScaleFactor / 100.0f;
        return 1.0f + gamma * scale;
    }

    private static Vector4f computeSkyColor(class_4184 camera, class_638 level) {
        class_243 position = camera.method_19326().method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_243 skyColor = class_6491.method_24895((class_243)position, (ix, jx, k) -> class_243.method_24457((int)((class_1959)level.method_22385().method_24854(ix, jx, k).comp_349()).method_8697())).method_1021((double)EnderscapeSkybox.gammaFactor());
        return new Vector4f((float)skyColor.method_10216(), (float)skyColor.method_10214(), (float)skyColor.method_10215(), 1.0f);
    }

    public static void render(class_4587 pose, class_638 level, class_4184 camera, class_9779 tracker) {
        float gameTime = ((float)level.method_8510() + tracker.method_60636()) % 360000.0f;
        float baseSpeed = gameTime * 3.0E-5f;
        EnderscapeSkybox.renderSkybox(pose, EnderscapeSkybox.computeSkyColor(camera, level), baseSpeed);
        EnderscapeSkybox.renderNebulae(pose, nebulaColor, baseSpeed * 5.0f);
        EnderscapeSkybox.renderStars(pose, starColor, baseSpeed * 10.0f);
    }

    private static void renderSkybox(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.setShaderTexture((int)0, (class_2960)Enderscape.id("textures/environment/sky.png"));
        class_289 tesselator = class_289.method_1348();
        for (int i = 0; i < 6; ++i) {
            pose.method_22903();
            switch (i) {
                case 1: {
                    pose.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    break;
                }
                case 2: {
                    pose.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    pose.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                    break;
                }
                case 4: {
                    pose.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                    break;
                }
                case 5: {
                    pose.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
                }
            }
            Matrix4f matrix4f = pose.method_23760().method_23761();
            class_287 builder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            builder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
            builder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_39415(-1);
            builder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_39415(-1);
            builder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_39415(-1);
            class_286.method_43433((class_9801)builder.method_60800());
            pose.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        matrix.popMatrix();
    }

    private static class_291 createNebulaeBuffer(double minSize, double maxSize, int count, long seed) {
        class_291 buffer = new class_291(class_291.class_8555.field_44793);
        buffer.method_1353();
        buffer.method_1352(EnderscapeSkybox.drawNebulae(minSize, maxSize, count, seed, class_289.method_1348()));
        class_291.method_1354();
        return buffer;
    }

    private static class_9801 drawNebulae(double minSize, double maxSize, int count, long seed, class_289 tesselator) {
        class_5820 random = new class_5820(seed);
        class_287 builder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            double posX = random.method_43058() * 2.0 - 1.0;
            double posY = random.method_43058() - 0.5;
            double posZ = random.method_43058() * 2.0 - 1.0;
            double size = class_3532.method_15366((class_5819)random, (double)minSize, (double)maxSize);
            double length = posX * posX + posY * posY + posZ * posZ;
            double distance = 2.0;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = distance / Math.sqrt(length);
            size *= distance;
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.method_43058() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                builder.method_22912((float)(px + dx), (float)(py + dy), (float)(pz + dz)).method_22913(texU, texV);
            }
        }
        return builder.method_60800();
    }

    private static void renderNebulae(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (class_2960)Enderscape.id("textures/environment/nebula1.png"));
        nebula1.method_1353();
        nebula1.method_34427((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.setShaderTexture((int)0, (class_2960)Enderscape.id("textures/environment/nebula2.png"));
        nebula2.method_1353();
        nebula2.method_34427((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        matrix.popMatrix();
    }

    private static class_291 createStarsBuffer() {
        class_291 buffer = new class_291(class_291.class_8555.field_44793);
        buffer.method_1353();
        buffer.method_1352(EnderscapeSkybox.drawStars(1500, 0.05f, 0.25f, class_289.method_1348()));
        class_291.method_1354();
        return buffer;
    }

    private static class_9801 drawStars(int count, float minSize, float maxSize, class_289 tesselator) {
        class_5819 random = class_5819.method_43049((long)10842L);
        float scale = 100.0f;
        class_287 builder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        for (int i = 0; i < count; ++i) {
            float z;
            float y;
            float size = class_3532.method_32750((class_5819)random, (float)minSize, (float)maxSize);
            float x = random.method_43057() * 2.0f - 1.0f;
            float lengthSquared = class_3532.method_60677((float)x, (float)(y = random.method_43057() * 2.0f - 1.0f), (float)(z = random.method_43057() * 2.0f - 1.0f));
            if (lengthSquared <= 0.010000001f || lengthSquared >= 1.0f) continue;
            Vector3f direction = new Vector3f(x, y, z).normalize(scale);
            float rotation = (float)(random.method_43058() * 3.1415927410125732 * 2.0);
            Matrix3f matrix = new Matrix3f().rotateTowards((Vector3fc)new Vector3f((Vector3fc)direction).negate(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-rotation);
            builder.method_60830(new Vector3f(size, -size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.method_60830(new Vector3f(size, size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.method_60830(new Vector3f(-size, size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.method_60830(new Vector3f(-size, -size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
        }
        return builder.method_60800();
    }

    private static void renderStars(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.enableBlend();
        stars.method_1353();
        stars.method_34427((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        matrix.popMatrix();
    }
}

