/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class VoidShaleBlock
extends class_2248 {
    public static final int MAX_ITERATIONS = 60;
    public static final int MAX_STRESS = 4;
    public static final class_2746 COOLDOWN = class_2746.method_11825((String)"cooldown");
    public static final class_2746 NATURAL = class_2746.method_11825((String)"natural");
    public static final class_2758 ITERATION = class_2758.method_11867((String)"iteration", (int)0, (int)60);
    public static final class_2758 STRESS = class_2758.method_11867((String)"stress", (int)0, (int)4);

    public VoidShaleBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)COOLDOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NATURAL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ITERATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)STRESS, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{COOLDOWN, NATURAL, ITERATION, STRESS});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)NATURAL, (Comparable)Boolean.valueOf(false));
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (this.getStress(state) == 4) {
            boolean shouldDestroy = true;
            for (class_2350 dir : class_2350.values()) {
                class_2338 relative = pos.method_10093(dir);
                class_2680 other = level.method_8320(relative);
                int iteration = this.getIteration(state) + 1 + random.method_43048(2);
                if (this.canAttach((class_1937)level, dir, other, relative)) {
                    shouldDestroy = false;
                    break;
                }
                if (!other.method_27852((class_2248)this) || iteration >= 60) continue;
                level.method_8652(relative, (class_2680)((class_2680)other.method_11657((class_2769)STRESS, (Comparable)Integer.valueOf(4))).method_11657((class_2769)ITERATION, (Comparable)Integer.valueOf(iteration)), 2);
                level.method_39279(relative, (class_2248)this, 1);
            }
            if (shouldDestroy) {
                level.method_22352(pos, true);
            }
        } else if (this.onCooldown(state)) {
            level.method_8652(pos, (class_2680)state.method_28493((class_2769)COOLDOWN), 2);
        }
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1309 living;
        if (entity instanceof class_1309 && !(living = (class_1309)entity).method_6059(class_1294.field_5906) && !this.onCooldown(state) && !this.isAttachedToBlock(level, pos)) {
            int stress = this.getStress(state);
            this.playShatterSound(level, pos, stress);
            level.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)STRESS, (Comparable)Integer.valueOf(Math.min(4, stress + 1)))).method_11657((class_2769)COOLDOWN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ITERATION, (Comparable)Integer.valueOf(0)), 2);
            level.method_39279(pos, (class_2248)this, living.method_18276() ? 30 : 15);
        }
    }

    private void playShatterSound(class_1937 level, class_2338 pos, int stress) {
        class_3414 sound = EnderscapeBlockSounds.VOID_SHALE_SHATTER_SOUNDS[Math.min(3, stress)];
        if (sound != class_3417.field_42593) {
            level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private boolean canAttach(class_1937 level, class_2350 dir, class_2680 state, class_2338 relative) {
        return state.method_26206((class_1922)level, relative, dir) && !state.method_26215() && !state.method_27852((class_2248)this);
    }

    private boolean isAttachedToBlock(class_1937 level, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 relative = pos.method_10093(dir);
            class_2680 other = level.method_8320(relative);
            if (!this.canAttach(level, dir, other, relative)) continue;
            return true;
        }
        return false;
    }

    private int getStress(class_2680 state) {
        return (Integer)state.method_11654((class_2769)STRESS);
    }

    private boolean onCooldown(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)COOLDOWN);
    }

    private Integer getIteration(class_2680 state) {
        return (Integer)state.method_11654((class_2769)ITERATION);
    }
}

