/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import java.util.HashMap;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.properties.MagniaType;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2769;
import net.minecraft.class_3222;

public class MagniaSproutBlockEntity
extends class_2586 {
    private static final HashMap<class_2350, class_2382> DIRECTION_TO_VEC3I = new HashMap();

    public MagniaSproutBlockEntity(class_2338 pos, class_2680 state) {
        super(EnderscapeBlockEntities.MAGNIA_SPROUT, pos, state);
    }

    public static class_238 getRange(class_1937 level, class_2680 state, class_2338 originPos) {
        class_2350 direction = MagniaSproutBlock.getFacing(state);
        MagniaType type = MagniaSproutBlock.getMagniaType(state);
        if (type != null) {
            class_2338 current = originPos;
            float maxRange = 14.0f;
            int i = 1;
            while ((float)i <= maxRange && !level.method_8320(current = originPos.method_10079(direction, i)).method_26164(type.getBlockedByTag())) {
                ++i;
            }
            class_243 start = class_243.method_24953((class_2382)originPos.method_10093(direction)).method_1019(class_243.method_24954((class_2382)DIRECTION_TO_VEC3I.get(direction)).method_1021(-1.0));
            class_243 end = class_243.method_24953((class_2382)current).method_1019(class_243.method_24954((class_2382)DIRECTION_TO_VEC3I.get(direction)).method_1021(-0.5));
            class_238 range = new class_238(start, end);
            return switch (direction.method_10166()) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> range.method_1009(0.0, 0.75, 0.75);
                case class_2350.class_2351.field_11052 -> range.method_1009(0.75, 0.0, 0.75);
                case class_2350.class_2351.field_11051 -> range.method_1009(0.75, 0.75, 0.0);
            };
        }
        return new class_238(originPos);
    }

    private static void move(class_1297 entity, class_243 velocity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2743(entity));
        }
        if (MagniaMoveable.getMagniaProperties(entity).shouldAddVelocity().test(entity)) {
            entity.method_45319(velocity);
        } else {
            entity.method_18799(velocity);
        }
    }

    static void doMagniaMovement(class_1297 entity, MagniaSproutBlockEntity blockEntity) {
        MagniaProperties properties = MagniaMoveable.getMagniaProperties(entity);
        if (properties == null) {
            return;
        }
        properties.onMoved().apply(entity);
        class_243 pos = entity.method_5829().method_1005();
        class_2680 state = blockEntity.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)MagniaSproutBlock.FACING);
        if (MagniaSproutBlock.isRepulsive(state)) {
            float factor = properties.repelStrength().apply(entity).floatValue();
            class_243 velocity = new class_243((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165()).method_1029().method_18805((double)factor, (double)factor, (double)factor);
            MagniaSproutBlockEntity.move(entity, velocity);
            entity.field_6007 = true;
            if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                entity.method_5783(MagniaSproutBlock.getMagniaType(state).getMoveSound(), 1.0f, 1.0f);
            }
            MagniaMoveable.setMovedByMagnia(entity, true);
        } else {
            double distance;
            class_243 moveTarget = class_243.method_24953((class_2382)blockEntity.method_11016()).method_1031((double)((float)facing.method_10148() * 1.2f), (double)((float)facing.method_10164() * 1.2f), (double)((float)facing.method_10165() * 1.2f));
            if (MagniaSproutBlockEntity.shouldOffset(blockEntity, facing)) {
                moveTarget = moveTarget.method_1023(0.0, entity.method_5829().method_17940() * (double)1.2f, 0.0);
            }
            if ((distance = pos.method_1022(moveTarget)) > (double)0.1f) {
                class_243 velocity = moveTarget.method_1020(pos).method_1029().method_1021((double)(properties.attractStrength().apply(entity).floatValue() * (float)Math.min(distance / 5.0, 1.0)));
                if (distance < 1.5) {
                    velocity = velocity.method_1021((double)((float)(0.75 + distance / 2.0 * 0.25)));
                }
                MagniaSproutBlockEntity.move(entity, velocity);
                entity.field_6007 = true;
                if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                    entity.method_5783(MagniaSproutBlock.getMagniaType(state).getMoveSound(), 1.0f, 1.0f);
                }
                MagniaMoveable.setMovedByMagnia(entity, true);
            } else {
                MagniaSproutBlockEntity.move(entity, class_243.field_1353);
                entity.field_6007 = true;
                MagniaMoveable.setMovedByMagnia(entity, true);
            }
        }
    }

    private static boolean shouldOffset(MagniaSproutBlockEntity entity, class_2350 facing) {
        return facing != class_2350.field_11036 && !entity.method_10997().method_8320(entity.method_11016().method_10093(facing).method_10074()).method_26215();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MagniaSproutBlockEntity entity) {
        if (!MagniaSproutBlock.canPullEntities(state)) {
            return;
        }
        level.method_8390(class_1297.class, MagniaSproutBlockEntity.getRange(level, state, pos), MagniaMoveable::canMagniaAffect).forEach(moved -> MagniaSproutBlockEntity.doMagniaMovement(moved, entity));
    }

    static {
        DIRECTION_TO_VEC3I.put(class_2350.field_11033, new class_2382(0, -1, 0));
        DIRECTION_TO_VEC3I.put(class_2350.field_11036, new class_2382(0, 1, 0));
        DIRECTION_TO_VEC3I.put(class_2350.field_11043, new class_2382(0, 0, -1));
        DIRECTION_TO_VEC3I.put(class_2350.field_11035, new class_2382(0, 0, 1));
        DIRECTION_TO_VEC3I.put(class_2350.field_11039, new class_2382(-1, 0, 0));
        DIRECTION_TO_VEC3I.put(class_2350.field_11034, new class_2382(1, 0, 0));
    }
}

