/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.tlib.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3610;

@Environment(value=EnvType.CLIENT)
public class TBlockUtils {
    public static boolean isSolid(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26225() && !state.method_26215() && state.method_26227().method_15769();
    }

    public static boolean isAirOrFluid(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_3610 fs = state.method_26227();
        return state.method_26215() || !fs.method_15769();
    }

    public static boolean isLightSource(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26213() > 0;
    }

    public static class_2338 findNearest(class_1937 world, class_2338 center, int radius, Predicate<class_2680> predicate) {
        class_2338 nearest = null;
        double minDist = Double.MAX_VALUE;
        int cx = center.method_10263();
        int cy = center.method_10264();
        int cz = center.method_10260();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int y = cy - radius; y <= cy + radius; ++y) {
                for (int z = cz - radius; z <= cz + radius; ++z) {
                    double d;
                    class_2338 p = new class_2338(x, y, z);
                    class_2680 st = world.method_8320(p);
                    if (!predicate.test(st) || !((d = center.method_10262((class_2382)p)) < minDist)) continue;
                    minDist = d;
                    nearest = p;
                }
            }
        }
        return nearest;
    }

    public static boolean isReplaceable(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_45474();
    }

    public static boolean isLiquid(class_1937 world, class_2338 pos) {
        return !world.method_8320(pos).method_26227().method_15769();
    }

    public static boolean isWalkable(class_1937 world, class_2338 pos) {
        class_2680 st = world.method_8320(pos);
        class_2248 b = st.method_26204();
        return st.method_26225() && st.method_26227().method_15769() && !st.method_45474() && b != class_2246.field_10036;
    }

    public static class_2338 getBlockAbove(class_2338 pos) {
        return pos.method_10084();
    }

    public static class_2338 getBlockBelow(class_2338 pos) {
        return pos.method_10074();
    }

    public static class_2338 traceVertical(class_1937 world, class_2338 start, class_2350 dir, Predicate<class_2680> stopAt) {
        class_2338.class_2339 m = start.method_25503();
        while (world.method_24794((class_2338)m)) {
            m.method_10098(dir);
            if (!stopAt.test(world.method_8320((class_2338)m))) continue;
            return m.method_10062();
        }
        return null;
    }

    public static List<class_2338> getNearbyBlocks(class_1937 world, class_2338 center, int radius, Predicate<class_2680> predicate) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        int cx = center.method_10263();
        int cy = center.method_10264();
        int cz = center.method_10260();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int y = cy - radius; y <= cy + radius; ++y) {
                for (int z = cz - radius; z <= cz + radius; ++z) {
                    class_2338 p = new class_2338(x, y, z);
                    class_2680 st = world.method_8320(p);
                    if (!predicate.test(st)) continue;
                    result.add(p);
                }
            }
        }
        return result;
    }

    public static int getSurfaceHeight(class_1937 world, int x, int z) {
        return world.method_8624(class_2902.class_2903.field_13194, x, z);
    }
}

