/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.block.custom;

import net.emilsg.clutter.block.custom.cutout.ICutoutRenderable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FishTankBlock
extends class_2248
implements class_3737,
ICutoutRenderable {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<TankType> TYPE = class_2754.method_11850((String)"type", TankType.class);
    public static final class_2754<InteriorType> INTERIOR = class_2754.method_11850((String)"interior", InteriorType.class);
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final class_265 BOTTOM_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final class_265 SINGLE_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), class_2248.method_9541((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), this.BOTTOM_SHAPE});
    private final class_265 NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (class_265[])new class_265[]{class_2248.method_9541((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0)});
    private final class_265 EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0)});
    private final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)15.0), class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0)});
    private final class_265 WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), class_2248.method_9541((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)});

    public FishTankBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)TankType.SINGLE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(INTERIOR, (Comparable)((Object)InteriorType.NONE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, FACING, WATERLOGGED, INTERIOR});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        class_1799 stackInHand = player.method_5998(hand);
        InteriorType currentType = (InteriorType)((Object)state.method_11654(INTERIOR));
        InteriorType newType = this.getTypeFromItemStack(stackInHand);
        if (newType == null || currentType == newType) {
            return class_1269.field_5811;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (!newType.isOf(InteriorType.NONE) && !player.method_31549().field_7477) {
                stackInHand.method_7934(1);
            }
            serverWorld.method_8652(pos, (class_2680)state.method_11657(INTERIOR, (Comparable)((Object)newType)), 3);
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Nullable
    private InteriorType getTypeFromItemStack(class_1799 stackInHand) {
        if (stackInHand.method_31574(class_1802.field_8858)) {
            return InteriorType.BEACH;
        }
        if (class_7923.field_41178.method_10221((Object)stackInHand.method_7909()).method_12832().contains("coral")) {
            return InteriorType.CORAL;
        }
        if (stackInHand.method_31574(class_1802.field_8110)) {
            return InteriorType.GRAVELLY;
        }
        if (stackInHand.method_31574(class_1802.field_8162)) {
            return InteriorType.NONE;
        }
        return null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return true;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        TankType type = (TankType)((Object)state.method_11654(TYPE));
        if (type.isOf(TankType.SINGLE)) {
            return this.SINGLE_SHAPE;
        }
        return class_259.method_1084((class_265)this.BOTTOM_SHAPE, (class_265)(switch (facing) {
            default -> {
                if (type.isOf(TankType.RIGHT)) {
                    yield this.EAST_SHAPE;
                }
                yield this.WEST_SHAPE;
            }
            case class_2350.field_11034 -> {
                if (type.isOf(TankType.RIGHT)) {
                    yield this.SOUTH_SHAPE;
                }
                yield this.NORTH_SHAPE;
            }
            case class_2350.field_11035 -> {
                if (type.isOf(TankType.RIGHT)) {
                    yield this.WEST_SHAPE;
                }
                yield this.EAST_SHAPE;
            }
            case class_2350.field_11039 -> type.isOf(TankType.RIGHT) ? this.NORTH_SHAPE : this.SOUTH_SHAPE;
        }));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction3;
        TankType tankType = TankType.SINGLE;
        class_2350 direction = ctx.method_8042().method_10153();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl = ctx.method_8046();
        class_2350 direction2 = ctx.method_8038();
        if (direction2.method_10166().method_10179() && bl && (direction3 = this.getNeighborTankDirection(ctx, direction2.method_10153())) != null && direction3.method_10166() != direction2.method_10166()) {
            direction = direction3;
            TankType tankType2 = tankType = direction.method_10160() == direction2.method_10153() ? TankType.RIGHT : TankType.LEFT;
        }
        if (tankType == TankType.SINGLE && !bl) {
            if (direction == this.getNeighborTankDirection(ctx, direction.method_10170())) {
                tankType = TankType.LEFT;
            } else if (direction == this.getNeighborTankDirection(ctx, direction.method_10160())) {
                tankType = TankType.RIGHT;
            }
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657(TYPE, (Comparable)((Object)tankType))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    @Nullable
    private class_2350 getNeighborTankDirection(class_1750 ctx, class_2350 dir) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(dir));
        return blockState.method_27852((class_2248)this) && blockState.method_11654(TYPE) == TankType.SINGLE ? (class_2350)blockState.method_11654((class_2769)FACING) : null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (neighborState.method_27852((class_2248)this) && direction.method_10166().method_10179()) {
            TankType tankType = (TankType)((Object)neighborState.method_11654(TYPE));
            if (state.method_11654(TYPE) == TankType.SINGLE && tankType != TankType.SINGLE && state.method_11654((class_2769)FACING) == neighborState.method_11654((class_2769)FACING) && FishTankBlock.getFacing(neighborState) == direction.method_10153()) {
                return (class_2680)state.method_11657(TYPE, (Comparable)((Object)tankType.getOpposite()));
            }
        } else if (FishTankBlock.getFacing(state) == direction) {
            return (class_2680)state.method_11657(TYPE, (Comparable)((Object)TankType.SINGLE));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public static class_4732.class_4733 getDoubleBlockType(class_2680 state) {
        TankType tankType = (TankType)((Object)state.method_11654(TYPE));
        if (tankType == TankType.SINGLE) {
            return class_4732.class_4733.field_21783;
        }
        return tankType == TankType.RIGHT ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(TYPE) == TankType.LEFT ? direction.method_10170() : direction.method_10160();
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public static enum TankType implements class_3542
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private TankType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean isOf(TankType type) {
            return type == this;
        }

        public TankType getOpposite() {
            return switch (this.ordinal()) {
                case 0 -> SINGLE;
                case 1 -> RIGHT;
                case 2 -> LEFT;
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }

    public static enum InteriorType implements class_3542
    {
        CORAL("coral"),
        BEACH("beach"),
        GRAVELLY("gravelly"),
        NONE("none");

        private final String name;

        private InteriorType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean isOf(InteriorType type) {
            return type == this;
        }
    }
}

