/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.BiomeBasedLayerConfig;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7924;
import net.minecraft.class_8174;

public class LayeredBlockSurface
extends class_3031<BiomeBasedLayerConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public LayeredBlockSurface(Codec<BiomeBasedLayerConfig> configFactory) {
        super(configFactory);
    }

    public boolean method_13151(class_5821<BiomeBasedLayerConfig> context) {
        this.setSeed(context.method_33652().method_8412());
        class_2338.class_2339 mutableBlockPos = context.method_33655().method_25503();
        class_2338.class_2339 mutableBlockPosForChunk = new class_2338.class_2339();
        class_1923 chunkPos = new class_1923((class_2338)mutableBlockPos);
        class_1959 targetBiome = (class_1959)((class_2378)context.method_33652().method_30349().method_33310(class_7924.field_41236).get()).method_10223(((BiomeBasedLayerConfig)context.method_33656()).biomeRL);
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((class_1936)context.method_33652());
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                class_1923 currentChunkPos = new class_1923(chunkPos.field_9181 + xOffset, chunkPos.field_9180 + zOffset);
                mutableBlockPosForChunk.method_10101((class_2382)currentChunkPos.method_8323());
                class_2791 cachedChunk = context.method_33652().method_22350(currentChunkPos.method_8323());
                if (xOffset != 0 && zOffset != 0 && cachedChunk.method_38259(0).method_38293(0, 0, 0).comp_349() == targetBiome) continue;
                this.fillChunkWithPollen(context, bulkSectionAccess, cachedChunk, currentChunkPos.method_8323(), targetBiome);
            }
        }
        return true;
    }

    private void fillChunkWithPollen(class_5821<BiomeBasedLayerConfig> context, UnsafeBulkSectionAccess bulkSectionAccess, class_2791 cachedChunk, class_2338 startPos, class_1959 targetBiome) {
        int configHeight = ((BiomeBasedLayerConfig)context.method_33656()).height;
        class_2680 configBlockState = ((BiomeBasedLayerConfig)context.method_33656()).state;
        Optional<class_2680> configRareBlockState = ((BiomeBasedLayerConfig)context.method_33656()).rareState;
        class_2338.class_2339 mutable = context.method_33655().method_25503();
        class_2680 previousBlockState = class_2246.field_10124.method_9564();
        class_5819 random = context.method_33654();
        int maxY = context.method_33653().method_12104() + context.method_33653().method_33730() - 1;
        for (int xOffset = 0; xOffset <= 15; ++xOffset) {
            for (int zOffset = 0; zOffset <= 15; ++zOffset) {
                mutable.method_10103(startPos.method_10263() + xOffset, maxY, startPos.method_10260() + zOffset);
                if (targetBiome != context.method_33652().method_22385().method_27344((class_2338)mutable).comp_349()) continue;
                while (mutable.method_10264() >= context.method_33653().method_16398() - 1) {
                    class_2680 currentBlockState = bulkSectionAccess.getBlockState((class_2338)mutable);
                    if (!(currentBlockState.method_26215() || !currentBlockState.method_26227().method_15769() || previousBlockState.method_26204() != class_2246.field_10124 || currentBlockState.method_27852(configBlockState.method_26204()) || configRareBlockState.isPresent() && currentBlockState.method_27852(configRareBlockState.get().method_26204()))) {
                        if (!currentBlockState.method_26206((class_1922)context.method_33652(), (class_2338)mutable, class_2350.field_11036)) {
                            previousBlockState = currentBlockState;
                            mutable.method_10098(class_2350.field_11033);
                            continue;
                        }
                        for (int height = 1; height <= configHeight && mutable.method_10264() + height < maxY; ++height) {
                            class_2586 blockEntity;
                            class_2680 finalBlockState;
                            class_2338 finalPosition = mutable.method_10086(height);
                            if (height > 1 && !(finalBlockState = bulkSectionAccess.getBlockState(finalPosition)).method_26215()) break;
                            int layerHeight = 8;
                            if (height == configHeight) {
                                float xzScale = 0.035f;
                                float yScale = 0.015f;
                                double noiseVal = Math.abs(noiseGen.noise3_Classic((float)mutable.method_10263() * xzScale, (float)mutable.method_10264() * yScale + (float)height, (float)mutable.method_10260() * xzScale));
                                layerHeight = Math.max(1, (int)((noiseVal * 0.63 + 0.4) * 8.0));
                                layerHeight = Math.min(8, layerHeight);
                            }
                            class_2680 blockToPlace = configBlockState;
                            if ((height < configHeight || layerHeight == 8) && configRareBlockState.isPresent() && random.method_43057() < ((BiomeBasedLayerConfig)context.method_33656()).rareStateChance) {
                                blockToPlace = configRareBlockState.get();
                            }
                            if (blockToPlace.method_28498((class_2769)class_2741.field_12536)) {
                                bulkSectionAccess.setBlockState(finalPosition, (class_2680)blockToPlace.method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(layerHeight)), false);
                                context.method_33652().method_39279(finalPosition, blockToPlace.method_26204(), 0);
                                continue;
                            }
                            bulkSectionAccess.setBlockState(finalPosition, blockToPlace, false);
                            if (!blockToPlace.method_31709() || (blockEntity = ((class_2343)blockToPlace.method_26204()).method_10123(finalPosition, blockToPlace)) == null) continue;
                            if (blockEntity instanceof class_8174) {
                                class_8174 brushableBlock = (class_8174)blockEntity;
                                if (((BiomeBasedLayerConfig)context.method_33656()).suspiciousBlockLoot.isPresent()) {
                                    brushableBlock.method_49216(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)((BiomeBasedLayerConfig)context.method_33656()).suspiciousBlockLoot.get()), random.method_43055());
                                }
                            }
                            cachedChunk.method_12007(blockEntity);
                        }
                    }
                    previousBlockState = currentBlockState;
                    mutable.method_10098(class_2350.field_11033);
                }
            }
        }
    }
}

