/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.telepathicgrunt.the_bumblezone.mixin.world.BiomeManagerAccessor;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_4543;
import net.minecraft.class_6880;

public class NoVerticalBlendBiomeManager
extends class_4543 {
    private final class_4543 biomeManager;
    private final class_4543.class_4544 localBiomeSource;
    private final Long2ObjectMap<class_6880<class_1959>> cachedResult = new Long2ObjectOpenHashMap();

    public NoVerticalBlendBiomeManager(class_4543 biomeManager, class_4543.class_4544 localBiomeSource) {
        super(((BiomeManagerAccessor)biomeManager).bumblezone$getNoiseBiomeSource(), ((BiomeManagerAccessor)biomeManager).bumblezone$getBiomeZoomSeed());
        this.biomeManager = biomeManager;
        this.localBiomeSource = localBiomeSource;
    }

    public class_6880<class_1959> method_22393(class_2338 arg) {
        class_6880 biomeHolder;
        int xMinus2 = arg.method_10263() - 2;
        int zMinus2 = arg.method_10260() - 2;
        int xShifted = xMinus2 >> 2;
        int zShifted = zMinus2 >> 2;
        long key = this.packXZ(xMinus2, zMinus2);
        class_6880 result = (class_6880)this.cachedResult.get(key);
        if (result != null) {
            return result;
        }
        double xMagic = (double)(xMinus2 & 3) / 4.0;
        double zMagic = (double)(zMinus2 & 3) / 4.0;
        int lastIteration = 0;
        double currentDistance = Double.POSITIVE_INFINITY;
        for (int iteration = 0; iteration < 8; ++iteration) {
            boolean flag4 = (iteration & 4) == 0;
            boolean flag1 = (iteration & 1) == 0;
            int xShiftedFlagged = flag4 ? xShifted : xShifted + 1;
            int zShiftedFlagged = flag1 ? zShifted : zShifted + 1;
            double xMagicFlagged = flag4 ? xMagic : xMagic - 1.0;
            double zMagicFlagged = flag1 ? zMagic : zMagic - 1.0;
            double fiddledDistance = NoVerticalBlendBiomeManager.getFiddledDistance(((BiomeManagerAccessor)this.biomeManager).bumblezone$getBiomeZoomSeed(), xShiftedFlagged, zShiftedFlagged, xMagicFlagged, zMagicFlagged);
            if (!(currentDistance > fiddledDistance)) continue;
            lastIteration = iteration;
            currentDistance = fiddledDistance;
        }
        int finalX = (lastIteration & 4) == 0 ? xShifted : xShifted + 1;
        int finalZ = (lastIteration & 1) == 0 ? zShifted : zShifted + 1;
        class_6880 class_68802 = biomeHolder = this.localBiomeSource != null ? this.localBiomeSource.method_16359(finalX, 0, finalZ) : ((BiomeManagerAccessor)this.biomeManager).bumblezone$getNoiseBiomeSource().method_16359(finalX, 0, finalZ);
        if (this.cachedResult.size() > 512) {
            this.cachedResult.clear();
        }
        this.cachedResult.put(key, (Object)biomeHolder);
        return biomeHolder;
    }

    private long packXZ(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    private static double getFiddledDistance(long zoom, int xShiftedFlag, int zShiftedFlag, double magicXFlagged, double magicZFlagged) {
        long congruent = LinearCongruentialGenerator.next(zoom, xShiftedFlag);
        congruent = LinearCongruentialGenerator.next(congruent);
        congruent = LinearCongruentialGenerator.next(congruent, zShiftedFlag);
        congruent = LinearCongruentialGenerator.next(congruent, xShiftedFlag);
        congruent = LinearCongruentialGenerator.next(congruent);
        congruent = LinearCongruentialGenerator.next(congruent, zShiftedFlag);
        double xCongruent = NoVerticalBlendBiomeManager.getFiddle(congruent);
        congruent = LinearCongruentialGenerator.next(congruent, zoom);
        double yCongruent = NoVerticalBlendBiomeManager.getFiddle(congruent);
        congruent = LinearCongruentialGenerator.next(congruent, zoom);
        double zCongruent = NoVerticalBlendBiomeManager.getFiddle(congruent);
        double zResult = magicZFlagged + zCongruent;
        double xResult = magicXFlagged + xCongruent;
        return zResult * zResult + yCongruent * yCongruent + xResult * xResult;
    }

    private static double getFiddle(long l) {
        double d = (double)Math.floorMod(l >> 24, 1024) / 1024.0;
        return (d - 0.5) * 0.9;
    }

    private static class LinearCongruentialGenerator {
        private static final long MULTIPLIER = 6364136223846793005L;
        private static final long INCREMENT = 1442695040888963407L;

        private LinearCongruentialGenerator() {
        }

        public static long next(long l, long m) {
            l *= l * 6364136223846793005L + 1442695040888963407L;
            return l + m;
        }

        public static long next(long l) {
            l *= l * 6364136223846793005L + 1442695040888963407L;
            return l;
        }
    }
}

