/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.items.HoneyCompass;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassBaseData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassStateData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.HoneyCompassTargetData;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzLootFunctionTypes;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3195;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9331;

public class HoneyCompassLocateStructure
extends class_120 {
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    final class_6862<class_3195> destination;
    final int searchRadius;
    final boolean skipKnownStructures;
    public static final MapCodec<HoneyCompassLocateStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> HoneyCompassLocateStructure.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41246).fieldOf("destination").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.destination), (App)Codec.intRange((int)0, (int)1000000).orElse((Object)50).fieldOf("search_radius").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.searchRadius), (App)Codec.BOOL.orElse((Object)true).fieldOf("skip_existing_chunks").forGetter(honeyCompassLocateStructure -> honeyCompassLocateStructure.skipKnownStructures))).apply((Applicative)instance, HoneyCompassLocateStructure::new));

    public HoneyCompassLocateStructure(List<class_5341> lootItemConditions, class_6862<class_3195> destination, int searchRadius, boolean skipKnownStructrues) {
        super(lootItemConditions);
        this.destination = destination;
        this.searchRadius = searchRadius;
        this.skipKnownStructures = skipKnownStructrues;
    }

    public class_5339 method_29321() {
        return (class_5339)BzLootFunctionTypes.HONEY_COMPASS_LOCATE_STRUCTURE.get();
    }

    public Set<class_169<?>> method_293() {
        return ImmutableSet.of((Object)class_181.field_24424);
    }

    public class_1799 method_522(class_1799 itemStack, class_47 lootContext) {
        class_243 vec3;
        if (itemStack.method_31574((class_1792)BzItems.HONEY_COMPASS.get()) && (vec3 = (class_243)lootContext.method_296(class_181.field_24424)) != null) {
            UUID searchId = UUID.randomUUID();
            class_2338 blockPos = class_2338.method_49638((class_2374)vec3);
            HoneyCompassStateData honeyCompassStateData = (HoneyCompassStateData)itemStack.method_57824((class_9331)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            itemStack.method_57379((class_9331)BzDataComponents.HONEY_COMPASS_STATE_DATA.get(), (Object)new HoneyCompassStateData(honeyCompassStateData.locked(), Optional.of(searchId), true, honeyCompassStateData.isFailed(), honeyCompassStateData.locatedSpecialStructure()));
            HoneyCompassTargetData honeyCompassTargetData = (HoneyCompassTargetData)itemStack.method_57824((class_9331)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            itemStack.method_57379((class_9331)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get(), (Object)new HoneyCompassTargetData(honeyCompassTargetData.targetBlock(), Optional.of(this.destination.comp_327().toString()), honeyCompassTargetData.targetPos(), honeyCompassTargetData.targetDimension()));
            class_5321 structure = null;
            class_2378 structureRegistry = (class_2378)lootContext.method_299().method_30349().method_33310(class_7924.field_41246).get();
            List structuresList = structureRegistry.method_40266(this.destination).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
            if (!structuresList.isEmpty()) {
                structure = (class_5321)structureRegistry.method_29113((Object)((class_3195)structuresList.get(lootContext.method_294().method_43048(structuresList.size())))).get();
            }
            WeakReference<class_1799> weakRefItemStack = new WeakReference<class_1799>(itemStack);
            if (structure != null) {
                ThreadExecutor.locate(lootContext.method_299(), searchId, (class_5321<class_3195>)structure, blockPos, 100, false).thenOnServerThread(foundPos -> this.setCompassFoundLocationData(weakRefItemStack, lootContext, (class_2338)foundPos));
            }
        }
        return itemStack;
    }

    private void setCompassFoundLocationData(WeakReference<class_1799> itemStackWeakReference, class_47 lootContext, class_2338 blockPos) {
        class_1799 itemStack = (class_1799)itemStackWeakReference.get();
        if (itemStack != null && blockPos != null) {
            HoneyCompassStateData oldHoneyCompassStateData = (HoneyCompassStateData)itemStack.method_57824((class_9331)BzDataComponents.HONEY_COMPASS_STATE_DATA.get());
            HoneyCompassBaseData oldHoneyCompassBaseData = (HoneyCompassBaseData)itemStack.method_57824((class_9331)BzDataComponents.HONEY_COMPASS_BASE_DATA.get());
            HoneyCompassTargetData oldHoneyCompassTargetData = (HoneyCompassTargetData)itemStack.method_57824((class_9331)BzDataComponents.HONEY_COMPASS_TARGET_DATA.get());
            HoneyCompass.setCompassStateData(oldHoneyCompassStateData, oldHoneyCompassStateData.locked(), Optional.empty(), false, false, oldHoneyCompassStateData.locatedSpecialStructure(), itemStack);
            HoneyCompass.setCompassBaseData(oldHoneyCompassBaseData, "structure", itemStack);
            HoneyCompass.setCompassTargetData(oldHoneyCompassTargetData, Optional.empty(), Optional.empty(), Optional.of(blockPos), Optional.of(lootContext.method_299().method_27983()), itemStack);
        }
    }
}

