/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceCurrentTargetData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceStateData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceTimerData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class RagingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.ragingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.ragingEssenceAbilityUse;
    private static final int radius = 24;
    private static final int trackingRange = 2304;
    private static final int maxEmpoweredTimeLimit = 375;
    private static final int maxCurrentTargets = 4;

    public RagingEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public void method_7860(class_1799 itemStack) {
        if (itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get(), (Object)new RagingEssenceStateData());
        }
        if (itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get(), (Object)new RagingEssenceCurrentTargetData());
        }
        if (itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get(), (Object)new RagingEssenceTimerData());
        }
        super.method_7860(itemStack);
    }

    @Override
    public int getColor() {
        return 0xFF2B2B;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_raging_description_1").method_27692(class_124.field_1061).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_raging_description_2").method_27692(class_124.field_1061).method_27692(class_124.field_1056));
    }

    public static void setRageState(class_1799 itemStack, short rageState) {
        itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get(), (Object)new RagingEssenceStateData(rageState));
    }

    public static short getRageState(class_1799 itemStack) {
        return ((RagingEssenceStateData)itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get())).rageStateLevel();
    }

    public static void setEmpoweredTimestamp(class_1799 itemStack, long empoweredTimestamp) {
        itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get(), (Object)new RagingEssenceTimerData(empoweredTimestamp));
    }

    public static long getEmpoweredTimestamp(class_1799 itemStack) {
        return ((RagingEssenceTimerData)itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get())).empoweredTimestamp();
    }

    public static void setCurrentTargets(class_1799 itemStack, List<UUID> targetsToKill) {
        itemStack.method_57379((class_9331)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get(), (Object)new RagingEssenceCurrentTargetData(targetsToKill));
    }

    public static List<UUID> getCurrentTargets(class_1799 itemStack) {
        return new ArrayList<UUID>(((RagingEssenceCurrentTargetData)itemStack.method_57824((class_9331)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get())).currentTargets());
    }

    @Override
    public void applyAbilityEffects(class_1799 itemStack, class_1937 level, class_3222 serverPlayer) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isActive() && BzGeneralConfigs.ragingEssenceStrengthLevels.length > 0) {
            short rageState = RagingEssence.getRageState(itemStack);
            if (rageState > BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                RagingEssence.setRageState(itemStack, (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length);
                rageState = (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            }
            if (rageState > 0 && ((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 5L == 0L) {
                RagingEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_59922(), rageState);
                if (level.method_8510() - RagingEssence.getEmpoweredTimestamp(itemStack) > 375L) {
                    RagingEssence.resetRage(itemStack, serverPlayer);
                    if (this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1)) {
                        return;
                    }
                }
            }
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 20L == 0L) {
                Object entities;
                List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(itemStack);
                if (currentTargetsToKill.size() < 4 && rageState + currentTargetsToKill.size() <= BzGeneralConfigs.ragingEssenceStrengthLevels.length && !(entities = level.method_8333((class_1297)serverPlayer, new class_238(serverPlayer.method_23317() - 24.0, serverPlayer.method_23318() - 6.0, serverPlayer.method_23321() - 24.0, serverPlayer.method_23317() + 24.0, serverPlayer.method_23318() + 6.0, serverPlayer.method_23321() + 24.0), e -> !currentTargetsToKill.contains(e.method_5667()) && RagingEssence.isTargetable(e, serverPlayer.method_5667()))).isEmpty() && currentTargetsToKill.size() < 4) {
                    int entitiesToAdd;
                    entities.sort((e1, e2) -> (int)(((class_1309)e1).method_6032() - ((class_1309)e2).method_6032()));
                    int rageLeft = BzGeneralConfigs.ragingEssenceStrengthLevels.length - rageState;
                    for (int i = entitiesToAdd = Math.min(rageLeft + 1, 4) - currentTargetsToKill.size(); i >= 1 && !entities.isEmpty(); --i) {
                        if (i == 1) {
                            currentTargetsToKill.add(((class_1297)entities.remove(entities.size() - 1)).method_5667());
                            continue;
                        }
                        currentTargetsToKill.add(((class_1297)entities.remove(0)).method_5667());
                    }
                    RagingEssence.setCurrentTargets(itemStack, currentTargetsToKill);
                    return;
                }
                if (!currentTargetsToKill.isEmpty()) {
                    for (UUID uuid : currentTargetsToKill) {
                        class_1297 entity = serverPlayer.method_51469().method_14190(uuid);
                        if (entity != null && !(entity.method_5707(serverPlayer.method_19538()) > 5308416.0)) continue;
                        RagingEssence.resetRage(itemStack, serverPlayer);
                        return;
                    }
                }
                if (rageState > 0) {
                    List<class_6880> radianceEffects = class_7923.field_41174.method_40266(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(class_6885.class_6887::method_40239).filter(class_6880::method_40227).toList();
                    for (class_6880 effectHolder : radianceEffects) {
                        if (effectHolder.comp_349() == class_1294.field_5910) {
                            serverPlayer.method_6092(new class_1293(class_1294.field_5910, (int)((level.method_8510() - RagingEssence.getEmpoweredTimestamp(itemStack)) * 4L), BzGeneralConfigs.ragingEssenceStrengthLevels[rageState - 1] - 1, false, false));
                            continue;
                        }
                        serverPlayer.method_6092(new class_1293(effectHolder, (int)((level.method_8510() - RagingEssence.getEmpoweredTimestamp(itemStack)) * 4L), (int)rageState, false, false));
                    }
                }
            }
        }
    }

    public static void OnEntityDeath(BzEntityDeathEvent event) {
        class_1282 damageSource = event.source();
        class_1309 livingEntity = event.entity();
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_3222) {
            class_1792 class_17922;
            class_3222 player = (class_3222)class_12972;
            class_1799 itemStack = player.method_6079();
            AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
            if (livingEntity.method_29504() && (class_17922 = itemStack.method_7909()) instanceof RagingEssence) {
                RagingEssence ragingEssence = (RagingEssence)class_17922;
                if (abilityEssenceActivityData.isActive() && !player.method_7357().method_7904(itemStack.method_7909())) {
                    List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(itemStack);
                    short rageState = RagingEssence.getRageState(itemStack);
                    if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length || currentTargetsToKill.contains(livingEntity.method_5667())) {
                        if (rageState >= BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                            RagingEssence.resetRage(itemStack, player);
                        } else {
                            RagingEssence.setRageState(itemStack, (short)(rageState + 1));
                            RagingEssence.setEmpoweredTimestamp(itemStack, livingEntity.method_37908().method_8510());
                            currentTargetsToKill.remove(livingEntity.method_5667());
                            RagingEssence.setCurrentTargets(itemStack, currentTargetsToKill);
                            ragingEssence.decrementAbilityUseRemaining(itemStack, player, 1);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTargetable(class_1297 entity, UUID playerUUID) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (entity.method_5655()) return false;
        if (!livingEntity.method_6102()) return false;
        if (livingEntity.method_29504()) return false;
        if (entity instanceof class_1569) return true;
        if (!(entity instanceof class_5354)) return false;
        class_5354 neutralMob = (class_5354)entity;
        if (neutralMob.method_29508() != playerUUID) return false;
        return true;
    }

    private static void resetRage(class_1799 stack, class_3222 serverPlayer) {
        RagingEssence.setCurrentTargets(stack, new ArrayList<UUID>());
        RagingEssence.setRageState(stack, (short)0);
        List<class_6880> radianceEffects = class_7923.field_41174.method_40266(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(class_6885.class_6887::method_40239).filter(class_6880::method_40227).toList();
        for (class_6880 effectHolder : radianceEffects) {
            serverPlayer.method_6016(effectHolder);
        }
        serverPlayer.method_51469().method_14199((class_2394)class_2398.field_11203, serverPlayer.method_19538().method_10216(), serverPlayer.method_19538().method_10214() + 1.0, serverPlayer.method_19538().method_10215(), 50, serverPlayer.method_59922().method_43059() * 0.3, serverPlayer.method_59922().method_43059() * 0.25 + 0.1, serverPlayer.method_59922().method_43059() * 0.3, (double)0.06f);
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random, int rageState) {
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
            rageState *= 2;
        }
        world.method_14199((class_2394)class_2398.field_11240, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), rageState, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, (double)0.02f);
        world.method_14199((class_2394)class_2398.field_11205, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), rageState, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, (double)0.1f);
    }

    public static boolean IsRagingEssenceActive(class_1657 player) {
        if (player != null) {
            class_1799 offHandItem = player.method_6079();
            return offHandItem.method_31574((class_1792)BzItems.ESSENCE_RAGING.get()) && ((AbilityEssenceActivityData)offHandItem.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive() && !player.method_7357().method_7904(offHandItem.method_7909());
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(class_1297 entity, class_1657 player) {
        return RagingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(class_1297 entity, class_1657 player) {
        class_1799 stack = player.method_6079();
        short rageState = RagingEssence.getRageState(stack);
        List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length && RagingEssence.isTargetable(entity, player.method_5667()) || currentTargetsToKill.contains(entity.method_5667())) {
            if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                float percentage = Math.abs((float)(player.field_6012 % 40 - 20) / 20.0f);
                int red = 255;
                int green = class_3532.method_48781((float)percentage, (int)0, (int)128);
                return (red & 0xFF) << 16 | (green & 0xFF) << 8;
            }
            float percentage = (float)rageState / (float)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            return class_3532.method_48781((float)percentage, (int)85, (int)255) << 16;
        }
        return -1;
    }
}

